/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Writable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.groovy.io.StringBuilderWriter;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.syntax.Types;

public class ConfigObject
extends GroovyObjectSupport
implements Writable,
Map,
Cloneable {
    static final Collection<String> KEYWORDS = Types.getKeywords();
    static final String TAB_CHARACTER = "\t";
    private URL configFile;
    private HashMap delegateMap = new LinkedHashMap();

    public ConfigObject(URL file) {
        this.configFile = file;
    }

    public ConfigObject() {
        this(null);
    }

    public URL getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(URL configFile) {
        this.configFile = configFile;
    }

    @Override
    public Writer writeTo(Writer outArg) throws IOException {
        BufferedWriter out = new BufferedWriter(outArg);
        try {
            this.writeConfig("", this, out, 0, false);
        }
        finally {
            out.flush();
        }
        return outArg;
    }

    @Override
    public Object getProperty(String name2) {
        if ("configFile".equals(name2)) {
            return this.configFile;
        }
        if (!this.containsKey(name2)) {
            ConfigObject prop = new ConfigObject(this.configFile);
            this.put(name2, prop);
            return prop;
        }
        return this.get(name2);
    }

    public Map flatten() {
        return this.flatten(null);
    }

    public Map flatten(Map target) {
        if (target == null) {
            target = new ConfigObject();
        }
        this.populate("", target, this);
        return target;
    }

    public Map merge(ConfigObject other) {
        return this.doMerge(this, other);
    }

    public Properties toProperties() {
        Properties props = new Properties();
        this.flatten(props);
        props = ConfigObject.convertValuesToString(props);
        return props;
    }

    public Properties toProperties(String prefix) {
        Properties props = new Properties();
        this.populate(prefix + ".", props, this);
        props = ConfigObject.convertValuesToString(props);
        return props;
    }

    private Map doMerge(Map config, Map other) {
        Iterator iterator2 = other.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry o;
            Map.Entry next2 = o = iterator2.next();
            Object key = next2.getKey();
            Object value2 = next2.getValue();
            Object configEntry = config.get(key);
            if (configEntry == null) {
                config.put(key, value2);
                continue;
            }
            if (configEntry instanceof Map && !((Map)configEntry).isEmpty() && value2 instanceof Map) {
                this.doMerge((Map)configEntry, (Map)value2);
                continue;
            }
            config.put(key, value2);
        }
        return config;
    }

    private void writeConfig(String prefix, ConfigObject map2, BufferedWriter out, int tab, boolean apply2) throws IOException {
        String space = apply2 ? StringGroovyMethods.multiply(TAB_CHARACTER, (Number)tab) : "";
        for (Object o1 : map2.keySet()) {
            String key = (String)o1;
            Object v = map2.get(key);
            if (v instanceof ConfigObject) {
                ConfigObject value2 = (ConfigObject)v;
                if (value2.isEmpty()) continue;
                Map.Entry dotsInKeys = null;
                for (Object o : value2.entrySet()) {
                    Map.Entry e = (Map.Entry)o;
                    String k = (String)e.getKey();
                    if (k.indexOf(46) <= -1) continue;
                    dotsInKeys = e;
                    break;
                }
                int configSize = value2.size();
                Object firstKey = value2.keySet().iterator().next();
                Object firstValue = value2.values().iterator().next();
                int firstSize = firstValue instanceof ConfigObject ? ((ConfigObject)firstValue).size() : 1;
                if (configSize == 1 || DefaultGroovyMethods.asBoolean(dotsInKeys)) {
                    if (firstSize == 1 && firstValue instanceof ConfigObject) {
                        key = KEYWORDS.contains(key) ? InvokerHelper.inspect(key) : key;
                        String writePrefix = prefix + key + "." + firstKey + ".";
                        this.writeConfig(writePrefix, (ConfigObject)firstValue, out, tab, true);
                        continue;
                    }
                    if (!DefaultGroovyMethods.asBoolean(dotsInKeys) && firstValue instanceof ConfigObject) {
                        this.writeNode(key, space, tab, value2, out);
                        continue;
                    }
                    for (Object j : value2.keySet()) {
                        Object k2;
                        Object v2 = value2.get(j);
                        Object object = k2 = ((String)j).indexOf(46) > -1 ? InvokerHelper.inspect(j) : j;
                        if (v2 instanceof ConfigObject) {
                            key = KEYWORDS.contains(key) ? InvokerHelper.inspect(key) : key;
                            this.writeConfig(prefix + key, (ConfigObject)v2, out, tab, false);
                            continue;
                        }
                        ConfigObject.writeValue(key + "." + k2, space, prefix, v2, out);
                    }
                    continue;
                }
                this.writeNode(key, space, tab, value2, out);
                continue;
            }
            ConfigObject.writeValue(key, space, prefix, v, out);
        }
    }

    private static void writeValue(String key, String space, String prefix, Object value2, BufferedWriter out) throws IOException {
        boolean isKeyword = KEYWORDS.contains(key);
        String string2 = key = isKeyword ? InvokerHelper.inspect(key) : key;
        if (!StringGroovyMethods.asBoolean(prefix) && isKeyword) {
            prefix = "this.";
        }
        out.append(space).append(prefix).append(key).append('=').append(InvokerHelper.inspect(value2));
        out.newLine();
    }

    private void writeNode(String key, String space, int tab, ConfigObject value2, BufferedWriter out) throws IOException {
        key = KEYWORDS.contains(key) ? InvokerHelper.inspect(key) : key;
        out.append(space).append(key).append(" {");
        out.newLine();
        this.writeConfig("", value2, out, tab + 1, true);
        out.append(space).append('}');
        out.newLine();
    }

    private static Properties convertValuesToString(Map props) {
        Properties newProps = new Properties();
        Iterator iterator2 = props.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry o;
            Map.Entry next2 = o = iterator2.next();
            Object key = next2.getKey();
            Object value2 = next2.getValue();
            newProps.put(key, value2 != null ? value2.toString() : null);
        }
        return newProps;
    }

    private void populate(String suffix, Map config, Map map2) {
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry o;
            Map.Entry next2 = o = iterator2.next();
            Object key = next2.getKey();
            Object value2 = next2.getValue();
            if (value2 instanceof Map) {
                this.populate(suffix + key + ".", config, (Map)value2);
                continue;
            }
            try {
                config.put(suffix + key, value2);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Override
    public int size() {
        return this.delegateMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegateMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegateMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.delegateMap.containsValue(value2);
    }

    public Object get(Object key) {
        return this.delegateMap.get(key);
    }

    public Object put(Object key, Object value2) {
        return this.delegateMap.put(key, value2);
    }

    public Object remove(Object key) {
        return this.delegateMap.remove(key);
    }

    public void putAll(Map m) {
        this.delegateMap.putAll(m);
    }

    @Override
    public void clear() {
        this.delegateMap.clear();
    }

    public Set keySet() {
        return this.delegateMap.keySet();
    }

    public Collection values() {
        return this.delegateMap.values();
    }

    public Set entrySet() {
        return this.delegateMap.entrySet();
    }

    public ConfigObject clone() {
        try {
            ConfigObject clone2 = (ConfigObject)super.clone();
            clone2.configFile = this.configFile;
            clone2.delegateMap = (LinkedHashMap)this.delegateMap.clone();
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public Boolean isSet(String option2) {
        Object entry2;
        if (!(!this.delegateMap.containsKey(option2) || (entry2 = this.delegateMap.get(option2)) instanceof ConfigObject && ((ConfigObject)entry2).isEmpty())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String prettyPrint() {
        StringBuilderWriter sw = new StringBuilderWriter();
        try {
            this.writeTo(sw);
        }
        catch (IOException e) {
            throw new GroovyRuntimeException(e);
        }
        return ((Object)sw).toString();
    }

    public String toString() {
        StringBuilderWriter sw = new StringBuilderWriter();
        try {
            InvokerHelper.write(sw, this);
        }
        catch (IOException e) {
            throw new GroovyRuntimeException(e);
        }
        return ((Object)sw).toString();
    }
}

