/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.options;

import groovy.lang.ReadOnlyPropertyException;
import groovy.transform.options.PropertyHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.groovy.ast.tools.ImmutablePropertyUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.transform.MapConstructorASTTransformation;

public class ImmutablePropertyHandler
extends PropertyHandler {
    private static final ClassNode CLONEABLE_TYPE = ClassHelper.make(Cloneable.class);
    private static final ClassNode COLLECTION_TYPE = ClassHelper.makeWithoutCaching(Collection.class, false);
    private static final ClassNode DGM_TYPE = ClassHelper.make(DefaultGroovyMethods.class);
    private static final ClassNode SELF_TYPE = ClassHelper.make(ImmutableASTTransformation.class);
    private static final ClassNode MAP_TYPE = ClassHelper.makeWithoutCaching(Map.class, false);
    private static final ClassNode SORTEDSET_CLASSNODE = ClassHelper.make(SortedSet.class);
    private static final ClassNode SORTEDMAP_CLASSNODE = ClassHelper.make(SortedMap.class);
    private static final ClassNode SET_CLASSNODE = ClassHelper.make(Set.class);
    private static final ClassNode MAP_CLASSNODE = ClassHelper.make(Map.class);
    private static final ClassNode READONLYEXCEPTION_TYPE = ClassHelper.make(ReadOnlyPropertyException.class);

    @Override
    public Statement createPropGetter(PropertyNode pNode) {
        FieldNode fNode = pNode.getField();
        BlockStatement body2 = new BlockStatement();
        ClassNode fieldType = fNode.getType();
        Statement statement2 = fieldType.isArray() || ImmutablePropertyUtils.implementsCloneable(fieldType) ? this.createGetterBodyArrayOrCloneable(fNode) : (ImmutablePropertyUtils.derivesFromDate(fieldType) ? this.createGetterBodyDate(fNode) : ImmutablePropertyHandler.createGetterBodyDefault(fNode));
        body2.addStatement(statement2);
        return body2;
    }

    @Override
    public Statement createPropSetter(PropertyNode pNode) {
        return null;
    }

    @Override
    public boolean validateAttributes(AbstractASTTransformation xform, AnnotationNode anno) {
        boolean success2 = this.isValidAttribute(xform, anno, "useSuper");
        return success2;
    }

    @Override
    public boolean validateProperties(AbstractASTTransformation xform, BlockStatement body2, ClassNode cNode, List<PropertyNode> props) {
        if (xform instanceof MapConstructorASTTransformation) {
            body2.addStatement(GeneralUtils.ifS((Expression)GeneralUtils.equalsNullX(GeneralUtils.varX("args")), GeneralUtils.assignS(GeneralUtils.varX("args"), new MapExpression())));
            body2.addStatement(GeneralUtils.stmt(GeneralUtils.callX(SELF_TYPE, "checkPropNames", (Expression)GeneralUtils.args("this", "args"))));
        }
        return super.validateProperties(xform, body2, cNode, props);
    }

    @Override
    public Statement createPropInit(AbstractASTTransformation xform, AnnotationNode anno, ClassNode cNode, PropertyNode pNode, Parameter namedArgsMap) {
        FieldNode fNode = pNode.getField();
        if (fNode.isFinal() && fNode.isStatic()) {
            return null;
        }
        if (fNode.isFinal() && fNode.getInitialExpression() != null) {
            return this.checkFinalArgNotOverridden(cNode, fNode);
        }
        return this.createConstructorStatement(xform, cNode, pNode, namedArgsMap);
    }

    private static Statement createGetterBodyDefault(FieldNode fNode) {
        VariableExpression fieldExpr = GeneralUtils.varX(fNode);
        return GeneralUtils.stmt(fieldExpr);
    }

    private Statement createGetterBodyArrayOrCloneable(FieldNode fNode) {
        VariableExpression fieldExpr = GeneralUtils.varX(fNode);
        Expression expression2 = ImmutablePropertyUtils.cloneArrayOrCloneableExpr(fieldExpr, fNode.getType());
        return GeneralUtils.safeExpression(fieldExpr, expression2);
    }

    private Statement createGetterBodyDate(FieldNode fNode) {
        VariableExpression fieldExpr = GeneralUtils.varX(fNode);
        Expression expression2 = ImmutablePropertyUtils.cloneDateExpr(fieldExpr);
        return GeneralUtils.safeExpression(fieldExpr, expression2);
    }

    protected Expression cloneCollectionExpr(Expression fieldExpr, ClassNode type) {
        return GeneralUtils.castX(type, this.createIfInstanceOfAsImmutableS(fieldExpr, SORTEDSET_CLASSNODE, this.createIfInstanceOfAsImmutableS(fieldExpr, SORTEDMAP_CLASSNODE, this.createIfInstanceOfAsImmutableS(fieldExpr, SET_CLASSNODE, this.createIfInstanceOfAsImmutableS(fieldExpr, MAP_CLASSNODE, this.createIfInstanceOfAsImmutableS(fieldExpr, ClassHelper.LIST_TYPE, this.createAsImmutableX(fieldExpr, COLLECTION_TYPE)))))));
    }

    private Expression createIfInstanceOfAsImmutableS(Expression expr2, ClassNode type, Expression elseStatement) {
        return GeneralUtils.ternaryX(GeneralUtils.isInstanceOfX(expr2, type), this.createAsImmutableX(expr2, type), elseStatement);
    }

    protected Expression createAsImmutableX(Expression expr2, ClassNode type) {
        return GeneralUtils.callX(DGM_TYPE, "asImmutable", (Expression)GeneralUtils.castX(type, expr2));
    }

    @Deprecated
    protected Statement createConstructorStatement(AbstractASTTransformation xform, ClassNode cNode, PropertyNode pNode, boolean namedArgs) {
        Statement statement2;
        List<String> knownImmutableClasses = ImmutablePropertyUtils.getKnownImmutableClasses(xform, cNode);
        List<String> knownImmutables = ImmutablePropertyUtils.getKnownImmutables(xform, cNode);
        FieldNode fNode = pNode.getField();
        ClassNode fType = fNode.getType();
        if (ImmutablePropertyUtils.isKnownImmutableType(fType, knownImmutableClasses) || ImmutablePropertyHandler.isKnownImmutable(pNode.getName(), knownImmutables)) {
            statement2 = ImmutablePropertyHandler.createConstructorStatementDefault(fNode, namedArgs);
        } else if (fType.isArray() || ImmutablePropertyUtils.implementsCloneable(fType)) {
            statement2 = ImmutablePropertyHandler.createConstructorStatementArrayOrCloneable(fNode, namedArgs);
        } else if (ImmutablePropertyUtils.derivesFromDate(fType)) {
            statement2 = ImmutablePropertyHandler.createConstructorStatementDate(fNode, namedArgs);
        } else if (GeneralUtils.isOrImplements(fType, COLLECTION_TYPE) || fType.isDerivedFrom(COLLECTION_TYPE) || GeneralUtils.isOrImplements(fType, MAP_TYPE) || fType.isDerivedFrom(MAP_TYPE)) {
            statement2 = this.createConstructorStatementCollection(fNode, namedArgs);
        } else if (fType.isResolved()) {
            xform.addError(ImmutablePropertyUtils.createErrorMessage(cNode.getName(), fNode.getName(), fType.getName(), "compiling"), fNode);
            statement2 = EmptyStatement.INSTANCE;
        } else {
            statement2 = ImmutablePropertyHandler.createConstructorStatementGuarded(cNode, fNode, namedArgs, knownImmutables, knownImmutableClasses);
        }
        return statement2;
    }

    protected Statement createConstructorStatement(AbstractASTTransformation xform, ClassNode cNode, PropertyNode pNode, Parameter namedArgsMap) {
        Statement statement2;
        List<String> knownImmutableClasses = ImmutablePropertyUtils.getKnownImmutableClasses(xform, cNode);
        List<String> knownImmutables = ImmutablePropertyUtils.getKnownImmutables(xform, cNode);
        FieldNode fNode = pNode.getField();
        ClassNode fType = fNode.getType();
        if (ImmutablePropertyUtils.isKnownImmutableType(fType, knownImmutableClasses) || ImmutablePropertyHandler.isKnownImmutable(pNode.getName(), knownImmutables)) {
            statement2 = ImmutablePropertyHandler.createConstructorStatementDefault(fNode, namedArgsMap);
        } else if (fType.isArray() || ImmutablePropertyUtils.implementsCloneable(fType)) {
            statement2 = ImmutablePropertyHandler.createConstructorStatementArrayOrCloneable(fNode, namedArgsMap);
        } else if (ImmutablePropertyUtils.derivesFromDate(fType)) {
            statement2 = ImmutablePropertyHandler.createConstructorStatementDate(fNode, namedArgsMap);
        } else if (GeneralUtils.isOrImplements(fType, COLLECTION_TYPE) || fType.isDerivedFrom(COLLECTION_TYPE) || GeneralUtils.isOrImplements(fType, MAP_TYPE) || fType.isDerivedFrom(MAP_TYPE)) {
            statement2 = this.createConstructorStatementCollection(fNode, namedArgsMap);
        } else if (fType.isResolved()) {
            xform.addError(ImmutablePropertyUtils.createErrorMessage(cNode.getName(), fNode.getName(), fType.getName(), "compiling"), fNode);
            statement2 = EmptyStatement.INSTANCE;
        } else {
            statement2 = ImmutablePropertyHandler.createConstructorStatementGuarded(fNode, namedArgsMap, knownImmutables, knownImmutableClasses);
        }
        return statement2;
    }

    private static Statement createConstructorStatementDefault(FieldNode fNode, boolean namedArgs) {
        ClassNode fType = fNode.getType();
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? (ClassHelper.isPrimitiveType(fType) ? EmptyStatement.INSTANCE : GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION)) : GeneralUtils.assignS(fieldExpr, initExpr);
        fNode.setInitialValueExpression(null);
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgs);
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, GeneralUtils.castX(fType, param2));
        return ImmutablePropertyHandler.assignWithDefault(namedArgs, assignInit, param2, assignStmt);
    }

    private static Statement createConstructorStatementDefault(FieldNode fNode, Parameter namedArgsMap) {
        ClassNode fType = fNode.getType();
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgsMap != null);
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, GeneralUtils.castX(fType, param2));
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? (ClassHelper.isPrimitiveType(fType) ? EmptyStatement.INSTANCE : GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION)) : GeneralUtils.assignS(fieldExpr, initExpr);
        return ImmutablePropertyHandler.assignFieldWithDefault(namedArgsMap, fNode, assignStmt, assignInit);
    }

    private static Statement assignFieldWithDefault(Parameter map2, FieldNode fNode, Statement assignStmt, Statement assignInit) {
        if (map2 == null) {
            return assignStmt;
        }
        ArgumentListExpression nameArg = GeneralUtils.args(GeneralUtils.constX(fNode.getName()));
        MethodCallExpression var = GeneralUtils.callX((Expression)GeneralUtils.varX(map2), "get", (Expression)nameArg);
        var.setImplicitThis(false);
        MethodCallExpression containsKey = GeneralUtils.callX((Expression)GeneralUtils.varX(map2), "containsKey", (Expression)nameArg);
        containsKey.setImplicitThis(false);
        fNode.getDeclaringClass().getField(fNode.getName()).setInitialValueExpression(null);
        return GeneralUtils.ifElseS(containsKey, assignStmt, assignInit);
    }

    private static Statement assignWithDefault(boolean namedArgs, Statement assignInit, Expression param2, Statement assignStmt) {
        if (!namedArgs) {
            return assignStmt;
        }
        return GeneralUtils.ifElseS(GeneralUtils.equalsNullX(param2), assignInit, assignStmt);
    }

    private static Statement createConstructorStatementGuarded(ClassNode cNode, FieldNode fNode, boolean namedArgs, List<String> knownImmutables, List<String> knownImmutableClasses) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, ImmutablePropertyHandler.checkUnresolved(fNode, initExpr, knownImmutables, knownImmutableClasses));
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgs);
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, ImmutablePropertyHandler.checkUnresolved(fNode, param2, knownImmutables, knownImmutableClasses));
        return ImmutablePropertyHandler.assignWithDefault(namedArgs, assignInit, param2, assignStmt);
    }

    private static Statement createConstructorStatementGuarded(FieldNode fNode, Parameter namedArgsMap, List<String> knownImmutables, List<String> knownImmutableClasses) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgsMap != null);
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, ImmutablePropertyHandler.checkUnresolved(fNode, param2, knownImmutables, knownImmutableClasses));
        assignStmt = GeneralUtils.ifElseS(GeneralUtils.equalsNullX(param2), GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION), assignStmt);
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, ImmutablePropertyHandler.checkUnresolved(fNode, initExpr, knownImmutables, knownImmutableClasses));
        return ImmutablePropertyHandler.assignFieldWithDefault(namedArgsMap, fNode, assignStmt, assignInit);
    }

    private static Expression checkUnresolved(FieldNode fNode, Expression value2, List<String> knownImmutables, List<String> knownImmutableClasses) {
        ArgumentListExpression args2 = GeneralUtils.args(GeneralUtils.callThisX("getClass"), GeneralUtils.constX(fNode.getName()), value2, GeneralUtils.list2args(knownImmutables), GeneralUtils.classList2args(knownImmutableClasses));
        return GeneralUtils.callX(SELF_TYPE, "checkImmutable", (Expression)args2);
    }

    private Statement createConstructorStatementCollection(FieldNode fNode, boolean namedArgs) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        ClassNode fieldType = fieldExpr.getType();
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, this.cloneCollectionExpr(initExpr, fieldType));
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgs);
        Statement assignStmt = GeneralUtils.ifElseS(GeneralUtils.isInstanceOfX(param2, CLONEABLE_TYPE), GeneralUtils.assignS(fieldExpr, this.cloneCollectionExpr(ImmutablePropertyUtils.cloneArrayOrCloneableExpr(param2, fieldType), fieldType)), GeneralUtils.assignS(fieldExpr, this.cloneCollectionExpr(param2, fieldType)));
        return ImmutablePropertyHandler.assignWithDefault(namedArgs, assignInit, param2, assignStmt);
    }

    private Statement createConstructorStatementCollection(FieldNode fNode, Parameter namedArgsMap) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        ClassNode fieldType = fieldExpr.getType();
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgsMap != null);
        Statement assignStmt = GeneralUtils.ifElseS(GeneralUtils.isInstanceOfX(param2, CLONEABLE_TYPE), GeneralUtils.assignS(fieldExpr, this.cloneCollectionExpr(ImmutablePropertyUtils.cloneArrayOrCloneableExpr(param2, fieldType), fieldType)), GeneralUtils.assignS(fieldExpr, this.cloneCollectionExpr(param2, fieldType)));
        assignStmt = GeneralUtils.ifElseS(GeneralUtils.equalsNullX(param2), GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION), assignStmt);
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, this.cloneCollectionExpr(initExpr, fieldType));
        return ImmutablePropertyHandler.assignFieldWithDefault(namedArgsMap, fNode, assignStmt, assignInit);
    }

    private static Statement createConstructorStatementArrayOrCloneable(FieldNode fNode, boolean namedArgs) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        Expression initExpr = fNode.getInitialValueExpression();
        ClassNode fieldType = fNode.getType();
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgs);
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneArrayOrCloneableExpr(initExpr, fieldType));
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneArrayOrCloneableExpr(param2, fieldType));
        return ImmutablePropertyHandler.assignWithDefault(namedArgs, assignInit, param2, assignStmt);
    }

    private static Statement createConstructorStatementArrayOrCloneable(FieldNode fNode, Parameter namedArgsMap) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        ClassNode fieldType = fNode.getType();
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgsMap != null);
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneArrayOrCloneableExpr(param2, fieldType));
        assignStmt = GeneralUtils.ifElseS(GeneralUtils.equalsNullX(param2), GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION), assignStmt);
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneArrayOrCloneableExpr(initExpr, fieldType));
        return ImmutablePropertyHandler.assignFieldWithDefault(namedArgsMap, fNode, assignStmt, assignInit);
    }

    private static Expression getParam(FieldNode fNode, boolean namedArgs) {
        return namedArgs ? GeneralUtils.findArg(fNode.getName()) : GeneralUtils.varX(fNode.getName(), fNode.getType());
    }

    private static Statement createConstructorStatementDate(FieldNode fNode, boolean namedArgs) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneDateExpr(initExpr));
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgs);
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneDateExpr(param2));
        return ImmutablePropertyHandler.assignWithDefault(namedArgs, assignInit, param2, assignStmt);
    }

    private static Statement createConstructorStatementDate(FieldNode fNode, Parameter namedArgsMap) {
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), fNode.getName());
        Expression param2 = ImmutablePropertyHandler.getParam(fNode, namedArgsMap != null);
        Statement assignStmt = GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneDateExpr(param2));
        assignStmt = GeneralUtils.ifElseS(GeneralUtils.equalsNullX(param2), GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION), assignStmt);
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION) : GeneralUtils.assignS(fieldExpr, ImmutablePropertyUtils.cloneDateExpr(initExpr));
        return ImmutablePropertyHandler.assignFieldWithDefault(namedArgsMap, fNode, assignStmt, assignInit);
    }

    private static boolean isKnownImmutable(String fieldName, List<String> knownImmutables) {
        return knownImmutables.contains(fieldName);
    }

    protected Statement checkFinalArgNotOverridden(ClassNode cNode, FieldNode fNode) {
        String name2 = fNode.getName();
        Expression value2 = GeneralUtils.findArg(name2);
        return GeneralUtils.ifS((Expression)GeneralUtils.notX(GeneralUtils.equalsNullX(value2)), GeneralUtils.throwS(GeneralUtils.ctorX(READONLYEXCEPTION_TYPE, GeneralUtils.args(GeneralUtils.constX(name2), GeneralUtils.constX(cNode.getName())))));
    }
}

