/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.builder;

import groovy.transform.Undefined;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.transform.BuilderASTTransformation;

public class ExternalStrategy
extends BuilderASTTransformation.AbstractBuilderStrategy {
    private static final Expression DEFAULT_INITIAL_VALUE = null;

    @Override
    public void build(BuilderASTTransformation transform2, AnnotatedNode annotatedNode, AnnotationNode anno) {
        if (!(annotatedNode instanceof ClassNode)) {
            transform2.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: building for " + annotatedNode.getClass().getSimpleName() + " not supported by " + this.getClass().getSimpleName(), annotatedNode);
            return;
        }
        ClassNode builder = (ClassNode)annotatedNode;
        String prefix = BuilderASTTransformation.getMemberStringValue(anno, "prefix", "");
        ClassNode buildee = transform2.getMemberClassValue(anno, "forClass");
        if (buildee == null) {
            transform2.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: 'forClass' must be specified for " + this.getClass().getName(), anno);
            return;
        }
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes2 = new ArrayList<String>();
        includes2.add("<DummyUndefinedMarkerString-DoNotUse>");
        if (!this.getIncludeExclude(transform2, anno, buildee, excludes, includes2)) {
            return;
        }
        if (includes2.size() == 1 && Undefined.isUndefined((String)includes2.get(0))) {
            includes2 = null;
        }
        if (this.unsupportedAttribute(transform2, anno, "builderClassName")) {
            return;
        }
        if (this.unsupportedAttribute(transform2, anno, "builderMethodName")) {
            return;
        }
        if (this.unsupportedAttribute(transform2, anno, "force")) {
            return;
        }
        boolean allNames = transform2.memberHasValue(anno, "allNames", true);
        boolean allProperties = !transform2.memberHasValue(anno, "allProperties", false);
        List<BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo> props = this.getPropertyInfos(transform2, anno, buildee, excludes, includes2, allNames, allProperties);
        if (includes2 != null) {
            for (String name2 : includes2) {
                this.checkKnownProperty(transform2, anno, name2, props);
            }
        }
        for (BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo prop : props) {
            builder.addField(ExternalStrategy.createFieldCopy(builder, prop));
            builder.addMethod(this.createBuilderMethodForField(builder, prop, prefix));
        }
        builder.addMethod(ExternalStrategy.createBuildMethod(transform2, anno, buildee, props));
    }

    private static MethodNode createBuildMethod(BuilderASTTransformation transform2, AnnotationNode anno, ClassNode sourceClass, List<BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo> fields) {
        String buildMethodName = BuilderASTTransformation.getMemberStringValue(anno, "buildMethodName", "build");
        BlockStatement body2 = new BlockStatement();
        Expression sourceClassInstance = ExternalStrategy.initializeInstance(sourceClass, fields, body2);
        body2.addStatement(GeneralUtils.returnS(sourceClassInstance));
        return new MethodNode(buildMethodName, 1, sourceClass, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body2);
    }

    private MethodNode createBuilderMethodForField(ClassNode builderClass, BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo prop, String prefix) {
        String propName = prop.getName().equals("class") ? "clazz" : prop.getName();
        String setterName = this.getSetterName(prefix, prop.getName());
        return new MethodNode(setterName, 1, GenericsUtils.newClass(builderClass), GeneralUtils.params(GeneralUtils.param(GenericsUtils.newClass(prop.getType()), propName)), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(propName)), GeneralUtils.varX(propName))), GeneralUtils.returnS(GeneralUtils.varX("this", GenericsUtils.newClass(builderClass)))));
    }

    private static FieldNode createFieldCopy(ClassNode builderClass, BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo prop) {
        String propName = prop.getName();
        return new FieldNode(propName.equals("class") ? "clazz" : propName, 2, GenericsUtils.newClass(prop.getType()), builderClass, DEFAULT_INITIAL_VALUE);
    }

    private static Expression initializeInstance(ClassNode sourceClass, List<BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo> props, BlockStatement body2) {
        VariableExpression instance = GeneralUtils.localVarX("_the" + sourceClass.getNameWithoutPackage(), sourceClass);
        body2.addStatement(GeneralUtils.declS(instance, GeneralUtils.ctorX(sourceClass)));
        for (BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo prop : props) {
            body2.addStatement(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)instance, prop.getName()), GeneralUtils.varX(prop.getName().equals("class") ? "clazz" : prop.getName(), GenericsUtils.newClass(prop.getType())))));
        }
        return instance;
    }
}

