/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.builder;

import groovy.transform.Undefined;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.BuilderASTTransformation;

public class DefaultStrategy
extends BuilderASTTransformation.AbstractBuilderStrategy {
    private static final Expression DEFAULT_INITIAL_VALUE = null;
    private static final int PUBLIC_STATIC = 9;

    @Override
    public void build(BuilderASTTransformation transform2, AnnotatedNode annotatedNode, AnnotationNode anno) {
        if (this.unsupportedAttribute(transform2, anno, "forClass")) {
            return;
        }
        if (this.unsupportedAttribute(transform2, anno, "force")) {
            return;
        }
        if (annotatedNode instanceof ClassNode) {
            this.buildClass(transform2, (ClassNode)annotatedNode, anno);
        } else if (annotatedNode instanceof MethodNode) {
            this.buildMethod(transform2, (MethodNode)annotatedNode, anno);
        }
    }

    public void buildMethod(BuilderASTTransformation transform2, MethodNode mNode, AnnotationNode anno) {
        if (transform2.getMemberValue(anno, "includes") != null || transform2.getMemberValue(anno, "excludes") != null) {
            transform2.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: includes/excludes only allowed on classes", anno);
        }
        ClassNode buildee = mNode.getDeclaringClass();
        ClassNode builder = DefaultStrategy.createBuilder(anno, buildee);
        DefaultStrategy.createBuilderFactoryMethod(anno, buildee, builder);
        for (Parameter parameter : mNode.getParameters()) {
            builder.addField(DefaultStrategy.createFieldCopy(buildee, parameter));
            builder.addMethod(this.createBuilderMethodForProp(builder, new BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo(parameter.getName(), parameter.getType()), DefaultStrategy.getPrefix(anno)));
        }
        builder.addMethod(DefaultStrategy.createBuildMethodForMethod(anno, buildee, mNode, mNode.getParameters()));
    }

    public void buildClass(BuilderASTTransformation transform2, ClassNode buildee, AnnotationNode anno) {
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes2 = new ArrayList<String>();
        includes2.add("<DummyUndefinedMarkerString-DoNotUse>");
        if (!this.getIncludeExclude(transform2, anno, buildee, excludes, includes2)) {
            return;
        }
        if (includes2.size() == 1 && Undefined.isUndefined((String)includes2.get(0))) {
            includes2 = null;
        }
        ClassNode builder = DefaultStrategy.createBuilder(anno, buildee);
        DefaultStrategy.createBuilderFactoryMethod(anno, buildee, builder);
        boolean allNames = transform2.memberHasValue(anno, "allNames", true);
        boolean allProperties = !transform2.memberHasValue(anno, "allProperties", false);
        List<BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo> props = this.getPropertyInfos(transform2, anno, buildee, excludes, includes2, allNames, allProperties);
        for (BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo pi : props) {
            ClassNode correctedType = DefaultStrategy.getCorrectedType(buildee, pi.getType(), builder);
            String fieldName = pi.getName();
            builder.addField(DefaultStrategy.createFieldCopy(buildee, fieldName, correctedType));
            builder.addMethod(this.createBuilderMethodForProp(builder, new BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo(fieldName, correctedType), DefaultStrategy.getPrefix(anno)));
        }
        builder.addMethod(DefaultStrategy.createBuildMethod(anno, buildee, props));
    }

    private static ClassNode getCorrectedType(ClassNode buildee, ClassNode fieldType, ClassNode declaringClass) {
        Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(declaringClass);
        GenericsUtils.extractSuperClassGenerics(fieldType, buildee, genericsSpec);
        return GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, fieldType);
    }

    private static void createBuilderFactoryMethod(AnnotationNode anno, ClassNode buildee, ClassNode builder) {
        buildee.getModule().addClass(builder);
        buildee.addMethod(DefaultStrategy.createBuilderMethod(anno, builder));
    }

    private static ClassNode createBuilder(AnnotationNode anno, ClassNode buildee) {
        return new InnerClassNode(buildee, DefaultStrategy.getFullName(anno, buildee), 9, ClassHelper.OBJECT_TYPE);
    }

    private static String getFullName(AnnotationNode anno, ClassNode buildee) {
        String builderClassName = AbstractASTTransformation.getMemberStringValue(anno, "builderClassName", buildee.getNameWithoutPackage() + "Builder");
        return buildee.getName() + "$" + builderClassName;
    }

    private static String getPrefix(AnnotationNode anno) {
        return AbstractASTTransformation.getMemberStringValue(anno, "prefix", "");
    }

    private static MethodNode createBuildMethodForMethod(AnnotationNode anno, ClassNode buildee, MethodNode mNode, Parameter[] params2) {
        ClassNode returnType;
        String buildMethodName = AbstractASTTransformation.getMemberStringValue(anno, "buildMethodName", "build");
        BlockStatement body2 = new BlockStatement();
        if (mNode instanceof ConstructorNode) {
            returnType = GenericsUtils.newClass(buildee);
            body2.addStatement(GeneralUtils.returnS(GeneralUtils.ctorX(GenericsUtils.newClass(mNode.getDeclaringClass()), GeneralUtils.args(params2))));
        } else {
            body2.addStatement(GeneralUtils.returnS(GeneralUtils.callX(GenericsUtils.newClass(mNode.getDeclaringClass()), mNode.getName(), (Expression)GeneralUtils.args(params2))));
            returnType = GenericsUtils.newClass(mNode.getReturnType());
        }
        return new MethodNode(buildMethodName, 1, returnType, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body2);
    }

    private static MethodNode createBuilderMethod(AnnotationNode anno, ClassNode builder) {
        String builderMethodName = AbstractASTTransformation.getMemberStringValue(anno, "builderMethodName", "builder");
        BlockStatement body2 = new BlockStatement();
        body2.addStatement(GeneralUtils.returnS(GeneralUtils.ctorX(builder)));
        return new MethodNode(builderMethodName, 9, builder, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body2);
    }

    private static MethodNode createBuildMethod(AnnotationNode anno, ClassNode buildee, List<BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo> props) {
        String buildMethodName = AbstractASTTransformation.getMemberStringValue(anno, "buildMethodName", "build");
        BlockStatement body2 = new BlockStatement();
        body2.addStatement(GeneralUtils.returnS(DefaultStrategy.initializeInstance(buildee, props, body2)));
        return new MethodNode(buildMethodName, 1, GenericsUtils.newClass(buildee), BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body2);
    }

    private MethodNode createBuilderMethodForProp(ClassNode builder, BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo pinfo, String prefix) {
        ClassNode fieldType = pinfo.getType();
        String fieldName = pinfo.getName();
        String setterName = this.getSetterName(prefix, fieldName);
        return new MethodNode(setterName, 1, GenericsUtils.newClass(builder), GeneralUtils.params(GeneralUtils.param(fieldType, fieldName)), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(fieldName)), GeneralUtils.varX(fieldName, fieldType))), GeneralUtils.returnS(GeneralUtils.varX("this", builder))));
    }

    private static FieldNode createFieldCopy(ClassNode buildee, Parameter param2) {
        Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(buildee);
        GenericsUtils.extractSuperClassGenerics(param2.getType(), buildee, genericsSpec);
        ClassNode correctedParamType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, param2.getType());
        return new FieldNode(param2.getName(), 2, correctedParamType, buildee, param2.getInitialExpression());
    }

    private static FieldNode createFieldCopy(ClassNode buildee, String fieldName, ClassNode fieldType) {
        return new FieldNode(fieldName, 2, fieldType, buildee, DEFAULT_INITIAL_VALUE);
    }

    private static Expression initializeInstance(ClassNode buildee, List<BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo> props, BlockStatement body2) {
        VariableExpression instance = GeneralUtils.localVarX("_the" + buildee.getNameWithoutPackage(), buildee);
        body2.addStatement(GeneralUtils.declS(instance, GeneralUtils.ctorX(buildee)));
        for (BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo pi : props) {
            body2.addStatement(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)instance, pi.getName()), GeneralUtils.varX(pi.getName(), pi.getType()))));
        }
        return instance;
    }
}

