/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class Tuple<E>
extends AbstractList<E>
implements Serializable {
    private static final long serialVersionUID = -6707770506387821031L;
    private final E[] contents;

    @SafeVarargs
    public Tuple(E ... contents) {
        if (contents == null) {
            throw new NullPointerException();
        }
        this.contents = contents;
    }

    @Override
    public E get(int index2) {
        return this.contents[index2];
    }

    @Override
    public int size() {
        return this.contents.length;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int size2 = toIndex - fromIndex;
        Object[] newContent = new Object[size2];
        System.arraycopy(this.contents, fromIndex, newContent, 0, size2);
        return new Tuple<Object>(newContent);
    }

    public Tuple<E> subTuple(int fromIndex, int toIndex) {
        return (Tuple)this.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple that = (Tuple)o;
        int size2 = this.size();
        if (size2 != that.size()) {
            return false;
        }
        for (int i = 0; i < size2; ++i) {
            if (DefaultTypeTransformation.compareEqual(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.contents);
    }
}

