/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.NumberRange;
import groovy.lang.Range;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.RangeInfo;

public class IntRange
extends AbstractList<Integer>
implements Range<Integer> {
    private final int from;
    private final int to;
    private final boolean reverse;
    private final Boolean inclusive;

    public IntRange(int from2, int to2) {
        this.inclusive = null;
        if (from2 > to2) {
            this.from = to2;
            this.to = from2;
            this.reverse = true;
        } else {
            this.from = from2;
            this.to = to2;
            this.reverse = false;
        }
        this.checkSize();
    }

    protected IntRange(int from2, int to2, boolean reverse2) {
        this.inclusive = null;
        if (from2 > to2) {
            throw new IllegalArgumentException("'from' must be less than or equal to 'to'");
        }
        this.from = from2;
        this.to = to2;
        this.reverse = reverse2;
        this.checkSize();
    }

    public IntRange(boolean inclusive2, int from2, int to2) {
        this.from = from2;
        this.to = to2;
        this.inclusive = inclusive2;
        this.reverse = false;
        this.checkSize();
    }

    public <T extends Number> NumberRange by(T stepSize) {
        return new NumberRange(NumberRange.comparableNumber(this.from), NumberRange.comparableNumber(this.to), stepSize, this.inclusive);
    }

    private void checkSize() {
        long size2 = (long)this.to - (long)this.from + 1L;
        if (size2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("A range must have no more than 2147483647 elements but attempted " + size2 + " elements");
        }
    }

    public RangeInfo subListBorders(int size2) {
        int tempTo;
        if (this.inclusive == null) {
            throw new IllegalStateException("Should not call subListBorders on a non-inclusive aware IntRange");
        }
        int tempFrom = this.from;
        if (tempFrom < 0) {
            tempFrom += size2;
        }
        if ((tempTo = this.to) < 0) {
            tempTo += size2;
        }
        if (tempFrom > tempTo) {
            return new RangeInfo(this.inclusive != false ? tempTo : tempTo + 1, tempFrom + 1, true);
        }
        return new RangeInfo(tempFrom, this.inclusive != false ? tempTo + 1 : tempTo, false);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof IntRange ? this.equals((IntRange)that) : super.equals(that);
    }

    public boolean equals(IntRange that) {
        return that != null && (this.inclusive == null && this.reverse == that.reverse && this.from == that.from && this.to == that.to || this.inclusive != null && this.inclusive == that.inclusive && this.from == that.from && this.to == that.to);
    }

    @Override
    public Integer getFrom() {
        if (this.inclusive == null || this.from <= this.to) {
            return this.from;
        }
        return this.inclusive != false ? this.to : this.to + 1;
    }

    @Override
    public Integer getTo() {
        if (this.inclusive == null) {
            return this.to;
        }
        if (this.from <= this.to) {
            return this.inclusive != false ? this.to : this.to - 1;
        }
        return this.from;
    }

    public Boolean getInclusive() {
        return this.inclusive;
    }

    public int getFromInt() {
        return this.getFrom();
    }

    public int getToInt() {
        return this.getTo();
    }

    @Override
    public boolean isReverse() {
        return this.inclusive == null ? this.reverse : this.from > this.to;
    }

    @Override
    public boolean containsWithinBounds(Object o) {
        return this.contains(o);
    }

    @Override
    public Integer get(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " should not be negative");
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " too big for range: " + this);
        }
        return this.isReverse() ? this.getTo() - index2 : index2 + this.getFrom();
    }

    @Override
    public int size() {
        return this.getTo() - this.getFrom() + 1;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntRangeIterator();
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new EmptyRange<Integer>(this.getFrom());
        }
        return new IntRange(fromIndex + this.getFrom(), toIndex + this.getFrom() - 1, this.isReverse());
    }

    @Override
    public String toString() {
        return this.inclusive != null ? "" + this.from + ".." + (this.inclusive != false ? "" : "<") + this.to : (this.reverse ? "" + this.to + ".." + this.from : "" + this.from + ".." + this.to);
    }

    @Override
    public String inspect() {
        return this.toString();
    }

    @Override
    public boolean contains(Object value2) {
        if (value2 instanceof Integer) {
            return (Integer)value2 >= this.getFrom() && (Integer)value2 <= this.getTo();
        }
        if (value2 instanceof BigInteger) {
            BigInteger bigint = (BigInteger)value2;
            return bigint.compareTo(BigInteger.valueOf(this.getFrom().intValue())) >= 0 && bigint.compareTo(BigInteger.valueOf(this.getTo().intValue())) <= 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection other) {
        if (other instanceof IntRange) {
            IntRange range2 = (IntRange)other;
            return this.getFrom() <= range2.getFrom() && range2.getTo() <= this.getTo();
        }
        return super.containsAll(other);
    }

    @Override
    public void step(int step, Closure closure) {
        if (step == 0) {
            if (!this.getFrom().equals(this.getTo())) {
                throw new GroovyRuntimeException("Infinite loop detected due to step size of 0");
            }
            return;
        }
        if (this.isReverse()) {
            step = -step;
        }
        if (step > 0) {
            for (int value2 = this.getFrom().intValue(); value2 <= this.getTo(); value2 += step) {
                closure.call((Object)value2);
                if ((long)value2 + (long)step < Integer.MAX_VALUE) {
                    continue;
                }
                break;
            }
        } else {
            for (int value3 = this.getTo().intValue(); value3 >= this.getFrom(); value3 += step) {
                closure.call((Object)value3);
                if ((long)value3 + (long)step > Integer.MIN_VALUE) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public List<Integer> step(int step) {
        IteratorClosureAdapter adapter = new IteratorClosureAdapter(this);
        this.step(step, adapter);
        return adapter.asList();
    }

    @Override
    public int hashCode() {
        int from2 = this.getFrom();
        int to2 = this.getTo();
        int hashCode = (from2 + to2 + 1) * (from2 + to2) / 2 + to2;
        return hashCode;
    }

    private class IntRangeIterator
    implements Iterator<Integer> {
        private int index;
        private int size;
        private int value;

        private IntRangeIterator() {
            this.size = IntRange.this.size();
            this.value = IntRange.this.isReverse() ? IntRange.this.getTo() : IntRange.this.getFrom();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.index++ > 0) {
                this.value = IntRange.this.isReverse() ? --this.value : ++this.value;
            }
            return this.value;
        }

        @Override
        public void remove() {
            IntRange.this.remove(this.index);
        }
    }
}

