/*
 * Decompiled with CFR 0.152.
 */
package groovy.json;

import groovy.json.JsonException;
import groovy.json.JsonParser;
import groovy.json.JsonParserType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.apache.groovy.json.internal.JsonFastParser;
import org.apache.groovy.json.internal.JsonParserCharArray;
import org.apache.groovy.json.internal.JsonParserLax;
import org.apache.groovy.json.internal.JsonParserUsingCharacterSource;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;

public class JsonSlurper {
    private int maxSizeForInMemory = 2000000;
    private boolean chop = false;
    private boolean lazyChop = true;
    private boolean checkDates = true;
    private JsonParserType type = JsonParserType.CHAR_BUFFER;

    public int getMaxSizeForInMemory() {
        return this.maxSizeForInMemory;
    }

    public JsonSlurper setMaxSizeForInMemory(int maxSizeForInMemory) {
        this.maxSizeForInMemory = maxSizeForInMemory;
        return this;
    }

    public JsonParserType getType() {
        return this.type;
    }

    public JsonSlurper setType(JsonParserType type) {
        this.type = type;
        return this;
    }

    public boolean isChop() {
        return this.chop;
    }

    public JsonSlurper setChop(boolean chop) {
        this.chop = chop;
        return this;
    }

    public boolean isLazyChop() {
        return this.lazyChop;
    }

    public JsonSlurper setLazyChop(boolean lazyChop) {
        this.lazyChop = lazyChop;
        return this;
    }

    public boolean isCheckDates() {
        return this.checkDates;
    }

    public JsonSlurper setCheckDates(boolean checkDates) {
        this.checkDates = checkDates;
        return this;
    }

    public Object parseText(String text2) {
        if (text2 == null || "".equals(text2)) {
            throw new IllegalArgumentException("Text must not be null or empty");
        }
        return this.createParser().parse(text2);
    }

    public Object parse(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        JsonParser parser2 = this.createParser();
        Object content = parser2.parse(reader);
        return content;
    }

    public Object parse(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        JsonParser parser2 = this.createParser();
        Object content = parser2.parse(inputStream);
        return content;
    }

    public Object parse(InputStream inputStream, String charset) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        Object content = this.createParser().parse(inputStream, charset);
        return content;
    }

    public Object parse(byte[] bytes2, String charset) {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        Object content = this.createParser().parse(bytes2, charset);
        return content;
    }

    public Object parse(byte[] bytes2) {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes must not be null");
        }
        Object content = this.createParser().parse(bytes2);
        return content;
    }

    public Object parse(char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null");
        }
        Object content = this.createParser().parse(chars);
        return content;
    }

    private JsonParser createParser() {
        switch (this.type) {
            case LAX: {
                return new JsonParserLax(false, this.chop, this.lazyChop, this.checkDates);
            }
            case CHAR_BUFFER: {
                return new JsonParserCharArray();
            }
            case CHARACTER_SOURCE: {
                return new JsonParserUsingCharacterSource();
            }
            case INDEX_OVERLAY: {
                return new JsonFastParser(false, this.chop, this.lazyChop, this.checkDates);
            }
        }
        return new JsonParserCharArray();
    }

    public Object parse(File file) {
        return this.parseFile(file, null);
    }

    public Object parse(File file, String charset) {
        return this.parseFile(file, charset);
    }

    private Object parseFile(File file, String charset) {
        if (file.length() < (long)this.maxSizeForInMemory) {
            return this.createParser().parse(file, charset);
        }
        return new JsonParserUsingCharacterSource().parse(file, charset);
    }

    public Object parse(URL url) {
        return this.parseURL(url, null);
    }

    public Object parse(URL url, Map params2) {
        return this.parseURL(url, params2);
    }

    public Object parse(Map params2, URL url) {
        return this.parseURL(url, params2);
    }

    private Object parseURL(URL url, Map params2) {
        BufferedReader reader = null;
        try {
            reader = params2 == null || params2.isEmpty() ? ResourceGroovyMethods.newReader(url) : ResourceGroovyMethods.newReader(url, params2);
            Object object = this.createParser().parse(reader);
            return object;
        }
        catch (IOException ioe) {
            throw new JsonException("Unable to process url: " + url.toString(), ioe);
        }
        finally {
            if (reader != null) {
                DefaultGroovyMethodsSupport.closeWithWarning(reader);
            }
        }
    }

    public Object parse(URL url, String charset) {
        return this.parseURL(url, null, charset);
    }

    public Object parse(URL url, Map params2, String charset) {
        return this.parseURL(url, params2, charset);
    }

    public Object parse(Map params2, URL url, String charset) {
        return this.parseURL(url, params2, charset);
    }

    private Object parseURL(URL url, Map params2, String charset) {
        BufferedReader reader = null;
        try {
            reader = params2 == null || params2.isEmpty() ? ResourceGroovyMethods.newReader(url, charset) : ResourceGroovyMethods.newReader(url, params2, charset);
            Object object = this.parse(reader);
            return object;
        }
        catch (IOException ioe) {
            throw new JsonException("Unable to process url: " + url.toString(), ioe);
        }
        finally {
            if (reader != null) {
                DefaultGroovyMethodsSupport.closeWithWarning(reader);
            }
        }
    }
}

