/*
 * Decompiled with CFR 0.152.
 */
package groovy.json;

import groovy.io.LineColumnReader;
import groovy.json.JsonException;
import groovy.json.JsonToken;
import groovy.json.JsonTokenType;
import groovy.json.StringEscapeUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class JsonLexer
implements Iterator<JsonToken> {
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char LOWER_E = 'e';
    private static final char UPPER_E = 'E';
    private static final char ZERO = '0';
    private static final char NINE = '9';
    private final LineColumnReader reader;
    private JsonToken currentToken = null;

    public LineColumnReader getReader() {
        return this.reader;
    }

    public JsonLexer(Reader reader) {
        this.reader = reader instanceof LineColumnReader ? (LineColumnReader)reader : new LineColumnReader(reader);
    }

    public JsonToken nextToken() {
        try {
            int firstIntRead = this.skipWhitespace();
            if (firstIntRead == -1) {
                return null;
            }
            char firstChar = (char)firstIntRead;
            JsonTokenType possibleTokenType = JsonTokenType.startingWith((char)firstIntRead);
            if (possibleTokenType == null) {
                throw new JsonException("Lexing failed on line: " + this.reader.getLine() + ", column: " + this.reader.getColumn() + ", while reading '" + firstChar + "', no possible valid JSON value or punctuation could be recognized.");
            }
            this.reader.reset();
            long startLine = this.reader.getLine();
            long startColumn = this.reader.getColumn();
            JsonToken token2 = new JsonToken();
            token2.setStartLine(startLine);
            token2.setStartColumn(startColumn);
            token2.setEndLine(startLine);
            token2.setEndColumn(startColumn + 1L);
            token2.setType(possibleTokenType);
            token2.setText("" + firstChar);
            if (possibleTokenType.ordinal() >= JsonTokenType.OPEN_CURLY.ordinal() && possibleTokenType.ordinal() <= JsonTokenType.FALSE.ordinal()) {
                return this.readingConstant(possibleTokenType, token2);
            }
            if (possibleTokenType == JsonTokenType.STRING) {
                char charRead;
                StringBuilder currentContent = new StringBuilder("\"");
                this.reader.read();
                boolean isEscaped = false;
                do {
                    int read;
                    if ((read = this.reader.read()) == -1) {
                        return null;
                    }
                    isEscaped = !isEscaped && currentContent.charAt(currentContent.length() - 1) == '\\';
                    charRead = (char)read;
                    currentContent.append(charRead);
                } while (charRead != '\"' || isEscaped || !possibleTokenType.matching(currentContent.toString()));
                token2.setEndLine(this.reader.getLine());
                token2.setEndColumn(this.reader.getColumn());
                token2.setText(JsonLexer.unescape(currentContent.toString()));
                return token2;
            }
            if (possibleTokenType == JsonTokenType.NUMBER) {
                StringBuilder currentContent = new StringBuilder();
                while (true) {
                    this.reader.mark(1);
                    int read = this.reader.read();
                    if (read == -1) {
                        return null;
                    }
                    char lastCharRead = (char)read;
                    if ((lastCharRead < '0' || lastCharRead > '9') && lastCharRead != '.' && lastCharRead != '-' && lastCharRead != '+' && lastCharRead != 'e' && lastCharRead != 'E') break;
                    currentContent.append(lastCharRead);
                }
                this.reader.reset();
                String content = currentContent.toString();
                if (possibleTokenType.matching(content)) {
                    token2.setEndLine(this.reader.getLine());
                    token2.setEndColumn(this.reader.getColumn());
                    token2.setText(currentContent.toString());
                    return token2;
                }
                this.throwJsonException(currentContent.toString(), possibleTokenType);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new JsonException("An IO exception occurred while reading the JSON payload", ioe);
        }
    }

    private void throwJsonException(String content, JsonTokenType type) {
        throw new JsonException("Lexing failed on line: " + this.reader.getLine() + ", column: " + this.reader.getColumn() + ", while reading '" + content + "', was trying to match " + type.getLabel());
    }

    public static String unescape(String input2) {
        return StringEscapeUtils.unescapeJavaScript(input2);
    }

    private JsonToken readingConstant(JsonTokenType type, JsonToken token2) {
        try {
            int numCharsToRead = ((String)type.getValidator()).length();
            char[] chars = new char[numCharsToRead];
            this.reader.read(chars);
            String stringRead = new String(chars);
            if (stringRead.equals(type.getValidator())) {
                token2.setEndColumn(token2.getStartColumn() + (long)numCharsToRead);
                token2.setText(stringRead);
                return token2;
            }
            this.throwJsonException(stringRead, type);
        }
        catch (IOException ioe) {
            throw new JsonException("An IO exception occurred while reading the JSON payload", ioe);
        }
        return null;
    }

    public int skipWhitespace() {
        try {
            int readChar = 20;
            char c = ' ';
            while (Character.isWhitespace(c)) {
                this.reader.mark(1);
                readChar = this.reader.read();
                c = (char)readChar;
            }
            this.reader.reset();
            return readChar;
        }
        catch (IOException ioe) {
            throw new JsonException("An IO exception occurred while reading the JSON payload", ioe);
        }
    }

    @Override
    public boolean hasNext() {
        this.currentToken = this.nextToken();
        return this.currentToken != null;
    }

    @Override
    public JsonToken next() {
        return this.currentToken;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The method remove() is not supported on this lexer.");
    }
}

