/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SerializedConfigValue
extends AbstractConfigValue
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ConfigValue value;
    private boolean wasConfig;

    public SerializedConfigValue() {
        super(null);
    }

    SerializedConfigValue(ConfigValue value2) {
        this();
        this.value = value2;
        this.wasConfig = false;
    }

    SerializedConfigValue(Config conf) {
        this(conf.root());
        this.wasConfig = true;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.wasConfig) {
            return ((ConfigObject)this.value).toConfig();
        }
        return this.value;
    }

    private static void writeOriginField(DataOutput out, SerializedField code, Object v) throws IOException {
        switch (code) {
            case ORIGIN_DESCRIPTION: {
                out.writeUTF((String)v);
                break;
            }
            case ORIGIN_LINE_NUMBER: {
                out.writeInt((Integer)v);
                break;
            }
            case ORIGIN_END_LINE_NUMBER: {
                out.writeInt((Integer)v);
                break;
            }
            case ORIGIN_TYPE: {
                out.writeByte((Integer)v);
                break;
            }
            case ORIGIN_URL: {
                out.writeUTF((String)v);
                break;
            }
            case ORIGIN_RESOURCE: {
                out.writeUTF((String)v);
                break;
            }
            case ORIGIN_COMMENTS: {
                List list2 = (List)v;
                int size2 = list2.size();
                out.writeInt(size2);
                for (String s2 : list2) {
                    out.writeUTF(s2);
                }
                break;
            }
            case ORIGIN_NULL_URL: 
            case ORIGIN_NULL_RESOURCE: 
            case ORIGIN_NULL_COMMENTS: {
                break;
            }
            default: {
                throw new IOException("Unhandled field from origin: " + (Object)((Object)code));
            }
        }
    }

    static void writeOrigin(DataOutput out, SimpleConfigOrigin origin2, SimpleConfigOrigin baseOrigin) throws IOException {
        Map<Object, Object> m = origin2 != null ? origin2.toFieldsDelta(baseOrigin) : Collections.emptyMap();
        for (Map.Entry e : m.entrySet()) {
            FieldOut field2 = new FieldOut((SerializedField)((Object)e.getKey()));
            Object v = e.getValue();
            SerializedConfigValue.writeOriginField(field2.data, field2.code, v);
            SerializedConfigValue.writeField(out, field2);
        }
        SerializedConfigValue.writeEndMarker(out);
    }

    static SimpleConfigOrigin readOrigin(DataInput in, SimpleConfigOrigin baseOrigin) throws IOException {
        EnumMap<SerializedField, Object> m = new EnumMap<SerializedField, Object>(SerializedField.class);
        while (true) {
            ArrayList<String> v = null;
            SerializedField field2 = SerializedConfigValue.readCode(in);
            switch (field2) {
                case END_MARKER: {
                    return SimpleConfigOrigin.fromBase(baseOrigin, m);
                }
                case ORIGIN_DESCRIPTION: {
                    in.readInt();
                    v = in.readUTF();
                    break;
                }
                case ORIGIN_LINE_NUMBER: {
                    in.readInt();
                    v = in.readInt();
                    break;
                }
                case ORIGIN_END_LINE_NUMBER: {
                    in.readInt();
                    v = in.readInt();
                    break;
                }
                case ORIGIN_TYPE: {
                    in.readInt();
                    v = in.readUnsignedByte();
                    break;
                }
                case ORIGIN_URL: {
                    in.readInt();
                    v = in.readUTF();
                    break;
                }
                case ORIGIN_RESOURCE: {
                    in.readInt();
                    v = in.readUTF();
                    break;
                }
                case ORIGIN_COMMENTS: {
                    in.readInt();
                    int size2 = in.readInt();
                    ArrayList<String> list2 = new ArrayList<String>(size2);
                    for (int i = 0; i < size2; ++i) {
                        list2.add(in.readUTF());
                    }
                    v = list2;
                    break;
                }
                case ORIGIN_NULL_URL: 
                case ORIGIN_NULL_RESOURCE: 
                case ORIGIN_NULL_COMMENTS: {
                    in.readInt();
                    v = "";
                    break;
                }
                case ROOT_VALUE: 
                case ROOT_WAS_CONFIG: 
                case VALUE_DATA: 
                case VALUE_ORIGIN: {
                    throw new IOException("Not expecting this field here: " + (Object)((Object)field2));
                }
                case UNKNOWN: {
                    SerializedConfigValue.skipField(in);
                }
            }
            if (v == null) continue;
            m.put(field2, (Object)v);
        }
    }

    private static void writeValueData(DataOutput out, ConfigValue value2) throws IOException {
        SerializedValueType st = SerializedValueType.forValue(value2);
        out.writeByte(st.ordinal());
        switch (st) {
            case BOOLEAN: {
                out.writeBoolean(((ConfigBoolean)value2).unwrapped());
                break;
            }
            case NULL: {
                break;
            }
            case INT: {
                out.writeInt(((ConfigInt)value2).unwrapped());
                out.writeUTF(((ConfigNumber)value2).transformToString());
                break;
            }
            case LONG: {
                out.writeLong(((ConfigLong)value2).unwrapped());
                out.writeUTF(((ConfigNumber)value2).transformToString());
                break;
            }
            case DOUBLE: {
                out.writeDouble(((ConfigDouble)value2).unwrapped());
                out.writeUTF(((ConfigNumber)value2).transformToString());
                break;
            }
            case STRING: {
                out.writeUTF(((ConfigString)value2).unwrapped());
                break;
            }
            case LIST: {
                ConfigList list2 = (ConfigList)value2;
                out.writeInt(list2.size());
                for (ConfigValue v : list2) {
                    SerializedConfigValue.writeValue(out, v, (SimpleConfigOrigin)list2.origin());
                }
                break;
            }
            case OBJECT: {
                ConfigObject obj = (ConfigObject)value2;
                out.writeInt(obj.size());
                for (Map.Entry e : obj.entrySet()) {
                    out.writeUTF((String)e.getKey());
                    SerializedConfigValue.writeValue(out, (ConfigValue)e.getValue(), (SimpleConfigOrigin)obj.origin());
                }
                break;
            }
        }
    }

    private static AbstractConfigValue readValueData(DataInput in, SimpleConfigOrigin origin2) throws IOException {
        int stb = in.readUnsignedByte();
        SerializedValueType st = SerializedValueType.forInt(stb);
        if (st == null) {
            throw new IOException("Unknown serialized value type: " + stb);
        }
        switch (st) {
            case BOOLEAN: {
                return new ConfigBoolean(origin2, in.readBoolean());
            }
            case NULL: {
                return new ConfigNull(origin2);
            }
            case INT: {
                int vi = in.readInt();
                String si = in.readUTF();
                return new ConfigInt(origin2, vi, si);
            }
            case LONG: {
                long vl = in.readLong();
                String sl = in.readUTF();
                return new ConfigLong(origin2, vl, sl);
            }
            case DOUBLE: {
                double vd = in.readDouble();
                String sd = in.readUTF();
                return new ConfigDouble(origin2, vd, sd);
            }
            case STRING: {
                return new ConfigString.Quoted(origin2, in.readUTF());
            }
            case LIST: {
                int listSize = in.readInt();
                ArrayList<AbstractConfigValue> list2 = new ArrayList<AbstractConfigValue>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    AbstractConfigValue v = SerializedConfigValue.readValue(in, origin2);
                    list2.add(v);
                }
                return new SimpleConfigList(origin2, list2);
            }
            case OBJECT: {
                int mapSize = in.readInt();
                HashMap<String, AbstractConfigValue> map2 = new HashMap<String, AbstractConfigValue>(mapSize);
                for (int i = 0; i < mapSize; ++i) {
                    String key = in.readUTF();
                    AbstractConfigValue v = SerializedConfigValue.readValue(in, origin2);
                    map2.put(key, v);
                }
                return new SimpleConfigObject(origin2, map2);
            }
        }
        throw new IOException("Unhandled serialized value type: " + (Object)((Object)st));
    }

    private static void writeValue(DataOutput out, ConfigValue value2, SimpleConfigOrigin baseOrigin) throws IOException {
        FieldOut origin2 = new FieldOut(SerializedField.VALUE_ORIGIN);
        SerializedConfigValue.writeOrigin(origin2.data, (SimpleConfigOrigin)value2.origin(), baseOrigin);
        SerializedConfigValue.writeField(out, origin2);
        FieldOut data2 = new FieldOut(SerializedField.VALUE_DATA);
        SerializedConfigValue.writeValueData(data2.data, value2);
        SerializedConfigValue.writeField(out, data2);
        SerializedConfigValue.writeEndMarker(out);
    }

    private static AbstractConfigValue readValue(DataInput in, SimpleConfigOrigin baseOrigin) throws IOException {
        AbstractConfigValue value2 = null;
        SimpleConfigOrigin origin2 = null;
        while (true) {
            SerializedField code;
            if ((code = SerializedConfigValue.readCode(in)) == SerializedField.END_MARKER) {
                if (value2 == null) {
                    throw new IOException("No value data found in serialization of value");
                }
                return value2;
            }
            if (code == SerializedField.VALUE_DATA) {
                if (origin2 == null) {
                    throw new IOException("Origin must be stored before value data");
                }
                in.readInt();
                value2 = SerializedConfigValue.readValueData(in, origin2);
                continue;
            }
            if (code == SerializedField.VALUE_ORIGIN) {
                in.readInt();
                origin2 = SerializedConfigValue.readOrigin(in, baseOrigin);
                continue;
            }
            SerializedConfigValue.skipField(in);
        }
    }

    private static void writeField(DataOutput out, FieldOut field2) throws IOException {
        byte[] bytes2 = field2.bytes.toByteArray();
        out.writeByte(field2.code.ordinal());
        out.writeInt(bytes2.length);
        out.write(bytes2);
    }

    private static void writeEndMarker(DataOutput out) throws IOException {
        out.writeByte(SerializedField.END_MARKER.ordinal());
    }

    private static SerializedField readCode(DataInput in) throws IOException {
        int c = in.readUnsignedByte();
        if (c == SerializedField.UNKNOWN.ordinal()) {
            throw new IOException("field code " + c + " is not supposed to be on the wire");
        }
        return SerializedField.forInt(c);
    }

    private static void skipField(DataInput in) throws IOException {
        int len = in.readInt();
        int skipped = in.skipBytes(len);
        if (skipped < len) {
            byte[] bytes2 = new byte[len - skipped];
            in.readFully(bytes2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (((AbstractConfigValue)this.value).resolveStatus() != ResolveStatus.RESOLVED) {
            throw new NotSerializableException("tried to serialize a value with unresolved substitutions, need to Config#resolve() first, see API docs");
        }
        FieldOut field2 = new FieldOut(SerializedField.ROOT_VALUE);
        SerializedConfigValue.writeValue(field2.data, this.value, null);
        SerializedConfigValue.writeField(out, field2);
        field2 = new FieldOut(SerializedField.ROOT_WAS_CONFIG);
        field2.data.writeBoolean(this.wasConfig);
        SerializedConfigValue.writeField(out, field2);
        SerializedConfigValue.writeEndMarker(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SerializedField code;
        while ((code = SerializedConfigValue.readCode(in)) != SerializedField.END_MARKER) {
            DataInput input2 = this.fieldIn(in);
            if (code == SerializedField.ROOT_VALUE) {
                this.value = SerializedConfigValue.readValue(input2, null);
                continue;
            }
            if (code != SerializedField.ROOT_WAS_CONFIG) continue;
            this.wasConfig = input2.readBoolean();
        }
        return;
    }

    private DataInput fieldIn(ObjectInput in) throws IOException {
        byte[] bytes2 = new byte[in.readInt()];
        in.readFully(bytes2);
        return new DataInputStream(new ByteArrayInputStream(bytes2));
    }

    private static ConfigException shouldNotBeUsed() {
        return new ConfigException.BugOrBroken(SerializedConfigValue.class.getName() + " should not exist outside of serialization");
    }

    @Override
    public ConfigValueType valueType() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    public Object unwrapped() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    protected SerializedConfigValue newCopy(ConfigOrigin origin2) {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + "(value=" + this.value + ",wasConfig=" + this.wasConfig + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SerializedConfigValue) {
            return this.canEqual(other) && this.wasConfig == ((SerializedConfigValue)other).wasConfig && this.value.equals(((SerializedConfigValue)other).value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 41 * (41 + this.value.hashCode());
        h = 41 * (h + (this.wasConfig ? 1 : 0));
        return h;
    }

    private static class FieldOut {
        final SerializedField code;
        final ByteArrayOutputStream bytes;
        final DataOutput data;

        FieldOut(SerializedField code) {
            this.code = code;
            this.bytes = new ByteArrayOutputStream();
            this.data = new DataOutputStream(this.bytes);
        }
    }

    private static enum SerializedValueType {
        NULL(ConfigValueType.NULL),
        BOOLEAN(ConfigValueType.BOOLEAN),
        INT(ConfigValueType.NUMBER),
        LONG(ConfigValueType.NUMBER),
        DOUBLE(ConfigValueType.NUMBER),
        STRING(ConfigValueType.STRING),
        LIST(ConfigValueType.LIST),
        OBJECT(ConfigValueType.OBJECT);

        ConfigValueType configType;

        private SerializedValueType(ConfigValueType configType) {
            this.configType = configType;
        }

        static SerializedValueType forInt(int b) {
            if (b < SerializedValueType.values().length) {
                return SerializedValueType.values()[b];
            }
            return null;
        }

        static SerializedValueType forValue(ConfigValue value2) {
            ConfigValueType t = value2.valueType();
            if (t == ConfigValueType.NUMBER) {
                if (value2 instanceof ConfigInt) {
                    return INT;
                }
                if (value2 instanceof ConfigLong) {
                    return LONG;
                }
                if (value2 instanceof ConfigDouble) {
                    return DOUBLE;
                }
            } else {
                for (SerializedValueType st : SerializedValueType.values()) {
                    if (st.configType != t) continue;
                    return st;
                }
            }
            throw new ConfigException.BugOrBroken("don't know how to serialize " + value2);
        }
    }

    static enum SerializedField {
        UNKNOWN,
        END_MARKER,
        ROOT_VALUE,
        ROOT_WAS_CONFIG,
        VALUE_DATA,
        VALUE_ORIGIN,
        ORIGIN_DESCRIPTION,
        ORIGIN_LINE_NUMBER,
        ORIGIN_END_LINE_NUMBER,
        ORIGIN_TYPE,
        ORIGIN_URL,
        ORIGIN_COMMENTS,
        ORIGIN_NULL_URL,
        ORIGIN_NULL_COMMENTS,
        ORIGIN_RESOURCE,
        ORIGIN_NULL_RESOURCE;


        static SerializedField forInt(int b) {
            if (b < SerializedField.values().length) {
                return SerializedField.values()[b];
            }
            return UNKNOWN;
        }
    }
}

