/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigLoadingStrategy;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultConfigLoadingStrategy
implements ConfigLoadingStrategy {
    @Override
    public Config parseApplicationConfig(ConfigParseOptions parseOptions) {
        String url;
        String file;
        ClassLoader loader = parseOptions.getClassLoader();
        if (loader == null) {
            throw new ConfigException.BugOrBroken("ClassLoader should have been set here; bug in ConfigFactory. (You can probably work around this bug by passing in a class loader or calling currentThread().setContextClassLoader() though.)");
        }
        int specified = 0;
        String resource2 = System.getProperty("config.resource");
        if (resource2 != null) {
            ++specified;
        }
        if ((file = System.getProperty("config.file")) != null) {
            ++specified;
        }
        if ((url = System.getProperty("config.url")) != null) {
            ++specified;
        }
        if (specified == 0) {
            return ConfigFactory.parseResourcesAnySyntax("application", parseOptions);
        }
        if (specified > 1) {
            throw new ConfigException.Generic("You set more than one of config.file='" + file + "', config.url='" + url + "', config.resource='" + resource2 + "'; don't know which one to use!");
        }
        ConfigParseOptions overrideOptions = parseOptions.setAllowMissing(false);
        if (resource2 != null) {
            if (resource2.startsWith("/")) {
                resource2 = resource2.substring(1);
            }
            return ConfigFactory.parseResources(loader, resource2, overrideOptions);
        }
        if (file != null) {
            return ConfigFactory.parseFile(new File(file), overrideOptions);
        }
        try {
            return ConfigFactory.parseURL(new URL(url), overrideOptions);
        }
        catch (MalformedURLException e) {
            throw new ConfigException.Generic("Bad URL in config.url system property: '" + url + "': " + e.getMessage(), e);
        }
    }
}

