/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class Util {
    static final Modifier DEFAULT;

    private Util() {
    }

    static <K, V> Map<K, List<V>> immutableMultimap(Map<K, List<V>> multimap) {
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry<K, List<V>> entry2 : multimap.entrySet()) {
            if (entry2.getValue().isEmpty()) continue;
            result2.put(entry2.getKey(), Util.immutableList((Collection)entry2.getValue()));
        }
        return Collections.unmodifiableMap(result2);
    }

    static <K, V> Map<K, V> immutableMap(Map<K, V> map2) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map2));
    }

    static void checkArgument(boolean condition, String format2, Object ... args2) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(format2, args2));
        }
    }

    static <T> T checkNotNull(T reference, String format2, Object ... args2) {
        if (reference == null) {
            throw new NullPointerException(String.format(format2, args2));
        }
        return reference;
    }

    static void checkState(boolean condition, String format2, Object ... args2) {
        if (!condition) {
            throw new IllegalStateException(String.format(format2, args2));
        }
    }

    static <T> List<T> immutableList(Collection<T> collection2) {
        return Collections.unmodifiableList(new ArrayList<T>(collection2));
    }

    static <T> Set<T> immutableSet(Collection<T> set2) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set2));
    }

    static String join(String separator, List<String> parts) {
        if (parts.isEmpty()) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        result2.append(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            result2.append(separator).append(parts.get(i));
        }
        return result2.toString();
    }

    static <T> Set<T> union(Set<T> a, Set<T> b) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>();
        result2.addAll(a);
        result2.addAll(b);
        return result2;
    }

    static void requireExactlyOneOf(Set<Modifier> modifiers, Modifier ... mutuallyExclusive) {
        int count2 = 0;
        for (Modifier modifier : mutuallyExclusive) {
            if (modifier == null && DEFAULT == null || !modifiers.contains((Object)modifier)) continue;
            ++count2;
        }
        Util.checkArgument(count2 == 1, "modifiers %s must contain one of %s", modifiers, Arrays.toString((Object[])mutuallyExclusive));
    }

    static boolean hasDefaultModifier(Collection<Modifier> modifiers) {
        return DEFAULT != null && modifiers.contains((Object)DEFAULT);
    }

    static String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    static String stringLiteralWithDoubleQuotes(String value2, String indent2) {
        StringBuilder result2 = new StringBuilder(value2.length() + 2);
        result2.append('\"');
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c == '\'') {
                result2.append("'");
                continue;
            }
            if (c == '\"') {
                result2.append("\\\"");
                continue;
            }
            result2.append(Util.characterLiteralWithoutSingleQuotes(c));
            if (c != '\n' || i + 1 >= value2.length()) continue;
            result2.append("\"\n").append(indent2).append(indent2).append("+ \"");
        }
        result2.append('\"');
        return result2.toString();
    }

    static {
        Modifier def = null;
        try {
            def = Modifier.valueOf("DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DEFAULT = def;
    }
}

