/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.Util;
import java.io.IOException;

final class LineWrapper {
    private final Appendable out;
    private final String indent;
    private final int columnLimit;
    private boolean closed;
    private final StringBuilder buffer = new StringBuilder();
    private int column = 0;
    private int indentLevel = -1;

    LineWrapper(Appendable out, String indent2, int columnLimit) {
        Util.checkNotNull(out, "out == null", new Object[0]);
        this.out = out;
        this.indent = indent2;
        this.columnLimit = columnLimit;
    }

    void append(String s2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.indentLevel != -1) {
            int nextNewline = s2.indexOf(10);
            if (nextNewline == -1 && this.column + s2.length() <= this.columnLimit) {
                this.buffer.append(s2);
                this.column += s2.length();
                return;
            }
            boolean wrap2 = nextNewline == -1 || this.column + nextNewline > this.columnLimit;
            this.flush(wrap2);
        }
        this.out.append(s2);
        int lastNewline = s2.lastIndexOf(10);
        this.column = lastNewline != -1 ? s2.length() - lastNewline - 1 : this.column + s2.length();
    }

    void wrappingSpace(int indentLevel) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.indentLevel != -1) {
            this.flush(false);
        }
        ++this.column;
        this.indentLevel = indentLevel;
    }

    void close() throws IOException {
        if (this.indentLevel != -1) {
            this.flush(false);
        }
        this.closed = true;
    }

    private void flush(boolean wrap2) throws IOException {
        if (wrap2) {
            this.out.append('\n');
            for (int i = 0; i < this.indentLevel; ++i) {
                this.out.append(this.indent);
            }
            this.column = this.indentLevel * this.indent.length();
            this.column += this.buffer.length();
        } else {
            this.out.append(' ');
        }
        this.out.append(this.buffer);
        this.buffer.delete(0, this.buffer.length());
        this.indentLevel = -1;
    }
}

