/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Aggregate;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;

public final class Array
extends Aggregate {
    private final Type elementType;
    private final int length;

    public static Array newArray(Type elementType2, int length) {
        return new Array(elementType2, length);
    }

    public Array(Type elementType2, int length) {
        super(Foreign.getInstance(), Foreign.getInstance().newArray(elementType2.handle(), length));
        this.elementType = elementType2;
        this.length = length;
    }

    public final Type getElementType() {
        return this.elementType;
    }

    public final int length() {
        return this.length;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Array array2 = (Array)o;
        if (this.length != array2.length) {
            return false;
        }
        return !(this.elementType != null ? !this.elementType.equals(array2.elementType) : array2.elementType != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.elementType != null ? this.elementType.hashCode() : 0);
        result2 = 31 * result2 + this.length;
        return result2;
    }
}

