/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.DecorException;
import com.jcabi.log.DecorsManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PreFormatter {
    private static final Pattern PATTERN = Pattern.compile("%(?:\\d+\\$)?(\\[([A-Za-z\\-\\.0-9]+)\\])?[\\+\\-]?(?:\\d*(?:\\.\\d+)?)?[a-zA-Z%]");
    private transient String format;
    private transient List<Object> arguments;

    public PreFormatter(String fmt, Object ... args2) {
        this.process(fmt, args2);
    }

    public String getFormat() {
        return this.format;
    }

    public Object[] getArguments() {
        return this.arguments.toArray(new Object[this.arguments.size()]);
    }

    private void process(String fmt, Object[] args2) {
        this.arguments = new CopyOnWriteArrayList<Object>();
        StringBuffer buf = new StringBuffer();
        Matcher matcher2 = PATTERN.matcher(fmt);
        int pos = 0;
        while (matcher2.find()) {
            String decor = matcher2.group(2);
            if (decor == null) {
                matcher2.appendReplacement(buf, Matcher.quoteReplacement(matcher2.group()));
                this.arguments.add(args2[pos]);
            } else {
                matcher2.appendReplacement(buf, Matcher.quoteReplacement(matcher2.group().replace(matcher2.group(1), "")));
                try {
                    this.arguments.add(DecorsManager.decor(decor, args2[pos]));
                }
                catch (DecorException ex) {
                    this.arguments.add(String.format("[%s]", ex.getMessage()));
                }
            }
            ++pos;
        }
        if (pos < args2.length) {
            throw new IllegalArgumentException(String.format("There are %d parameter(s) but only %d format argument(s) were provided.", args2.length, pos));
        }
        matcher2.appendTail(buf);
        this.format = buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreFormatter)) {
            return false;
        }
        PreFormatter other = (PreFormatter)o;
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        return Arrays.deepEquals(this.getArguments(), other.getArguments());
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $format = this.getFormat();
        result2 = result2 * 59 + ($format == null ? 0 : $format.hashCode());
        result2 = result2 * 59 + Arrays.deepHashCode(this.getArguments());
        return result2;
    }
}

