/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;

final class NanoDecor
implements Formattable {
    private final transient Double nano;

    NanoDecor(Long nan) {
        this.nano = nan == null ? null : Double.valueOf(nan.longValue());
    }

    @Override
    public void formatTo(Formatter formatter, int flags2, int width, int precision) {
        if (this.nano == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder format2 = new StringBuilder(0);
            format2.append('%');
            if ((flags2 & 1) == 1) {
                format2.append('-');
            }
            if (width > 0) {
                format2.append(Integer.toString(width));
            }
            if ((flags2 & 2) == 2) {
                format2.append('S');
            } else {
                format2.append('s');
            }
            formatter.format(format2.toString(), this.toText(precision));
        }
    }

    private String toText(int precision) {
        String title;
        double number2;
        if (this.nano < 1000.0) {
            number2 = this.nano;
            title = "ns";
        } else if (this.nano < 1000000.0) {
            number2 = this.nano / 1000.0;
            title = "\u00b5s";
        } else if (this.nano < 1.0E9) {
            number2 = this.nano / 1000000.0;
            title = "ms";
        } else if (this.nano < 6.0E10) {
            number2 = this.nano / 1.0E9;
            title = "s";
        } else {
            number2 = this.nano / 6.0E10;
            title = "min";
        }
        String format2 = precision >= 0 ? String.format("%%.%df%%s", precision) : "%.0f%s";
        return String.format(format2, number2, title);
    }

    public String toString() {
        return "NanoDecor(nano=" + this.nano + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NanoDecor)) {
            return false;
        }
        NanoDecor other = (NanoDecor)o;
        Double this$nano = this.nano;
        Double other$nano = other.nano;
        return !(this$nano == null ? other$nano != null : !((Object)this$nano).equals(other$nano));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Double $nano = this.nano;
        result2 = result2 * 59 + ($nano == null ? 0 : ((Object)$nano).hashCode());
        return result2;
    }
}

