/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public final class MulticolorLayout
extends EnhancedPatternLayout {
    private static final String CSI = "\u001b[";
    private static final String SPLIT_ITEMS = ",";
    private static final String SPLIT_VALUES = ":";
    private static final Pattern METAS = Pattern.compile("%color(?:-([a-z]+|[0-9]{1,3};[0-9]{1,3};[0-9]{1,3}))?\\{(.*?)\\}");
    private final transient ConcurrentMap<String, String> colors = MulticolorLayout.colorMap();
    private final transient ConcurrentMap<String, String> levels = MulticolorLayout.levelMap();
    private transient String base;

    @Override
    public void setConversionPattern(String pattern) {
        this.base = pattern;
        Matcher matcher2 = METAS.matcher(pattern);
        StringBuffer buf = new StringBuffer(0);
        while (matcher2.find()) {
            matcher2.appendReplacement(buf, "");
            buf.append(CSI).append(this.ansi(matcher2.group(1))).append('m').append(matcher2.group(2)).append(CSI).append('m');
        }
        matcher2.appendTail(buf);
        super.setConversionPattern(buf.toString());
    }

    public void setColors(String cols) {
        for (String item : cols.split(SPLIT_ITEMS)) {
            String[] values2 = item.split(SPLIT_VALUES);
            this.colors.put(values2[0], values2[1]);
        }
        if (this.base != null) {
            this.setConversionPattern(this.base);
        }
    }

    public void setLevels(String lev) {
        for (String item : lev.split(SPLIT_ITEMS)) {
            String[] values2 = item.split(SPLIT_VALUES);
            String level = values2[0].toUpperCase(Locale.ENGLISH);
            if (Level.toLevel(level, null) == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown level '%s'", level));
            }
            this.levels.put(level, values2[1]);
        }
    }

    @Override
    public String format(LoggingEvent event) {
        return super.format(event).replace(String.format("%s?m", CSI), String.format("%s%sm", CSI, this.levels.get(event.getLevel().toString())));
    }

    private String ansi(String meta) {
        String ansi;
        if (meta == null) {
            ansi = "?";
        } else if (meta.matches("[a-z]+")) {
            ansi = (String)this.colors.get(meta);
            if (ansi == null) {
                throw new IllegalArgumentException(String.format("unknown color '%s'", meta));
            }
        } else {
            ansi = meta;
        }
        return ansi;
    }

    private static ConcurrentMap<String, String> colorMap() {
        ConcurrentHashMap<String, String> map2 = new ConcurrentHashMap<String, String>();
        map2.put("black", "30");
        map2.put("blue", "34");
        map2.put("cyan", "36");
        map2.put("green", "32");
        map2.put("magenta", "35");
        map2.put("red", "31");
        map2.put("yellow", "33");
        map2.put("white", "37");
        return map2;
    }

    private static ConcurrentMap<String, String> levelMap() {
        ConcurrentHashMap<String, String> map2 = new ConcurrentHashMap<String, String>();
        map2.put(Level.TRACE.toString(), "2;33");
        map2.put(Level.DEBUG.toString(), "2;37");
        map2.put(Level.INFO.toString(), "0;37");
        map2.put(Level.WARN.toString(), "0;33");
        map2.put(Level.ERROR.toString(), "0;31");
        map2.put(Level.FATAL.toString(), "0;35");
        return map2;
    }

    public String toString() {
        return "MulticolorLayout(colors=" + this.colors + ", levels=" + this.levels + ", base=" + this.base + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MulticolorLayout)) {
            return false;
        }
        MulticolorLayout other = (MulticolorLayout)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MulticolorLayout;
    }

    public int hashCode() {
        int result2 = 1;
        return result2;
    }
}

