/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;

final class MsDecor
implements Formattable {
    private final transient Double millis;

    MsDecor(Long msec) {
        this.millis = msec == null ? null : Double.valueOf(msec.longValue());
    }

    @Override
    public void formatTo(Formatter formatter, int flags2, int width, int precision) {
        if (this.millis == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder format2 = new StringBuilder(0);
            format2.append('%');
            if ((flags2 & 1) == 1) {
                format2.append('-');
            }
            if (width > 0) {
                format2.append(Integer.toString(width));
            }
            if ((flags2 & 2) == 2) {
                format2.append('S');
            } else {
                format2.append('s');
            }
            formatter.format(format2.toString(), this.toText(precision));
        }
    }

    private String toText(int precision) {
        String title;
        double number2;
        if (this.millis < 1000.0) {
            number2 = this.millis;
            title = "ms";
        } else if (this.millis < 60000.0) {
            number2 = this.millis / 1000.0;
            title = "s";
        } else if (this.millis < 3600000.0) {
            number2 = this.millis / 60000.0;
            title = "min";
        } else if (this.millis < 8.64E7) {
            number2 = this.millis / 3600000.0;
            title = "hr";
        } else if (this.millis < 2.592E9) {
            number2 = this.millis / 8.64E7;
            title = "days";
        } else {
            number2 = this.millis / 2.592E9;
            title = "mon";
        }
        String format2 = precision >= 0 ? String.format("%%.%df%%s", precision) : "%.0f%s";
        return String.format(format2, number2, title);
    }

    public String toString() {
        return "MsDecor(millis=" + this.millis + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsDecor)) {
            return false;
        }
        MsDecor other = (MsDecor)o;
        Double this$millis = this.millis;
        Double other$millis = other.millis;
        return !(this$millis == null ? other$millis != null : !((Object)this$millis).equals(other$millis));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Double $millis = this.millis;
        result2 = result2 * 59 + ($millis == null ? 0 : ((Object)$millis).hashCode());
        return result2;
    }
}

