/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.PreFormatter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.slf4j.LoggerFactory;

public final class Logger {
    private static final Object[] EMPTY = new Object[0];

    private Logger() {
    }

    public static String format(String fmt, Object ... args2) {
        String result2;
        if (args2.length == 0) {
            result2 = fmt;
        } else {
            PreFormatter pre = new PreFormatter(fmt, args2);
            result2 = String.format(pre.getFormat(), pre.getArguments());
        }
        return result2;
    }

    public static void trace(Object source, String msg) {
        Logger.trace(source, msg, EMPTY);
    }

    public static void trace(Object source, String msg, Object ... args2) {
        if (Logger.isTraceEnabled(source)) {
            Logger.logger(source).trace(Logger.format(msg, args2));
        }
    }

    public static void debug(Object source, String msg) {
        Logger.debug(source, msg, EMPTY);
    }

    public static void debug(Object source, String msg, Object ... args2) {
        if (Logger.isDebugEnabled(source)) {
            Logger.logger(source).debug(Logger.format(msg, args2));
        }
    }

    public static void info(Object source, String msg) {
        Logger.info(source, msg, EMPTY);
    }

    public static void info(Object source, String msg, Object ... args2) {
        if (Logger.isInfoEnabled(source)) {
            Logger.logger(source).info(Logger.format(msg, args2));
        }
    }

    public static void warn(Object source, String msg) {
        Logger.warn(source, msg, EMPTY);
    }

    public static void warn(Object source, String msg, Object ... args2) {
        if (Logger.isWarnEnabled(source)) {
            Logger.logger(source).warn(Logger.format(msg, args2));
        }
    }

    public static void error(Object source, String msg) {
        Logger.error(source, msg, EMPTY);
    }

    public static void error(Object source, String msg, Object ... args2) {
        Logger.logger(source).error(Logger.format(msg, args2));
    }

    public static boolean isTraceEnabled(Object source) {
        return Logger.logger(source).isTraceEnabled();
    }

    public static boolean isDebugEnabled(Object source) {
        return Logger.logger(source).isDebugEnabled();
    }

    public static boolean isInfoEnabled(Object source) {
        return Logger.logger(source).isInfoEnabled();
    }

    public static boolean isWarnEnabled(Object source) {
        return Logger.logger(source).isWarnEnabled();
    }

    public static boolean isEnabled(Level level, Object source) {
        boolean enabled = false;
        if (level.equals(Level.SEVERE)) {
            enabled = Logger.logger(source).isErrorEnabled();
        } else if (level.equals(Level.WARNING)) {
            enabled = Logger.logger(source).isWarnEnabled();
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            enabled = Logger.logger(source).isInfoEnabled();
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            enabled = Logger.logger(source).isDebugEnabled();
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            enabled = Logger.logger(source).isTraceEnabled();
        }
        return enabled;
    }

    public static void log(Level level, Object source, String msg, Object ... args2) {
        if (level.equals(Level.SEVERE)) {
            Logger.error(source, msg, args2);
        } else if (level.equals(Level.WARNING)) {
            Logger.warn(source, msg, args2);
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            Logger.info(source, msg, args2);
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            Logger.debug(source, msg, args2);
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            Logger.trace(source, msg, args2);
        }
    }

    public static OutputStream stream(final Level level, final Object source) {
        return new OutputStream(){
            private final transient ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public void write(int data2) throws IOException {
                if (data2 == 10) {
                    Logger.log(level, source, this.buffer.toString("UTF-8"), new Object[0]);
                    this.buffer.reset();
                } else {
                    this.buffer.write(data2);
                }
            }
        };
    }

    private static org.slf4j.Logger logger(Object source) {
        org.slf4j.Logger logger = source instanceof Class ? LoggerFactory.getLogger((Class)source) : LoggerFactory.getLogger(source.getClass());
        return logger;
    }

    public String toString() {
        return "Logger()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Logger;
    }

    public int hashCode() {
        int result2 = 1;
        return result2;
    }
}

