/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.JsonParserReader;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferenceSerializer;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public abstract class SpatialReference
implements Serializable {
    private static final long serialVersionUID = 2L;

    public static SpatialReference create(int wkid) {
        SpatialReferenceImpl spatRef = SpatialReferenceImpl.createImpl(wkid);
        return spatRef;
    }

    public static SpatialReference create(String wktext) {
        return SpatialReferenceImpl.createImpl(wktext);
    }

    boolean isLocal() {
        return false;
    }

    public static SpatialReference fromJson(JsonParser parser2) throws Exception {
        return SpatialReference.fromJson(new JsonParserReader(parser2));
    }

    static SpatialReference fromJson(JsonReader parser2) throws Exception {
        boolean bFoundWkid = false;
        boolean bFoundLatestWkid = false;
        boolean bFoundVcsWkid = false;
        boolean bFoundLatestVcsWkid = false;
        boolean bFoundWkt = false;
        int wkid = -1;
        int latestWkid = -1;
        int vcs_wkid = -1;
        int latestVcsWkid = -1;
        String wkt = null;
        while (parser2.nextToken() != JsonToken.END_OBJECT) {
            String name2 = parser2.currentString();
            parser2.nextToken();
            if (!bFoundWkid && name2.equals("wkid")) {
                bFoundWkid = true;
                if (parser2.currentToken() != JsonToken.VALUE_NUMBER_INT) continue;
                wkid = parser2.currentIntValue();
                continue;
            }
            if (!bFoundLatestWkid && name2.equals("latestWkid")) {
                bFoundLatestWkid = true;
                if (parser2.currentToken() != JsonToken.VALUE_NUMBER_INT) continue;
                latestWkid = parser2.currentIntValue();
                continue;
            }
            if (!bFoundWkt && name2.equals("wkt")) {
                bFoundWkt = true;
                if (parser2.currentToken() != JsonToken.VALUE_STRING) continue;
                wkt = parser2.currentString();
                continue;
            }
            if (!bFoundVcsWkid && name2.equals("vcsWkid")) {
                bFoundVcsWkid = true;
                if (parser2.currentToken() != JsonToken.VALUE_NUMBER_INT) continue;
                vcs_wkid = parser2.currentIntValue();
                continue;
            }
            if (bFoundLatestVcsWkid || !name2.equals("latestVcsWkid")) continue;
            bFoundLatestVcsWkid = true;
            if (parser2.currentToken() != JsonToken.VALUE_NUMBER_INT) continue;
            latestVcsWkid = parser2.currentIntValue();
        }
        if (latestVcsWkid <= 0 && vcs_wkid > 0) {
            latestVcsWkid = vcs_wkid;
        }
        SpatialReference spatial_reference = null;
        if (wkt != null && wkt.length() != 0) {
            try {
                spatial_reference = SpatialReference.create(wkt);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (spatial_reference == null && latestWkid > 0) {
            try {
                spatial_reference = SpatialReference.create(latestWkid);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (spatial_reference == null && wkid > 0) {
            try {
                spatial_reference = SpatialReference.create(wkid);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return spatial_reference;
    }

    public abstract int getID();

    public abstract String getText();

    abstract int getOldID();

    abstract int getLatestID();

    public double getTolerance() {
        return this.getTolerance(0);
    }

    abstract double getTolerance(int var1);

    Object writeReplace() throws ObjectStreamException {
        SpatialReferenceSerializer srSerializer = new SpatialReferenceSerializer();
        srSerializer.setSpatialReferenceByValue(this);
        return srSerializer;
    }

    public String toString() {
        return "[ tol: " + this.getTolerance() + "; wkid: " + this.getID() + "; wkt: " + this.getText() + "]";
    }
}

