/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Boundary;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

public abstract class Segment
extends Geometry
implements Serializable {
    private static final long serialVersionUID = 1L;
    double m_xStart = 0.0;
    double m_yStart = 0.0;
    double m_xEnd = 0.0;
    double m_yEnd = 0.0;
    double[] m_attributes = null;

    Point2D getStartXY() {
        return Point2D.construct(this.m_xStart, this.m_yStart);
    }

    void getStartXY(Point2D pt) {
        pt.x = this.m_xStart;
        pt.y = this.m_yStart;
    }

    void setStartXY(Point2D pt) {
        this._setXY(0, pt);
    }

    void setStartXY(double x, double y) {
        this._setXY(0, Point2D.construct(x, y));
    }

    Point3D getStartXYZ() {
        return this._getXYZ(0);
    }

    void setStartXYZ(Point3D pt) {
        this._setXYZ(0, pt);
    }

    void setStartXYZ(double x, double y, double z) {
        this._setXYZ(0, Point3D.construct(x, y, z));
    }

    public void queryStart(Point dstPoint) {
        this._get(0, dstPoint);
    }

    public void setStart(Point srcPoint) {
        this._set(0, srcPoint);
    }

    public double getStartAttributeAsDbl(int semantics, int ordinate) {
        return this._getAttributeAsDbl(0, semantics, ordinate);
    }

    public int getStartAttributeAsInt(int semantics, int ordinate) {
        return this._getAttributeAsInt(0, semantics, ordinate);
    }

    public void setStartAttribute(int semantics, int ordinate, double value2) {
        this._setAttribute(0, semantics, ordinate, value2);
    }

    public void setStartAttribute(int semantics, int ordinate, int value2) {
        this._setAttribute(0, semantics, ordinate, value2);
    }

    public double getStartX() {
        return this.m_xStart;
    }

    public double getStartY() {
        return this.m_yStart;
    }

    public double getEndX() {
        return this.m_xEnd;
    }

    public double getEndY() {
        return this.m_yEnd;
    }

    Point2D getEndXY() {
        return Point2D.construct(this.m_xEnd, this.m_yEnd);
    }

    void getEndXY(Point2D pt) {
        pt.x = this.m_xEnd;
        pt.y = this.m_yEnd;
    }

    void setEndXY(Point2D pt) {
        this._setXY(1, pt);
    }

    void setEndXY(double x, double y) {
        this._setXY(1, Point2D.construct(x, y));
    }

    Point3D getEndXYZ() {
        return this._getXYZ(1);
    }

    void setEndXYZ(Point3D pt) {
        this._setXYZ(1, pt);
    }

    void setEndXYZ(double x, double y, double z) {
        this._setXYZ(1, Point3D.construct(x, y, z));
    }

    public void queryEnd(Point dstPoint) {
        this._get(1, dstPoint);
    }

    public void setEnd(Point srcPoint) {
        this._set(1, srcPoint);
    }

    public double getEndAttributeAsDbl(int semantics, int ordinate) {
        return this._getAttributeAsDbl(1, semantics, ordinate);
    }

    public int getEndAttributeAsInt(int semantics, int ordinate) {
        return this._getAttributeAsInt(1, semantics, ordinate);
    }

    public void setEndAttribute(int semantics, int ordinate, double value2) {
        this._setAttribute(1, semantics, ordinate, value2);
    }

    public void setEndAttribute(int semantics, int ordinate, int value2) {
        this._setAttribute(1, semantics, ordinate, value2);
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmptyImpl();
    }

    @Override
    public final void setEmpty() {
    }

    @Override
    public double calculateArea2D() {
        return 0.0;
    }

    int intersect(Segment other, Point2D[] intersectionPoints, double[] paramThis, double[] paramOther, double tolerance) {
        return this._intersect(other, intersectionPoints, paramThis, paramOther, tolerance);
    }

    boolean isIntersecting(Segment other, double tolerance) {
        return this._isIntersecting(other, tolerance, false) != 0;
    }

    boolean isIntersecting(Point2D pt, double tolerance) {
        return this._isIntersectingPoint(pt, tolerance, false);
    }

    public boolean isEmptyImpl() {
        return false;
    }

    void _resizeAttributes(int newSize) {
        this._touch();
        if (this.m_attributes == null && newSize > 0) {
            this.m_attributes = new double[newSize * 2];
        } else if (this.m_attributes != null && this.m_attributes.length < newSize * 2) {
            double[] newbuffer = new double[newSize * 2];
            System.arraycopy(this.m_attributes, 0, newbuffer, 0, this.m_attributes.length);
            this.m_attributes = newbuffer;
        }
    }

    static void _attributeCopy(double[] src, int srcStart, double[] dst, int dstStart, int count2) {
        if (count2 > 0) {
            System.arraycopy(src, srcStart, dst, dstStart, count2);
        }
    }

    private Point2D _getXY(int endPoint) {
        Point2D pt = new Point2D();
        if (endPoint != 0) {
            pt.setCoords(this.m_xEnd, this.m_yEnd);
        } else {
            pt.setCoords(this.m_xStart, this.m_yStart);
        }
        return pt;
    }

    private void _setXY(int endPoint, Point2D pt) {
        if (endPoint != 0) {
            this.m_xEnd = pt.x;
            this.m_yEnd = pt.y;
        } else {
            this.m_xStart = pt.x;
            this.m_yStart = pt.y;
        }
    }

    private Point3D _getXYZ(int endPoint) {
        Point3D pt = new Point3D();
        if (endPoint != 0) {
            pt.x = this.m_xEnd;
            pt.y = this.m_yEnd;
        } else {
            pt.x = this.m_xStart;
            pt.y = this.m_yStart;
        }
        pt.z = this.m_description.hasZ() ? this.m_attributes[Segment._getEndPointOffset(this.m_description, endPoint)] : VertexDescription.getDefaultValue(1);
        return pt;
    }

    private void _setXYZ(int endPoint, Point3D pt) {
        this._touch();
        boolean bHasZ = this.hasAttribute(1);
        if (!bHasZ && !VertexDescription.isDefaultValue(1, pt.z)) {
            this.addAttribute(1);
            bHasZ = true;
        }
        if (endPoint != 0) {
            this.m_xEnd = pt.x;
            this.m_yEnd = pt.y;
        } else {
            this.m_xStart = pt.x;
            this.m_yStart = pt.y;
        }
        if (bHasZ) {
            this.m_attributes[Segment._getEndPointOffset((VertexDescription)this.m_description, (int)endPoint)] = pt.z;
        }
    }

    @Override
    protected void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        if (this.m_attributes == null) {
            this.m_description = newDescription;
            return;
        }
        int[] mapping = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
        double[] newAttributes = new double[(newDescription._getTotalComponents() - 2) * 2];
        int old_offset0 = Segment._getEndPointOffset(this.m_description, 0);
        int old_offset1 = Segment._getEndPointOffset(this.m_description, 1);
        int new_offset0 = Segment._getEndPointOffset(newDescription, 0);
        int new_offset1 = Segment._getEndPointOffset(newDescription, 1);
        int j = 0;
        int n = newDescription.getAttributeCount();
        for (int i = 1; i < n; ++i) {
            int ord;
            int semantics = newDescription.getSemantics(i);
            int nords = VertexDescription.getComponentCount(semantics);
            if (mapping[i] == -1) {
                double d = VertexDescription.getDefaultValue(semantics);
                for (ord = 0; ord < nords; ++ord) {
                    newAttributes[new_offset0 + j] = d;
                    newAttributes[new_offset1 + j] = d;
                    ++j;
                }
                continue;
            }
            int m = mapping[i];
            int offset = this.m_description._getPointAttributeOffset(m) - 2;
            for (ord = 0; ord < nords; ++ord) {
                newAttributes[new_offset0 + j] = this.m_attributes[old_offset0 + offset];
                newAttributes[new_offset1 + j] = this.m_attributes[old_offset1 + offset];
                ++j;
                ++offset;
            }
        }
        this.m_attributes = newAttributes;
        this.m_description = newDescription;
    }

    private void _get(int endPoint, Point outPoint) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("empty geometry");
        }
        outPoint.assignVertexDescription(this.m_description);
        if (outPoint.isEmptyImpl()) {
            outPoint._setToDefault();
        }
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description._getSemanticsImpl(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = this._getAttributeAsDbl(endPoint, semantics, icomp);
                outPoint.setAttribute(semantics, icomp, v);
            }
        }
    }

    private void _set(int endPoint, Point src) {
        this._touch();
        Point point = src;
        if (src.isEmptyImpl()) {
            throw new GeometryException("empty_Geometry");
        }
        VertexDescription vdin = point.getDescription();
        int nattrib = vdin.getAttributeCount();
        for (int attributeIndex = 0; attributeIndex < nattrib; ++attributeIndex) {
            int semantics = vdin._getSemanticsImpl(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = point.getAttributeAsDbl(semantics, icomp);
                this._setAttribute(endPoint, semantics, icomp, v);
            }
        }
    }

    double _getAttributeAsDbl(int endPoint, int semantics, int ordinate) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
        if (semantics == 0) {
            if (endPoint != 0) {
                return ordinate != 0 ? this.m_yEnd : this.m_xEnd;
            }
            return ordinate != 0 ? this.m_yStart : this.m_xStart;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            if (this.m_attributes != null) {
                this._resizeAttributes(this.m_description._getTotalComponents() - 2);
            }
            return this.m_attributes[Segment._getEndPointOffset(this.m_description, endPoint) + this.m_description._getPointAttributeOffset(attributeIndex) - 2 + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    private int _getAttributeAsInt(int endPoint, int semantics, int ordinate) {
        if (this.isEmptyImpl()) {
            throw new GeometryException("Empty_Geometry.");
        }
        return (int)this._getAttributeAsDbl(endPoint, semantics, ordinate);
    }

    void _setAttribute(int endPoint, int semantics, int ordinate, double value2) {
        this._touch();
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex < 0) {
            this.addAttribute(semantics);
            attributeIndex = this.m_description.getAttributeIndex(semantics);
        }
        if (semantics == 0) {
            if (endPoint != 0) {
                if (ordinate != 0) {
                    this.m_yEnd = value2;
                } else {
                    this.m_xEnd = value2;
                }
            } else if (ordinate != 0) {
                this.m_yStart = value2;
            } else {
                this.m_xStart = value2;
            }
            return;
        }
        if (this.m_attributes == null) {
            this._resizeAttributes(this.m_description._getTotalComponents() - 2);
        }
        this.m_attributes[Segment._getEndPointOffset((VertexDescription)this.m_description, (int)endPoint) + this.m_description._getPointAttributeOffset((int)attributeIndex) - 2 + ordinate] = value2;
    }

    void _setAttribute(int endPoint, int semantics, int ordinate, int value2) {
        this._setAttribute(endPoint, semantics, ordinate, (double)value2);
    }

    @Override
    public void copyTo(Geometry dst) {
        if (dst.getType() != this.getType()) {
            throw new IllegalArgumentException();
        }
        Segment segDst = (Segment)dst;
        segDst.m_description = this.m_description;
        segDst._resizeAttributes(this.m_description._getTotalComponents() - 2);
        Segment._attributeCopy(this.m_attributes, 0, segDst.m_attributes, 0, (this.m_description._getTotalComponents() - 2) * 2);
        segDst.m_xStart = this.m_xStart;
        segDst.m_yStart = this.m_yStart;
        segDst.m_xEnd = this.m_xEnd;
        segDst.m_yEnd = this.m_yEnd;
        dst._touch();
        this._copyToImpl(segDst);
    }

    @Override
    public Envelope1D queryInterval(int semantics, int ordinate) {
        Envelope1D env = new Envelope1D();
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return env;
        }
        env.vmax = env.vmin = this._getAttributeAsDbl(0, semantics, ordinate);
        env.mergeNE(this._getAttributeAsDbl(1, semantics, ordinate));
        return env;
    }

    void queryCoord(double t, Point point) {
        point.assignVertexDescription(this.m_description);
        point.setXY(this.getCoord2D(t));
        int nattrib = this.m_description.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = this.m_description._getSemanticsImpl(iattrib);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomp; ++iord) {
                double value2 = this.getAttributeAsDbl(t, semantics, iord);
                point.setAttribute(semantics, iord, value2);
            }
        }
    }

    boolean _equalsImpl(Segment other) {
        if (this.m_description != other.m_description) {
            return false;
        }
        if (this.m_xStart != other.m_xStart || this.m_xEnd != other.m_xEnd || this.m_yStart != other.m_yStart || this.m_yEnd != other.m_yEnd) {
            return false;
        }
        for (int i = 0; i < (this.m_description._getTotalComponents() - 2) * 2; ++i) {
            if (this.m_attributes[i] == other.m_attributes[i]) continue;
            return false;
        }
        return true;
    }

    boolean isClosed() {
        return this.m_xStart == this.m_xEnd && this.m_yStart == this.m_yEnd;
    }

    void reverse() {
        double origyEnd;
        double origxEnd;
        this._reverseImpl();
        double origxStart = this.m_xStart;
        this.m_xStart = origxEnd = this.m_xEnd;
        this.m_xEnd = origxStart;
        double origyStart = this.m_yStart;
        this.m_yStart = origyEnd = this.m_yEnd;
        this.m_yEnd = origyStart;
        int n = this.m_description.getAttributeCount();
        for (int i = 1; i < n; ++i) {
            int semantics = this.m_description.getSemantics(i);
            int nord = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < nord; ++iord) {
                double v1 = this._getAttributeAsDbl(0, semantics, iord);
                double v2 = this._getAttributeAsDbl(1, semantics, iord);
                this._setAttribute(0, semantics, iord, v2);
                this._setAttribute(1, semantics, iord, v1);
            }
        }
    }

    int _isIntersecting(Segment other, double tolerance, boolean bExcludeExactEndpoints) {
        int gtThis = this.getType().value();
        int gtOther = other.getType().value();
        switch (gtThis) {
            case 322: {
                if (gtOther == 322) {
                    return Line._isIntersectingLineLine((Line)this, (Line)other, tolerance, bExcludeExactEndpoints);
                }
                throw GeometryException.GeometryInternalError();
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    int _intersect(Segment other, Point2D[] intersectionPoints, double[] paramThis, double[] paramOther, double tolerance) {
        int gtThis = this.getType().value();
        int gtOther = other.getType().value();
        switch (gtThis) {
            case 322: {
                if (gtOther == 322) {
                    return Line._intersectLineLine((Line)this, (Line)other, intersectionPoints, paramThis, paramOther, tolerance);
                }
                throw GeometryException.GeometryInternalError();
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    abstract double _calculateArea2DHelper(double var1, double var3);

    static int _getEndPointOffset(VertexDescription vd, int endPoint) {
        return endPoint * (vd._getTotalComponents() - 2);
    }

    Point2D getCoord2D(double t) {
        Point2D pt = new Point2D();
        this.getCoord2D(t, pt);
        return pt;
    }

    abstract void getCoord2D(double var1, Point2D var3);

    abstract double getClosestCoordinate(Point2D var1, boolean var2);

    abstract int getYMonotonicParts(SegmentBuffer[] var1);

    public abstract int intersectionWithAxis2D(boolean var1, double var2, double[] var4, double[] var5);

    void _reverseImpl() {
    }

    abstract boolean isDegenerate(double var1);

    abstract boolean isCurve();

    abstract Point2D _getTangent(double var1);

    abstract boolean _isDegenerate(double var1);

    double _calculateSubLength(double t) {
        return this.tToLength(t);
    }

    double _calculateSubLength(double t1, double t2) {
        return this.tToLength(t2) - this.tToLength(t1);
    }

    abstract void _copyToImpl(Segment var1);

    abstract Segment cut(double var1, double var3);

    abstract void cut(double var1, double var3, SegmentBuffer var5);

    public abstract double getAttributeAsDbl(double var1, int var3, int var4);

    abstract boolean _isIntersectingPoint(Point2D var1, double var2, boolean var4);

    abstract double intersectionOfYMonotonicWithAxisX(double var1, double var3);

    abstract double tToLength(double var1);

    abstract double lengthToT(double var1);

    double distance(Segment otherSegment, boolean bSegmentsKnownDisjoint) {
        if (!bSegmentsKnownDisjoint && this._isIntersecting(otherSegment, 0.0, false) != 0) {
            return 0.0;
        }
        double minDistance = NumberUtils.doubleMax();
        Point2D input_point = this.getStartXY();
        double t = otherSegment.getClosestCoordinate(input_point, false);
        input_point.sub(otherSegment.getCoord2D(t));
        double distance = input_point.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        input_point = this.getEndXY();
        t = otherSegment.getClosestCoordinate(input_point, false);
        input_point.sub(otherSegment.getCoord2D(t));
        distance = input_point.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        input_point = otherSegment.getStartXY();
        t = this.getClosestCoordinate(input_point, false);
        input_point.sub(this.getCoord2D(t));
        distance = input_point.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        input_point = otherSegment.getEndXY();
        t = this.getClosestCoordinate(input_point, false);
        input_point.sub(this.getCoord2D(t));
        distance = input_point.length();
        if (distance < minDistance) {
            minDistance = distance;
        }
        return minDistance;
    }

    @Override
    public Geometry getBoundary() {
        return Boundary.calculate(this, null);
    }
}

