/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.QuadTreeImpl;

public class QuadTree {
    private QuadTreeImpl m_impl;

    public QuadTree(Envelope2D extent, int height) {
        this.m_impl = new QuadTreeImpl(extent, height);
    }

    public int insert(int element, Envelope2D bounding_box) {
        return this.m_impl.insert(element, bounding_box);
    }

    public int insert(int element, Envelope2D bounding_box, int hint_index) {
        return this.m_impl.insert(element, bounding_box, hint_index);
    }

    public void removeElement(int element_handle) {
        this.m_impl.removeElement(element_handle);
    }

    public int getElement(int element_handle) {
        return this.m_impl.getElement(element_handle);
    }

    public int getHeight(int quad_handle) {
        return this.m_impl.getHeight(quad_handle);
    }

    public Envelope2D getExtent(int quad_handle) {
        return this.m_impl.getExtent(quad_handle);
    }

    public int getQuad(int element_handle) {
        return this.m_impl.getQuad(element_handle);
    }

    public int getElementCount() {
        return this.m_impl.getElementCount();
    }

    public QuadTreeIterator getIterator(Geometry query, double tolerance) {
        QuadTreeImpl.QuadTreeIteratorImpl iterator2 = this.m_impl.getIterator(query, tolerance);
        return new QuadTreeIterator(iterator2);
    }

    public QuadTreeIterator getIterator(Envelope2D query, double tolerance) {
        QuadTreeImpl.QuadTreeIteratorImpl iterator2 = this.m_impl.getIterator(query, tolerance);
        return new QuadTreeIterator(iterator2);
    }

    public QuadTreeIterator getIterator() {
        QuadTreeImpl.QuadTreeIteratorImpl iterator2 = this.m_impl.getIterator();
        return new QuadTreeIterator(iterator2);
    }

    Object getImpl_() {
        return this.m_impl;
    }

    public static final class QuadTreeIterator {
        private QuadTreeImpl.QuadTreeIteratorImpl m_impl;

        public void resetIterator(Geometry query, double tolerance) {
            this.m_impl.resetIterator(query, tolerance);
        }

        public void resetIterator(Envelope2D query, double tolerance) {
            this.m_impl.resetIterator(query, tolerance);
        }

        public int next() {
            return this.m_impl.next();
        }

        Object getImpl_() {
            return this.m_impl;
        }

        private QuadTreeIterator(Object obj) {
            this.m_impl = (QuadTreeImpl.QuadTreeIteratorImpl)obj;
        }
    }
}

