/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.TopologicalOperations;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class OperatorUnionCursor
extends GeometryCursor {
    private GeometryCursor m_inputGeoms;
    private ProgressTracker m_progress_tracker;
    private SpatialReferenceImpl m_spatial_reference;
    private int m_index = -1;
    private boolean m_b_done = false;
    private boolean[] m_had_geometry = new boolean[4];
    private int[] m_dim_geom_counts = new int[4];
    private boolean m_b_union_all_dimensions = false;
    private int m_max_dimension = -1;
    private int m_added_geoms = 0;
    private int m_current_dim = -1;
    ArrayList<TreeMap<Integer, Bin_type>> m_union_bins = new ArrayList();

    OperatorUnionCursor(GeometryCursor inputGeoms1, SpatialReference sr, ProgressTracker progress_tracker) {
        this.m_inputGeoms = inputGeoms1;
        this.m_spatial_reference = (SpatialReferenceImpl)sr;
        this.m_progress_tracker = progress_tracker;
    }

    private Geometry get_result_geometry(int dim) {
        assert (this.m_dim_geom_counts[dim] > 0);
        TreeMap<Integer, Bin_type> map2 = this.m_union_bins.get(dim);
        Map.Entry<Integer, Bin_type> e = map2.firstEntry();
        Bin_type bin = e.getValue();
        Geometry resG = bin.back_pair().geom;
        boolean unioned = bin.back_pair().unioned;
        map2.remove(e.getKey());
        if (unioned) {
            resG = OperatorSimplify.local().execute(resG, (SpatialReference)this.m_spatial_reference, false, this.m_progress_tracker);
            if (dim == 0 && resG.getType() == Geometry.Type.Point) {
                MultiPoint mp = new MultiPoint(resG.getDescription());
                if (!resG.isEmpty()) {
                    mp.add((Point)resG);
                }
                resG = mp;
            }
        }
        return resG;
    }

    @Override
    public Geometry next() {
        if (this.m_b_done && this.m_current_dim == this.m_max_dimension) {
            return null;
        }
        while (!this.step_()) {
        }
        if (this.m_max_dimension == -1) {
            return null;
        }
        if (this.m_b_union_all_dimensions) {
            ++this.m_current_dim;
            do {
                if (this.m_current_dim <= this.m_max_dimension && this.m_current_dim >= 0) continue;
                throw GeometryException.GeometryInternalError();
            } while (!this.m_had_geometry[this.m_current_dim]);
            ++this.m_index;
            return this.get_result_geometry(this.m_current_dim);
        }
        this.m_index = 0;
        assert (this.m_max_dimension >= 0);
        this.m_current_dim = this.m_max_dimension;
        return this.get_result_geometry(this.m_max_dimension);
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private boolean step_() {
        int dim;
        if (this.m_b_done) {
            return true;
        }
        Geometry geom = null;
        if (this.m_inputGeoms != null && (geom = this.m_inputGeoms.next()) == null) {
            this.m_b_done = true;
            this.m_inputGeoms = null;
        }
        ProgressTracker.checkAndThrow(this.m_progress_tracker);
        if (geom != null) {
            dim = geom.getDimension();
            this.m_had_geometry[dim] = true;
            if (dim >= this.m_max_dimension && !this.m_b_union_all_dimensions) {
                this.add_geom(dim, false, geom);
                if (dim > this.m_max_dimension && !this.m_b_union_all_dimensions) {
                    this.remove_all_bins_with_lower_dimension(dim);
                }
            }
        }
        if (this.m_added_geoms > 0) {
            block0: for (dim = 0; dim <= this.m_max_dimension; ++dim) {
                while (this.m_dim_geom_counts[dim] > 1) {
                    ArrayList<Geometry> batch_to_union = this.collect_geometries_to_union(dim);
                    boolean serial_execution = true;
                    if (!serial_execution) continue;
                    if (batch_to_union.size() == 0) continue block0;
                    Geometry geomRes = TopologicalOperations.dissolveDirty(batch_to_union, this.m_spatial_reference, this.m_progress_tracker);
                    this.add_geom(dim, true, geomRes);
                }
            }
        }
        return this.m_b_done;
    }

    ArrayList<Geometry> collect_geometries_to_union(int dim) {
        ArrayList<Geometry> batch_to_union = new ArrayList<Geometry>();
        ArrayList<Map.Entry<Integer, Bin_type>> entriesToRemove = new ArrayList<Map.Entry<Integer, Bin_type>>();
        Set<Map.Entry<Integer, Bin_type>> set2 = this.m_union_bins.get(dim).entrySet();
        for (Map.Entry<Integer, Bin_type> e : set2) {
            Bin_type bin = e.getValue();
            int binVertexThreshold = 10000;
            if (!this.m_b_done && (bin.bin_vertex_count <= 10000 || bin.geom_count() <= 1)) continue;
            int n = dim;
            this.m_dim_geom_counts[n] = this.m_dim_geom_counts[n] - bin.geom_count();
            this.m_added_geoms -= bin.geom_count();
            while (bin.geometries.size() > 0) {
                batch_to_union.add(bin.back_pair().geom);
                bin.pop_pair();
            }
            entriesToRemove.add(e);
        }
        set2.removeAll(entriesToRemove);
        return batch_to_union;
    }

    private void remove_all_bins_with_lower_dimension(int dim) {
        for (int i = 0; i < dim; ++i) {
            this.m_union_bins.get(i).clear();
            this.m_added_geoms -= this.m_dim_geom_counts[i];
            this.m_dim_geom_counts[i] = 0;
        }
    }

    private void add_geom(int dimension, boolean unioned, Geometry geom) {
        Bin_type bin;
        int sz;
        Geom_pair pair2 = new Geom_pair();
        pair2.init();
        pair2.geom = geom;
        pair2.vertex_count = sz = OperatorUnionCursor.get_vertex_count_(geom);
        int level = OperatorUnionCursor.get_level_(sz);
        if (dimension + 1 > this.m_union_bins.size()) {
            int n = Math.max(2, dimension + 1);
            for (int i = 0; i < n; ++i) {
                this.m_union_bins.add(new TreeMap());
            }
        }
        if ((bin = this.m_union_bins.get(dimension).get(level)) == null) {
            bin = new Bin_type();
            this.m_union_bins.get(dimension).put(level, bin);
        }
        pair2.unioned = unioned;
        bin.add_pair(pair2);
        int n = dimension;
        this.m_dim_geom_counts[n] = this.m_dim_geom_counts[n] + 1;
        ++this.m_added_geoms;
        this.m_max_dimension = Math.max(this.m_max_dimension, dimension);
    }

    private static int get_level_(int sz) {
        return sz > 0 ? (int)(Math.log(sz) / Math.log(4.0) + 0.5) : 0;
    }

    private static int get_vertex_count_(Geometry geom) {
        int gt = geom.getType().value();
        if (Geometry.isMultiVertex(gt)) {
            return ((MultiVertexGeometry)geom).getPointCount();
        }
        if (gt == 33) {
            return 1;
        }
        if (gt == 197) {
            return 4;
        }
        if (Geometry.isSegment(gt)) {
            return 2;
        }
        throw GeometryException.GeometryInternalError();
    }

    @Override
    public boolean tock() {
        return this.step_();
    }

    static final class Bin_type {
        int bin_vertex_count = 0;
        ArrayList<Geom_pair> geometries = new ArrayList();

        Bin_type() {
        }

        void add_pair(Geom_pair geom) {
            this.bin_vertex_count += geom.vertex_count;
            this.geometries.add(geom);
        }

        void pop_pair() {
            this.bin_vertex_count -= this.geometries.get((int)(this.geometries.size() - 1)).vertex_count;
            this.geometries.remove(this.geometries.size() - 1);
        }

        Geom_pair back_pair() {
            return this.geometries.get(this.geometries.size() - 1);
        }

        int geom_count() {
            return this.geometries.size();
        }
    }

    private static final class Geom_pair {
        Geometry geom;
        int vertex_count;
        boolean unioned;

        private Geom_pair() {
        }

        void init() {
            this.geom = null;
            this.vertex_count = -1;
            this.unioned = false;
        }
    }
}

