/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OGCStructure;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.WktParser;
import java.util.ArrayList;

class OperatorImportFromWktLocal
extends OperatorImportFromWkt {
    OperatorImportFromWktLocal() {
    }

    @Override
    public Geometry execute(int import_flags, Geometry.Type type, String wkt_string, ProgressTracker progress_tracker) {
        WktParser wkt_parser = new WktParser(wkt_string);
        int current_token = wkt_parser.nextToken();
        return OperatorImportFromWktLocal.importFromWkt(import_flags, type, wkt_parser);
    }

    @Override
    public OGCStructure executeOGC(int import_flags, String wkt_string, ProgressTracker progress_tracker) {
        ArrayList<OGCStructure> stack = new ArrayList<OGCStructure>(0);
        WktParser wkt_parser = new WktParser(wkt_string);
        OGCStructure root2 = new OGCStructure();
        root2.m_structures = new ArrayList<OGCStructure>(0);
        stack.add(root2);
        while (wkt_parser.nextToken() != 0) {
            int current_token = wkt_parser.currentToken();
            if (current_token == 52) {
                stack.remove(stack.size() - 1);
                continue;
            }
            int ogc_type = current_token;
            OGCStructure last2 = (OGCStructure)stack.get(stack.size() - 1);
            if (current_token == 7) {
                current_token = wkt_parser.nextToken();
                if (current_token == 1000 || current_token == 2000 || current_token == 3000) {
                    wkt_parser.nextToken();
                }
                OGCStructure next2 = new OGCStructure();
                next2.m_type = ogc_type;
                next2.m_structures = new ArrayList<OGCStructure>(0);
                last2.m_structures.add(next2);
                if (current_token == 50) continue;
                stack.add(next2);
                continue;
            }
            Geometry geometry = OperatorImportFromWktLocal.importFromWkt(import_flags, Geometry.Type.Unknown, wkt_parser);
            OGCStructure leaf = new OGCStructure();
            leaf.m_type = ogc_type;
            leaf.m_geometry = geometry;
            last2.m_structures.add(leaf);
        }
        return root2;
    }

    static Geometry importFromWkt(int import_flags, Geometry.Type type, WktParser wkt_parser) {
        int current_token = wkt_parser.currentToken();
        switch (current_token) {
            case 6: {
                if (type != Geometry.Type.Polygon && type != Geometry.Type.Unknown) {
                    throw new IllegalArgumentException("invalid shapetype");
                }
                return OperatorImportFromWktLocal.polygonTaggedText(true, import_flags, wkt_parser);
            }
            case 5: {
                if (type != Geometry.Type.Polyline && type != Geometry.Type.Unknown) {
                    throw new IllegalArgumentException("invalid shapetype");
                }
                return OperatorImportFromWktLocal.lineStringTaggedText(true, import_flags, wkt_parser);
            }
            case 4: {
                if (type != Geometry.Type.MultiPoint && type != Geometry.Type.Unknown) {
                    throw new IllegalArgumentException("invalid shapetype");
                }
                return OperatorImportFromWktLocal.multiPointTaggedText(import_flags, wkt_parser);
            }
            case 3: {
                if (type != Geometry.Type.Polygon && type != Geometry.Type.Unknown) {
                    throw new IllegalArgumentException("invalid shapetype");
                }
                return OperatorImportFromWktLocal.polygonTaggedText(false, import_flags, wkt_parser);
            }
            case 2: {
                if (type != Geometry.Type.Polyline && type != Geometry.Type.Unknown) {
                    throw new IllegalArgumentException("invalid shapetype");
                }
                return OperatorImportFromWktLocal.lineStringTaggedText(false, import_flags, wkt_parser);
            }
            case 1: {
                if (type != Geometry.Type.Point && type != Geometry.Type.Unknown) {
                    throw new IllegalArgumentException("invalid shapetype");
                }
                return OperatorImportFromWktLocal.pointTaggedText(import_flags, wkt_parser);
            }
        }
        return null;
    }

    static Geometry polygonTaggedText(boolean b_multi_polygon, int import_flags, WktParser wkt_parser) {
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfDbl position2 = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
        AttributeStreamOfInt32 paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(1, 0);
        AttributeStreamOfInt8 path_flags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(1, (byte)0);
        Polygon multi_path = new Polygon();
        MultiPathImpl multi_path_impl = (MultiPathImpl)multi_path._getImpl();
        int current_token = wkt_parser.nextToken();
        if (current_token == 1000) {
            zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_path_impl.addAttribute(1);
            wkt_parser.nextToken();
        } else if (current_token == 2000) {
            ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_path_impl.addAttribute(2);
            wkt_parser.nextToken();
        } else if (current_token == 3000) {
            zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_path_impl.addAttribute(1);
            multi_path_impl.addAttribute(2);
            wkt_parser.nextToken();
        }
        int point_count = b_multi_polygon ? OperatorImportFromWktLocal.multiPolygonText(zs, ms, position2, paths, path_flags, wkt_parser) : OperatorImportFromWktLocal.polygonText(zs, ms, position2, paths, path_flags, 0, wkt_parser);
        if (point_count != 0) {
            assert (2 * point_count == position2.size());
            multi_path_impl.setAttributeStreamRef(0, position2);
            multi_path_impl.setPathStreamRef(paths);
            multi_path_impl.setPathFlagsStreamRef(path_flags);
            if (zs != null) {
                multi_path_impl.setAttributeStreamRef(1, zs);
            }
            if (ms != null) {
                multi_path_impl.setAttributeStreamRef(2, ms);
            }
            multi_path_impl.notifyModified(0xFFFFFF);
            AttributeStreamOfInt8 path_flags_clone = new AttributeStreamOfInt8(path_flags);
            for (int i = 0; i < path_flags_clone.size() - 1; ++i) {
                if ((path_flags_clone.read(i) & 4) != 0) {
                    if (InternalUtils.isClockwiseRing(multi_path_impl, i)) continue;
                    multi_path_impl.reversePath(i);
                    continue;
                }
                if (!InternalUtils.isClockwiseRing(multi_path_impl, i)) continue;
                multi_path_impl.reversePath(i);
            }
            multi_path_impl.setPathFlagsStreamRef(path_flags_clone);
        }
        if ((import_flags & 2) == 0) {
            multi_path_impl.setIsSimple(1, 0.0, false);
        }
        multi_path_impl.setDirtyOGCFlags(false);
        return multi_path;
    }

    static Geometry lineStringTaggedText(boolean b_multi_linestring, int import_flags, WktParser wkt_parser) {
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfDbl position2 = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
        AttributeStreamOfInt32 paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(1, 0);
        AttributeStreamOfInt8 path_flags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(1, (byte)0);
        Polyline multi_path = new Polyline();
        MultiPathImpl multi_path_impl = (MultiPathImpl)multi_path._getImpl();
        int current_token = wkt_parser.nextToken();
        if (current_token == 1000) {
            zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_path_impl.addAttribute(1);
            wkt_parser.nextToken();
        } else if (current_token == 2000) {
            ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_path_impl.addAttribute(2);
            wkt_parser.nextToken();
        } else if (current_token == 3000) {
            zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_path_impl.addAttribute(1);
            multi_path_impl.addAttribute(2);
            wkt_parser.nextToken();
        }
        int point_count = b_multi_linestring ? OperatorImportFromWktLocal.multiLineStringText(zs, ms, position2, paths, path_flags, wkt_parser) : OperatorImportFromWktLocal.lineStringText(false, zs, ms, position2, paths, path_flags, wkt_parser);
        if (point_count != 0) {
            assert (2 * point_count == position2.size());
            multi_path_impl.setAttributeStreamRef(0, position2);
            multi_path_impl.setPathStreamRef(paths);
            multi_path_impl.setPathFlagsStreamRef(path_flags);
            if (zs != null) {
                multi_path_impl.setAttributeStreamRef(1, zs);
            }
            if (ms != null) {
                multi_path_impl.setAttributeStreamRef(2, ms);
            }
            multi_path_impl.notifyModified(0xFFFFFF);
        }
        return multi_path;
    }

    static Geometry multiPointTaggedText(int import_flags, WktParser wkt_parser) {
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfDbl position2 = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
        MultiPoint multi_point = new MultiPoint();
        MultiPointImpl multi_point_impl = (MultiPointImpl)multi_point._getImpl();
        int current_token = wkt_parser.nextToken();
        if (current_token == 1000) {
            zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_point_impl.addAttribute(1);
            wkt_parser.nextToken();
        } else if (current_token == 2000) {
            ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_point_impl.addAttribute(2);
            wkt_parser.nextToken();
        } else if (current_token == 3000) {
            zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0, Double.NaN);
            multi_point_impl.addAttribute(1);
            multi_point_impl.addAttribute(2);
            wkt_parser.nextToken();
        }
        int point_count = OperatorImportFromWktLocal.multiPointText(zs, ms, position2, wkt_parser);
        if (point_count != 0) {
            assert (2 * point_count == position2.size());
            multi_point_impl.resize(point_count);
            multi_point_impl.setAttributeStreamRef(0, position2);
            if (zs != null) {
                multi_point_impl.setAttributeStreamRef(1, zs);
            }
            if (ms != null) {
                multi_point_impl.setAttributeStreamRef(2, ms);
            }
            multi_point_impl.notifyModified(0xFFFFFF);
        }
        return multi_point;
    }

    static Geometry pointTaggedText(int import_flags, WktParser wkt_parser) {
        Point point = new Point();
        int current_token = wkt_parser.nextToken();
        if (current_token == 1000) {
            point.addAttribute(1);
            wkt_parser.nextToken();
        } else if (current_token == 2000) {
            point.addAttribute(2);
            wkt_parser.nextToken();
        } else if (current_token == 3000) {
            point.addAttribute(1);
            point.addAttribute(2);
            wkt_parser.nextToken();
        }
        current_token = wkt_parser.currentToken();
        if (current_token != 50) {
            wkt_parser.nextToken();
            double x = wkt_parser.currentNumericLiteral();
            wkt_parser.nextToken();
            double y = wkt_parser.currentNumericLiteral();
            wkt_parser.nextToken();
            point.setXY(x, y);
            if (wkt_parser.hasZs()) {
                double z = wkt_parser.currentNumericLiteral();
                wkt_parser.nextToken();
                point.setZ(z);
            }
            if (wkt_parser.hasMs()) {
                double m = wkt_parser.currentNumericLiteral();
                wkt_parser.nextToken();
                point.setM(m);
            }
        }
        return point;
    }

    static int multiPolygonText(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, WktParser wkt_parser) {
        int current_token = wkt_parser.currentToken();
        int total_point_count = 0;
        if (current_token == 50) {
            return total_point_count;
        }
        current_token = wkt_parser.nextToken();
        while (current_token != 52) {
            total_point_count = OperatorImportFromWktLocal.polygonText(zs, ms, position2, paths, path_flags, total_point_count, wkt_parser);
            current_token = wkt_parser.nextToken();
        }
        return total_point_count;
    }

    static int multiLineStringText(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, WktParser wkt_parser) {
        int current_token = wkt_parser.currentToken();
        int total_point_count = 0;
        if (current_token == 50) {
            return total_point_count;
        }
        current_token = wkt_parser.nextToken();
        while (current_token != 52) {
            int point_count = OperatorImportFromWktLocal.lineStringText(false, zs, ms, position2, paths, path_flags, wkt_parser);
            total_point_count += point_count;
            current_token = wkt_parser.nextToken();
        }
        return total_point_count;
    }

    static int multiPointText(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, WktParser wkt_parser) {
        int current_token = wkt_parser.currentToken();
        int point_count = 0;
        if (current_token == 50) {
            return point_count;
        }
        current_token = wkt_parser.nextToken();
        while (current_token != 52) {
            point_count += OperatorImportFromWktLocal.pointText(zs, ms, position2, wkt_parser);
            if (current_token == 51 || current_token == 50) {
                current_token = wkt_parser.nextToken();
                continue;
            }
            current_token = wkt_parser.currentToken();
        }
        return point_count;
    }

    static int polygonText(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, int total_point_count, WktParser wkt_parser) {
        int current_token = wkt_parser.currentToken();
        if (current_token == 50) {
            return total_point_count;
        }
        boolean b_first_line_string = true;
        current_token = wkt_parser.nextToken();
        while (current_token != 52) {
            int point_count = OperatorImportFromWktLocal.lineStringText(true, zs, ms, position2, paths, path_flags, wkt_parser);
            if (point_count != 0) {
                if (b_first_line_string) {
                    b_first_line_string = false;
                    path_flags.setBits(path_flags.size() - 2, (byte)4);
                }
                path_flags.setBits(path_flags.size() - 2, (byte)1);
                total_point_count += point_count;
            }
            current_token = wkt_parser.nextToken();
        }
        return total_point_count;
    }

    static int lineStringText(boolean b_ring, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, WktParser wkt_parser) {
        int current_token = wkt_parser.currentToken();
        int point_count = 0;
        if (current_token == 50) {
            return point_count;
        }
        boolean b_start_path = true;
        double startx = Double.NaN;
        double starty = Double.NaN;
        double startz = Double.NaN;
        double startm = Double.NaN;
        current_token = wkt_parser.nextToken();
        while (current_token != 52) {
            double x = wkt_parser.currentNumericLiteral();
            wkt_parser.nextToken();
            double y = wkt_parser.currentNumericLiteral();
            wkt_parser.nextToken();
            double z = Double.NaN;
            double m = Double.NaN;
            if (wkt_parser.hasZs()) {
                z = wkt_parser.currentNumericLiteral();
                wkt_parser.nextToken();
            }
            if (wkt_parser.hasMs()) {
                m = wkt_parser.currentNumericLiteral();
                wkt_parser.nextToken();
            }
            current_token = wkt_parser.currentToken();
            boolean b_add_point = true;
            if (b_ring && point_count >= 2 && current_token == 52 && (startx == x || NumberUtils.isNaN(startx) && NumberUtils.isNaN(x)) && (starty == y || NumberUtils.isNaN(starty) && NumberUtils.isNaN(y)) && (!wkt_parser.hasZs() || startz == z || NumberUtils.isNaN(startz) && NumberUtils.isNaN(z)) && (!wkt_parser.hasMs() || startm == m || NumberUtils.isNaN(startm) && NumberUtils.isNaN(m))) {
                b_add_point = false;
            }
            if (!b_add_point) continue;
            if (b_start_path) {
                b_start_path = false;
                startx = x;
                starty = y;
                startz = z;
                startm = m;
            }
            ++point_count;
            OperatorImportFromWktLocal.addToStreams(zs, ms, position2, x, y, z, m);
        }
        if (point_count == 1) {
            ++point_count;
            OperatorImportFromWktLocal.addToStreams(zs, ms, position2, startx, starty, startz, startm);
        }
        paths.add(position2.size() / 2);
        path_flags.add((byte)0);
        return point_count;
    }

    static int pointText(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, WktParser wkt_parser) {
        int current_token = wkt_parser.currentToken();
        if (current_token == 50) {
            return 0;
        }
        if (current_token == 51) {
            wkt_parser.nextToken();
        }
        double x = wkt_parser.currentNumericLiteral();
        wkt_parser.nextToken();
        double y = wkt_parser.currentNumericLiteral();
        wkt_parser.nextToken();
        double z = Double.NaN;
        double m = Double.NaN;
        if (zs != null) {
            z = wkt_parser.currentNumericLiteral();
            wkt_parser.nextToken();
        }
        if (ms != null) {
            m = wkt_parser.currentNumericLiteral();
            wkt_parser.nextToken();
        }
        OperatorImportFromWktLocal.addToStreams(zs, ms, position2, x, y, z, m);
        return 1;
    }

    static void addToStreams(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, double x, double y, double z, double m) {
        position2.add(x);
        position2.add(y);
        if (zs != null) {
            zs.add(z);
        }
        if (ms != null) {
            ms.add(m);
        }
    }
}

