/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OGCStructure;
import com.esri.core.geometry.OperatorImportFromWkb;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class OperatorImportFromWkbLocal
extends OperatorImportFromWkb {
    OperatorImportFromWkbLocal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Geometry execute(int importFlags, Geometry.Type type, ByteBuffer wkbBuffer, ProgressTracker progress_tracker) {
        ByteOrder initialOrder = wkbBuffer.order();
        byte byteOrder = wkbBuffer.get(0);
        if (byteOrder == 1) {
            wkbBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            wkbBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        WkbHelper wkbHelper = new WkbHelper(wkbBuffer);
        try {
            Geometry geometry = OperatorImportFromWkbLocal.importFromWkb(importFlags, type, wkbHelper);
            return geometry;
        }
        finally {
            wkbBuffer.order(initialOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OGCStructure executeOGC(int importFlags, ByteBuffer wkbBuffer, ProgressTracker progress_tracker) {
        ByteOrder initialOrder = wkbBuffer.order();
        byte byteOrder = wkbBuffer.get(0);
        if (byteOrder == 1) {
            wkbBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            wkbBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        ArrayList<OGCStructure> stack = new ArrayList<OGCStructure>(0);
        AttributeStreamOfInt32 numGeometries = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 indices = new AttributeStreamOfInt32(0);
        WkbHelper wkbHelper = new WkbHelper(wkbBuffer);
        OGCStructure root2 = new OGCStructure();
        root2.m_structures = new ArrayList<OGCStructure>(0);
        stack.add(root2);
        numGeometries.add(1);
        indices.add(0);
        boolean bCheckConsistentAttributes = false;
        boolean bHasZs = false;
        boolean bHasMs = false;
        try {
            while (!stack.isEmpty()) {
                int ogcType;
                if (indices.getLast() == numGeometries.getLast()) {
                    stack.remove(stack.size() - 1);
                    indices.removeLast();
                    numGeometries.removeLast();
                    continue;
                }
                OGCStructure last2 = (OGCStructure)stack.get(stack.size() - 1);
                indices.write(indices.size() - 1, indices.getLast() + 1);
                int wkbType = wkbHelper.getInt(1);
                if (wkbType > 3000) {
                    ogcType = wkbType - 3000;
                    if (bCheckConsistentAttributes) {
                        if (!bHasZs || !bHasMs) {
                            throw new IllegalArgumentException();
                        }
                    } else {
                        bHasZs = true;
                        bHasMs = true;
                        bCheckConsistentAttributes = true;
                    }
                } else if (wkbType > 2000) {
                    ogcType = wkbType - 2000;
                    if (bCheckConsistentAttributes) {
                        if (bHasZs || !bHasMs) {
                            throw new IllegalArgumentException();
                        }
                    } else {
                        bHasZs = false;
                        bHasMs = true;
                        bCheckConsistentAttributes = true;
                    }
                } else if (wkbType > 1000) {
                    ogcType = wkbType - 1000;
                    if (bCheckConsistentAttributes) {
                        if (!bHasZs || bHasMs) {
                            throw new IllegalArgumentException();
                        }
                    } else {
                        bHasZs = true;
                        bHasMs = false;
                        bCheckConsistentAttributes = true;
                    }
                } else {
                    ogcType = wkbType;
                    if (bCheckConsistentAttributes) {
                        if (bHasZs || bHasMs) {
                            throw new IllegalArgumentException();
                        }
                    } else {
                        bHasZs = false;
                        bHasMs = false;
                        bCheckConsistentAttributes = true;
                    }
                }
                if (ogcType == 7) {
                    int count2 = wkbHelper.getInt(5);
                    wkbHelper.adjustment += 9;
                    OGCStructure next2 = new OGCStructure();
                    next2.m_type = ogcType;
                    next2.m_structures = new ArrayList<OGCStructure>(0);
                    last2.m_structures.add(next2);
                    stack.add(next2);
                    indices.add(0);
                    numGeometries.add(count2);
                    continue;
                }
                Geometry geometry = OperatorImportFromWkbLocal.importFromWkb(importFlags, Geometry.Type.Unknown, wkbHelper);
                OGCStructure leaf = new OGCStructure();
                leaf.m_type = ogcType;
                leaf.m_geometry = geometry;
                last2.m_structures.add(leaf);
            }
        }
        finally {
            wkbBuffer.order(initialOrder);
        }
        return root2;
    }

    private static Geometry importFromWkb(int importFlags, Geometry.Type type, WkbHelper wkbHelper) {
        int wkbType = wkbHelper.getInt(1);
        switch (wkbType) {
            case 3: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(false, importFlags, false, false, wkbHelper);
            }
            case 2003: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(false, importFlags, false, true, wkbHelper);
            }
            case 1003: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(false, importFlags, true, false, wkbHelper);
            }
            case 3003: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(false, importFlags, true, true, wkbHelper);
            }
            case 6: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(true, importFlags, false, false, wkbHelper);
            }
            case 2006: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(true, importFlags, false, true, wkbHelper);
            }
            case 1006: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(true, importFlags, true, false, wkbHelper);
            }
            case 3006: {
                if (type.value() != 1736 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolygon(true, importFlags, true, true, wkbHelper);
            }
            case 2: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(false, importFlags, false, false, wkbHelper);
            }
            case 2002: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(false, importFlags, false, true, wkbHelper);
            }
            case 1002: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(false, importFlags, true, false, wkbHelper);
            }
            case 3002: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(false, importFlags, true, true, wkbHelper);
            }
            case 5: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(true, importFlags, false, false, wkbHelper);
            }
            case 2005: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(true, importFlags, false, true, wkbHelper);
            }
            case 1005: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(true, importFlags, true, false, wkbHelper);
            }
            case 3005: {
                if (type.value() != 1607 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPolyline(true, importFlags, true, true, wkbHelper);
            }
            case 4: {
                if (type.value() != 550 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbMultiPoint(importFlags, false, false, wkbHelper);
            }
            case 2004: {
                if (type.value() != 550 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbMultiPoint(importFlags, false, true, wkbHelper);
            }
            case 1004: {
                if (type.value() != 550 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbMultiPoint(importFlags, true, false, wkbHelper);
            }
            case 3004: {
                if (type.value() != 550 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbMultiPoint(importFlags, true, true, wkbHelper);
            }
            case 1: {
                if (type.value() != 33 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPoint(importFlags, false, false, wkbHelper);
            }
            case 2001: {
                if (type.value() != 33 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPoint(importFlags, false, true, wkbHelper);
            }
            case 1001: {
                if (type.value() != 33 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPoint(importFlags, true, false, wkbHelper);
            }
            case 3001: {
                if (type.value() != 33 && type.value() != 0) {
                    throw new GeometryException("invalid shape type");
                }
                return OperatorImportFromWkbLocal.importFromWkbPoint(importFlags, true, true, wkbHelper);
            }
        }
        throw new GeometryException("invalid shape type");
    }

    private static Geometry importFromWkbPolygon(boolean bMultiPolygon, int importFlags, boolean bZs, boolean bMs, WkbHelper wkbHelper) {
        int offset;
        int polygonCount;
        if (bMultiPolygon) {
            polygonCount = wkbHelper.getInt(5);
            offset = 9;
        } else {
            polygonCount = 1;
            offset = 0;
        }
        int point_count = 0;
        int partCount = 0;
        int tempOffset = offset;
        for (int ipolygon = 0; ipolygon < polygonCount; ++ipolygon) {
            int ipartcount = wkbHelper.getInt(tempOffset += 5);
            tempOffset += 4;
            for (int ipart = 0; ipart < ipartcount; ++ipart) {
                int ipointcount = wkbHelper.getInt(tempOffset);
                tempOffset += 4;
                if (ipointcount == 0) continue;
                if (ipointcount <= 2) {
                    tempOffset += ipointcount * 2 * 8;
                    if (bZs) {
                        tempOffset += ipointcount * 8;
                    }
                    if (bMs) {
                        tempOffset += ipointcount * 8;
                    }
                    point_count = ipointcount == 1 ? (point_count += ipointcount + 1) : (point_count += ipointcount);
                    ++partCount;
                    continue;
                }
                double startx = wkbHelper.getDouble(tempOffset);
                double starty = wkbHelper.getDouble(tempOffset += 8);
                tempOffset += 8;
                double startz = Double.NaN;
                double startm = Double.NaN;
                if (bZs) {
                    startz = wkbHelper.getDouble(tempOffset);
                    tempOffset += 8;
                }
                if (bMs) {
                    startm = wkbHelper.getDouble(tempOffset);
                    tempOffset += 8;
                }
                tempOffset += (ipointcount - 2) * 2 * 8;
                if (bZs) {
                    tempOffset += (ipointcount - 2) * 8;
                }
                if (bMs) {
                    tempOffset += (ipointcount - 2) * 8;
                }
                double endx = wkbHelper.getDouble(tempOffset);
                double endy = wkbHelper.getDouble(tempOffset += 8);
                tempOffset += 8;
                double endz = Double.NaN;
                double endm = Double.NaN;
                if (bZs) {
                    endz = wkbHelper.getDouble(tempOffset);
                    tempOffset += 8;
                }
                if (bMs) {
                    endm = wkbHelper.getDouble(tempOffset);
                    tempOffset += 8;
                }
                point_count = (startx == endx || NumberUtils.isNaN(startx) && NumberUtils.isNaN(endx)) && (starty == endy || NumberUtils.isNaN(starty) && NumberUtils.isNaN(endy)) && (!bZs || startz == endz || NumberUtils.isNaN(startz) && NumberUtils.isNaN(endz)) && (!bMs || startm == endm || NumberUtils.isNaN(startm) && NumberUtils.isNaN(endm)) ? (point_count += ipointcount - 1) : (point_count += ipointcount);
                ++partCount;
            }
        }
        AttributeStreamOfDbl position2 = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt32 parts = null;
        AttributeStreamOfInt8 pathFlags = null;
        Polygon newPolygon = new Polygon();
        MultiPathImpl polygon = (MultiPathImpl)((Geometry)newPolygon)._getImpl();
        if (bZs) {
            polygon.addAttribute(1);
        }
        if (bMs) {
            polygon.addAttribute(2);
        }
        if (point_count > 0) {
            parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(partCount + 1, 0);
            pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(parts.size(), (byte)1);
            position2 = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(0, point_count);
            if (bZs) {
                zs = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(1, point_count);
            }
            if (bMs) {
                ms = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(2, point_count);
            }
        }
        boolean bCreateMs = false;
        boolean bCreateZs = false;
        int ipartend = 0;
        int ipolygonend = 0;
        int part_index = 0;
        for (int ipolygon = 0; ipolygon < polygonCount; ++ipolygon) {
            int ipartcount = wkbHelper.getInt(offset += 5);
            offset += 4;
            int ipolygonstart = ipolygonend;
            ipolygonend = ipolygonstart + ipartcount;
            for (int ipart = ipolygonstart; ipart < ipolygonend; ++ipart) {
                int ipointcount = wkbHelper.getInt(offset);
                offset += 4;
                if (ipointcount == 0) continue;
                int ipartstart = ipartend;
                ipartend += ipointcount;
                boolean bSkipLastPoint = true;
                if (ipointcount == 1) {
                    ++ipartstart;
                    ++ipartend;
                    bSkipLastPoint = false;
                } else if (ipointcount == 2) {
                    bSkipLastPoint = false;
                } else {
                    tempOffset = offset;
                    double startx = wkbHelper.getDouble(tempOffset);
                    double starty = wkbHelper.getDouble(tempOffset += 8);
                    tempOffset += 8;
                    double startz = Double.NaN;
                    double startm = Double.NaN;
                    if (bZs) {
                        startz = wkbHelper.getDouble(tempOffset);
                        tempOffset += 8;
                    }
                    if (bMs) {
                        startm = wkbHelper.getDouble(tempOffset);
                        tempOffset += 8;
                    }
                    tempOffset += (ipointcount - 2) * 2 * 8;
                    if (bZs) {
                        tempOffset += (ipointcount - 2) * 8;
                    }
                    if (bMs) {
                        tempOffset += (ipointcount - 2) * 8;
                    }
                    double endx = wkbHelper.getDouble(tempOffset);
                    double endy = wkbHelper.getDouble(tempOffset += 8);
                    tempOffset += 8;
                    double endz = Double.NaN;
                    double endm = Double.NaN;
                    if (bZs) {
                        endz = wkbHelper.getDouble(tempOffset);
                        tempOffset += 8;
                    }
                    if (bMs) {
                        endm = wkbHelper.getDouble(tempOffset);
                        tempOffset += 8;
                    }
                    if ((startx == endx || NumberUtils.isNaN(startx) && NumberUtils.isNaN(endx)) && (starty == endy || NumberUtils.isNaN(starty) && NumberUtils.isNaN(endy)) && (!bZs || startz == endz || NumberUtils.isNaN(startz) && NumberUtils.isNaN(endz)) && (!bMs || startm == endm || NumberUtils.isNaN(startm) && NumberUtils.isNaN(endm))) {
                        --ipartend;
                    } else {
                        bSkipLastPoint = false;
                    }
                }
                if (ipart == ipolygonstart) {
                    pathFlags.setBits(ipart, (byte)4);
                }
                parts.write(++part_index, ipartend);
                for (int i = ipartstart; i < ipartend; ++i) {
                    double x = wkbHelper.getDouble(offset);
                    double y = wkbHelper.getDouble(offset += 8);
                    offset += 8;
                    position2.write(2 * i, x);
                    position2.write(2 * i + 1, y);
                    if (bZs) {
                        double z = wkbHelper.getDouble(offset);
                        offset += 8;
                        zs.write(i, z);
                        if (!VertexDescription.isDefaultValue(1, z)) {
                            bCreateZs = true;
                        }
                    }
                    if (!bMs) continue;
                    double m = wkbHelper.getDouble(offset);
                    offset += 8;
                    ms.write(i, m);
                    if (VertexDescription.isDefaultValue(2, m)) continue;
                    bCreateMs = true;
                }
                if (bSkipLastPoint) {
                    offset += 16;
                    if (bZs) {
                        offset += 8;
                    }
                    if (!bMs) continue;
                    offset += 8;
                    continue;
                }
                if (ipointcount != 1) continue;
                double x = position2.read(2 * ipartstart);
                double y = position2.read(2 * ipartstart + 1);
                position2.write(2 * (ipartstart - 1), x);
                position2.write(2 * (ipartstart - 1) + 1, y);
                if (bZs) {
                    double z = zs.read(ipartstart);
                    zs.write(ipartstart - 1, z);
                }
                if (!bMs) continue;
                double m = ms.read(ipartstart);
                ms.write(ipartstart - 1, m);
            }
        }
        if (point_count > 0) {
            polygon.setPathStreamRef(parts);
            polygon.setPathFlagsStreamRef(pathFlags);
            polygon.setAttributeStreamRef(0, position2);
            if (bZs) {
                if (!bCreateZs) {
                    zs = null;
                }
                polygon.setAttributeStreamRef(1, zs);
            }
            if (bMs) {
                if (!bCreateMs) {
                    ms = null;
                }
                polygon.setAttributeStreamRef(2, ms);
            }
            polygon.notifyModified(0xFFFFFF);
            AttributeStreamOfInt8 path_flags_clone = new AttributeStreamOfInt8(pathFlags);
            for (int i = 0; i < path_flags_clone.size() - 1; ++i) {
                if ((path_flags_clone.read(i) & 4) != 0) {
                    if (InternalUtils.isClockwiseRing(polygon, i)) continue;
                    polygon.reversePath(i);
                    continue;
                }
                if (!InternalUtils.isClockwiseRing(polygon, i)) continue;
                polygon.reversePath(i);
            }
            polygon.setPathFlagsStreamRef(path_flags_clone);
        }
        if ((importFlags & 2) == 0) {
            polygon.setIsSimple(1, 0.0, false);
        }
        polygon.setDirtyOGCFlags(false);
        wkbHelper.adjustment += offset;
        return newPolygon;
    }

    private static Geometry importFromWkbPolyline(boolean bMultiPolyline, int importFlags, boolean bZs, boolean bMs, WkbHelper wkbHelper) {
        int offset;
        int originalPartCount;
        if (bMultiPolyline) {
            originalPartCount = wkbHelper.getInt(5);
            offset = 9;
        } else {
            originalPartCount = 1;
            offset = 0;
        }
        int point_count = 0;
        int partCount = 0;
        int tempOffset = offset;
        for (int ipart = 0; ipart < originalPartCount; ++ipart) {
            int ipointcount = wkbHelper.getInt(tempOffset += 5);
            tempOffset += 4;
            if (ipointcount == 0) continue;
            point_count += ipointcount;
            ++partCount;
            if (ipointcount == 1) {
                ++point_count;
            }
            tempOffset += ipointcount * 2 * 8;
            if (bZs) {
                tempOffset += ipointcount * 8;
            }
            if (!bMs) continue;
            tempOffset += ipointcount * 8;
        }
        AttributeStreamOfDbl position2 = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt32 parts = null;
        AttributeStreamOfInt8 pathFlags = null;
        Polyline newpolyline = new Polyline();
        MultiPathImpl polyline = (MultiPathImpl)newpolyline._getImpl();
        if (bZs) {
            polyline.addAttribute(1);
        }
        if (bMs) {
            polyline.addAttribute(2);
        }
        if (point_count > 0) {
            parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(partCount + 1, 0);
            pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(parts.size(), (byte)0);
            position2 = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(0, point_count);
            if (bZs) {
                zs = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(1, point_count);
            }
            if (bMs) {
                ms = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(2, point_count);
            }
        }
        boolean bCreateMs = false;
        boolean bCreateZs = false;
        int ipartend = 0;
        int part_index = 0;
        for (int ipart = 0; ipart < originalPartCount; ++ipart) {
            int ipointcount = wkbHelper.getInt(offset += 5);
            offset += 4;
            if (ipointcount == 0) continue;
            int ipartstart = ipartend;
            ipartend = ipartstart + ipointcount;
            if (ipointcount == 1) {
                ++ipartend;
            }
            parts.write(++part_index, ipartend);
            for (int i = ++ipartstart; i < ipartend; ++i) {
                double x = wkbHelper.getDouble(offset);
                double y = wkbHelper.getDouble(offset += 8);
                offset += 8;
                position2.write(2 * i, x);
                position2.write(2 * i + 1, y);
                if (bZs) {
                    double z = wkbHelper.getDouble(offset);
                    offset += 8;
                    zs.write(i, z);
                    if (!VertexDescription.isDefaultValue(1, z)) {
                        bCreateZs = true;
                    }
                }
                if (!bMs) continue;
                double m = wkbHelper.getDouble(offset);
                offset += 8;
                ms.write(i, m);
                if (VertexDescription.isDefaultValue(2, m)) continue;
                bCreateMs = true;
            }
            if (ipointcount != 1) continue;
            double x = position2.read(2 * ipartstart);
            double y = position2.read(2 * ipartstart + 1);
            position2.write(2 * (ipartstart - 1), x);
            position2.write(2 * (ipartstart - 1) + 1, y);
            if (bZs) {
                double z = zs.read(ipartstart);
                zs.write(ipartstart - 1, z);
            }
            if (!bMs) continue;
            double m = ms.read(ipartstart);
            ms.write(ipartstart - 1, m);
        }
        if (point_count > 0) {
            polyline.setPathStreamRef(parts);
            polyline.setPathFlagsStreamRef(pathFlags);
            polyline.setAttributeStreamRef(0, position2);
            if (bZs) {
                if (!bCreateZs) {
                    zs = null;
                }
                polyline.setAttributeStreamRef(1, zs);
            }
            if (bMs) {
                if (!bCreateMs) {
                    ms = null;
                }
                polyline.setAttributeStreamRef(2, ms);
            }
            polyline.notifyModified(0xFFFFFF);
        }
        wkbHelper.adjustment += offset;
        return newpolyline;
    }

    private static Geometry importFromWkbMultiPoint(int importFlags, boolean bZs, boolean bMs, WkbHelper wkbHelper) {
        int offset = 5;
        int point_count = wkbHelper.getInt(offset);
        offset += 4;
        AttributeStreamOfDbl position2 = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        MultiPoint newmultipoint = new MultiPoint();
        MultiPointImpl multipoint = (MultiPointImpl)newmultipoint._getImpl();
        if (bZs) {
            multipoint.addAttribute(1);
        }
        if (bMs) {
            multipoint.addAttribute(2);
        }
        if (point_count > 0) {
            position2 = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(0, point_count);
            if (bZs) {
                zs = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(1, point_count);
            }
            if (bMs) {
                ms = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(2, point_count);
            }
        }
        boolean bCreateMs = false;
        boolean bCreateZs = false;
        for (int i = 0; i < point_count; ++i) {
            double x = wkbHelper.getDouble(offset += 5);
            double y = wkbHelper.getDouble(offset += 8);
            offset += 8;
            position2.write(2 * i, x);
            position2.write(2 * i + 1, y);
            if (bZs) {
                double z = wkbHelper.getDouble(offset);
                offset += 8;
                zs.write(i, z);
                if (!VertexDescription.isDefaultValue(1, z)) {
                    bCreateZs = true;
                }
            }
            if (!bMs) continue;
            double m = wkbHelper.getDouble(offset);
            offset += 8;
            ms.write(i, m);
            if (VertexDescription.isDefaultValue(2, m)) continue;
            bCreateMs = true;
        }
        if (point_count > 0) {
            multipoint.resize(point_count);
            multipoint.setAttributeStreamRef(0, position2);
            if (bZs) {
                if (!bCreateZs) {
                    zs = null;
                }
                multipoint.setAttributeStreamRef(1, zs);
            }
            if (bMs) {
                if (!bCreateMs) {
                    ms = null;
                }
                multipoint.setAttributeStreamRef(2, ms);
            }
            multipoint.notifyModified(0xFFFFFF);
        }
        wkbHelper.adjustment += offset;
        return newmultipoint;
    }

    private static Geometry importFromWkbPoint(int importFlags, boolean bZs, boolean bMs, WkbHelper wkbHelper) {
        int offset = 5;
        double x = wkbHelper.getDouble(offset);
        double y = wkbHelper.getDouble(offset += 8);
        offset += 8;
        double z = Double.NaN;
        if (bZs) {
            z = wkbHelper.getDouble(offset);
            offset += 8;
        }
        double m = Double.NaN;
        if (bMs) {
            m = wkbHelper.getDouble(offset);
            offset += 8;
        }
        boolean bEmpty = NumberUtils.isNaN(x);
        Point point = new Point();
        if (!bEmpty) {
            point.setX(x);
            point.setY(y);
        }
        if (bZs) {
            point.addAttribute(1);
            if (!bEmpty) {
                point.setZ(z);
            }
        }
        if (bMs) {
            point.addAttribute(2);
            if (!bEmpty) {
                point.setM(m);
            }
        }
        wkbHelper.adjustment += offset;
        return point;
    }

    static final class WkbHelper {
        ByteBuffer wkbBuffer;
        int adjustment;

        WkbHelper(ByteBuffer buffer) {
            this.wkbBuffer = buffer;
            this.adjustment = 0;
        }

        int getInt(int offset) {
            return this.wkbBuffer.getInt(this.adjustment + offset);
        }

        double getDouble(int offset) {
            return this.wkbBuffer.getDouble(this.adjustment + offset);
        }
    }
}

