/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.MapOGCStructure;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OGCStructure;
import com.esri.core.geometry.OperatorImportFromGeoJson;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OperatorImportFromGeoJsonLocal
extends OperatorImportFromGeoJson {
    OperatorImportFromGeoJsonLocal() {
    }

    @Override
    public MapGeometry execute(int importFlags, Geometry.Type type, String geoJsonString, ProgressTracker progress_tracker) throws JSONException {
        JSONObject geoJsonObject = new JSONObject(geoJsonString);
        Geometry geometry = OperatorImportFromGeoJsonLocal.importGeometryFromGeoJson_(importFlags, type, geoJsonObject);
        SpatialReference spatialReference = OperatorImportFromGeoJsonLocal.importSpatialReferenceFromGeoJson_(geoJsonObject);
        MapGeometry mapGeometry = new MapGeometry(geometry, spatialReference);
        return mapGeometry;
    }

    static JSONArray getJSONArray(JSONObject obj, String name2) throws JSONException {
        if (obj.get(name2) == JSONObject.NULL) {
            return new JSONArray();
        }
        return obj.getJSONArray(name2);
    }

    @Override
    public MapOGCStructure executeOGC(int import_flags, String geoJsonString, ProgressTracker progress_tracker) throws JSONException {
        JSONObject geoJsonObject = new JSONObject(geoJsonString);
        ArrayList<OGCStructure> structureStack = new ArrayList<OGCStructure>(0);
        ArrayList<JSONObject> objectStack = new ArrayList<JSONObject>(0);
        AttributeStreamOfInt32 indices = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 numGeometries = new AttributeStreamOfInt32(0);
        OGCStructure root2 = new OGCStructure();
        root2.m_structures = new ArrayList<OGCStructure>(0);
        structureStack.add(root2);
        objectStack.add(geoJsonObject);
        indices.add(0);
        numGeometries.add(1);
        while (!objectStack.isEmpty()) {
            int ogcType;
            if (indices.getLast() == numGeometries.getLast()) {
                structureStack.remove(structureStack.size() - 1);
                indices.removeLast();
                numGeometries.removeLast();
                continue;
            }
            OGCStructure lastStructure = (OGCStructure)structureStack.get(structureStack.size() - 1);
            JSONObject lastObject = (JSONObject)objectStack.get(objectStack.size() - 1);
            objectStack.remove(objectStack.size() - 1);
            indices.write(indices.size() - 1, indices.getLast() + 1);
            String typeString = lastObject.getString("type");
            if (typeString.equalsIgnoreCase("GeometryCollection")) {
                OGCStructure next2 = new OGCStructure();
                next2.m_type = 7;
                next2.m_structures = new ArrayList<OGCStructure>(0);
                lastStructure.m_structures.add(next2);
                structureStack.add(next2);
                JSONArray geometries = OperatorImportFromGeoJsonLocal.getJSONArray(lastObject, "geometries");
                indices.add(0);
                numGeometries.add(geometries.length());
                for (int i = geometries.length() - 1; i >= 0; --i) {
                    objectStack.add(geometries.getJSONObject(i));
                }
                continue;
            }
            if (typeString.equalsIgnoreCase("Point")) {
                ogcType = 1;
            } else if (typeString.equalsIgnoreCase("LineString")) {
                ogcType = 2;
            } else if (typeString.equalsIgnoreCase("Polygon")) {
                ogcType = 3;
            } else if (typeString.equalsIgnoreCase("MultiPoint")) {
                ogcType = 4;
            } else if (typeString.equalsIgnoreCase("MultiLineString")) {
                ogcType = 5;
            } else if (typeString.equalsIgnoreCase("MultiPolygon")) {
                ogcType = 6;
            } else {
                throw new UnsupportedOperationException();
            }
            Geometry geometry = OperatorImportFromGeoJsonLocal.importGeometryFromGeoJson_(import_flags, Geometry.Type.Unknown, lastObject);
            OGCStructure leaf = new OGCStructure();
            leaf.m_type = ogcType;
            leaf.m_geometry = geometry;
            lastStructure.m_structures.add(leaf);
        }
        MapOGCStructure mapOGCStructure = new MapOGCStructure();
        mapOGCStructure.m_ogcStructure = root2;
        mapOGCStructure.m_spatialReference = OperatorImportFromGeoJsonLocal.importSpatialReferenceFromGeoJson_(geoJsonObject);
        return mapOGCStructure;
    }

    private static SpatialReference importSpatialReferenceFromGeoJson_(JSONObject crsJSONObject) throws JSONException {
        String wkidString = crsJSONObject.optString("crs", "");
        if (wkidString.equals("")) {
            return SpatialReference.create(4326);
        }
        if (wkidString.length() <= 5) {
            throw new IllegalArgumentException();
        }
        int wkid = Integer.valueOf(wkidString.substring(5));
        return SpatialReference.create(wkid);
    }

    private static Geometry importGeometryFromGeoJson_(int importFlags, Geometry.Type type, JSONObject geometryJSONObject) throws JSONException {
        String typeString = geometryJSONObject.getString("type");
        JSONArray coordinateArray = OperatorImportFromGeoJsonLocal.getJSONArray(geometryJSONObject, "coordinates");
        if (typeString.equalsIgnoreCase("MultiPolygon")) {
            if (type != Geometry.Type.Polygon && type != Geometry.Type.Unknown) {
                throw new IllegalArgumentException("invalid shapetype");
            }
            return OperatorImportFromGeoJsonLocal.polygonTaggedText_(true, importFlags, coordinateArray);
        }
        if (typeString.equalsIgnoreCase("MultiLineString")) {
            if (type != Geometry.Type.Polyline && type != Geometry.Type.Unknown) {
                throw new IllegalArgumentException("invalid shapetype");
            }
            return OperatorImportFromGeoJsonLocal.lineStringTaggedText_(true, importFlags, coordinateArray);
        }
        if (typeString.equalsIgnoreCase("MultiPoint")) {
            if (type != Geometry.Type.MultiPoint && type != Geometry.Type.Unknown) {
                throw new IllegalArgumentException("invalid shapetype");
            }
            return OperatorImportFromGeoJsonLocal.multiPointTaggedText_(importFlags, coordinateArray);
        }
        if (typeString.equalsIgnoreCase("Polygon")) {
            if (type != Geometry.Type.Polygon && type != Geometry.Type.Unknown) {
                throw new IllegalArgumentException("invalid shapetype");
            }
            return OperatorImportFromGeoJsonLocal.polygonTaggedText_(false, importFlags, coordinateArray);
        }
        if (typeString.equalsIgnoreCase("LineString")) {
            if (type != Geometry.Type.Polyline && type != Geometry.Type.Unknown) {
                throw new IllegalArgumentException("invalid shapetype");
            }
            return OperatorImportFromGeoJsonLocal.lineStringTaggedText_(false, importFlags, coordinateArray);
        }
        if (typeString.equalsIgnoreCase("Point")) {
            if (type != Geometry.Type.Point && type != Geometry.Type.Unknown) {
                throw new IllegalArgumentException("invalid shapetype");
            }
            return OperatorImportFromGeoJsonLocal.pointTaggedText_(importFlags, coordinateArray);
        }
        return null;
    }

    private static Geometry polygonTaggedText_(boolean bMultiPolygon, int importFlags, JSONArray coordinateArray) throws JSONException {
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfDbl position2 = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
        AttributeStreamOfInt32 paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(1, 0);
        AttributeStreamOfInt8 path_flags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(1, (byte)0);
        Polygon multiPath = new Polygon();
        MultiPathImpl multiPathImpl = (MultiPathImpl)multiPath._getImpl();
        int pointCount = bMultiPolygon ? OperatorImportFromGeoJsonLocal.multiPolygonText_(zs, ms, position2, paths, path_flags, coordinateArray) : OperatorImportFromGeoJsonLocal.polygonText_(zs, ms, position2, paths, path_flags, 0, coordinateArray);
        if (pointCount != 0) {
            assert (2 * pointCount == position2.size());
            multiPathImpl.setAttributeStreamRef(0, position2);
            multiPathImpl.setPathStreamRef(paths);
            multiPathImpl.setPathFlagsStreamRef(path_flags);
            if (zs != null) {
                multiPathImpl.setAttributeStreamRef(1, zs);
            }
            if (ms != null) {
                multiPathImpl.setAttributeStreamRef(2, ms);
            }
            multiPathImpl.notifyModified(0xFFFFFF);
            AttributeStreamOfInt8 path_flags_clone = new AttributeStreamOfInt8(path_flags);
            for (int i = 0; i < path_flags_clone.size() - 1; ++i) {
                if ((path_flags_clone.read(i) & 4) != 0) {
                    if (InternalUtils.isClockwiseRing(multiPathImpl, i)) continue;
                    multiPathImpl.reversePath(i);
                    continue;
                }
                if (!InternalUtils.isClockwiseRing(multiPathImpl, i)) continue;
                multiPathImpl.reversePath(i);
            }
            multiPathImpl.setPathFlagsStreamRef(path_flags_clone);
        }
        if ((importFlags & 2) == 0) {
            multiPathImpl.setIsSimple(1, 0.0, false);
        }
        multiPathImpl.setDirtyOGCFlags(false);
        return multiPath;
    }

    private static Geometry lineStringTaggedText_(boolean bMultiLineString, int importFlags, JSONArray coordinateArray) throws JSONException {
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfDbl position2 = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
        AttributeStreamOfInt32 paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(1, 0);
        AttributeStreamOfInt8 path_flags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(1, (byte)0);
        Polyline multiPath = new Polyline();
        MultiPathImpl multiPathImpl = (MultiPathImpl)multiPath._getImpl();
        int pointCount = bMultiLineString ? OperatorImportFromGeoJsonLocal.multiLineStringText_(zs, ms, position2, paths, path_flags, coordinateArray) : OperatorImportFromGeoJsonLocal.lineStringText_(false, zs, ms, position2, paths, path_flags, coordinateArray);
        if (pointCount != 0) {
            assert (2 * pointCount == position2.size());
            multiPathImpl.setAttributeStreamRef(0, position2);
            multiPathImpl.setPathStreamRef(paths);
            multiPathImpl.setPathFlagsStreamRef(path_flags);
            if (zs != null) {
                multiPathImpl.setAttributeStreamRef(1, zs);
            }
            if (ms != null) {
                multiPathImpl.setAttributeStreamRef(2, ms);
            }
            multiPathImpl.notifyModified(0xFFFFFF);
        }
        return multiPath;
    }

    private static Geometry multiPointTaggedText_(int importFlags, JSONArray coordinateArray) throws JSONException {
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfDbl position2 = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
        MultiPoint multiPoint = new MultiPoint();
        MultiPointImpl multiPointImpl = (MultiPointImpl)multiPoint._getImpl();
        int pointCount = OperatorImportFromGeoJsonLocal.multiPointText_(zs, ms, position2, coordinateArray);
        if (pointCount != 0) {
            assert (2 * pointCount == position2.size());
            multiPointImpl.resize(pointCount);
            multiPointImpl.setAttributeStreamRef(0, position2);
            multiPointImpl.notifyModified(0xFFFFFF);
        }
        return multiPoint;
    }

    private static Geometry pointTaggedText_(int importFlags, JSONArray coordinateArray) throws JSONException {
        Point point = new Point();
        int length = coordinateArray.length();
        if (length == 0) {
            point.setEmpty();
            return point;
        }
        point.setXY(OperatorImportFromGeoJsonLocal.getDouble_(coordinateArray, 0), OperatorImportFromGeoJsonLocal.getDouble_(coordinateArray, 1));
        return point;
    }

    private static int multiPolygonText_(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, JSONArray coordinateArray) throws JSONException {
        int totalPointCount = 0;
        int length = coordinateArray.length();
        if (length == 0) {
            return totalPointCount;
        }
        for (int current = 0; current < length; ++current) {
            JSONArray subArray = coordinateArray.optJSONArray(current);
            if (subArray == null) {
                throw new IllegalArgumentException("");
            }
            totalPointCount = OperatorImportFromGeoJsonLocal.polygonText_(zs, ms, position2, paths, path_flags, totalPointCount, subArray);
        }
        return totalPointCount;
    }

    private static int multiLineStringText_(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, JSONArray coordinateArray) throws JSONException {
        int totalPointCount = 0;
        int length = coordinateArray.length();
        if (length == 0) {
            return totalPointCount;
        }
        for (int current = 0; current < length; ++current) {
            JSONArray subArray = coordinateArray.optJSONArray(current);
            if (subArray == null) {
                throw new IllegalArgumentException("");
            }
            totalPointCount += OperatorImportFromGeoJsonLocal.lineStringText_(false, zs, ms, position2, paths, path_flags, subArray);
        }
        return totalPointCount;
    }

    private static int multiPointText_(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, JSONArray coordinateArray) throws JSONException {
        int pointCount = 0;
        for (int current = 0; current < coordinateArray.length(); ++current) {
            JSONArray subArray = coordinateArray.optJSONArray(current);
            if (subArray == null) {
                throw new IllegalArgumentException("");
            }
            pointCount += OperatorImportFromGeoJsonLocal.pointText_(zs, ms, position2, subArray);
        }
        return pointCount;
    }

    private static int polygonText_(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, int totalPointCount, JSONArray coordinateArray) throws JSONException {
        int length = coordinateArray.length();
        if (length == 0) {
            return totalPointCount;
        }
        boolean bFirstLineString = true;
        for (int current = 0; current < length; ++current) {
            JSONArray subArray = coordinateArray.optJSONArray(current);
            if (subArray == null) {
                throw new IllegalArgumentException("");
            }
            int pointCount = OperatorImportFromGeoJsonLocal.lineStringText_(true, zs, ms, position2, paths, path_flags, subArray);
            if (pointCount == 0) continue;
            if (bFirstLineString) {
                bFirstLineString = false;
                path_flags.setBits(path_flags.size() - 2, (byte)4);
            }
            path_flags.setBits(path_flags.size() - 2, (byte)1);
            totalPointCount += pointCount;
        }
        return totalPointCount;
    }

    private static int lineStringText_(boolean bRing, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, AttributeStreamOfInt32 paths, AttributeStreamOfInt8 path_flags, JSONArray coordinateArray) throws JSONException {
        int pointCount = 0;
        int length = coordinateArray.length();
        if (length == 0) {
            return pointCount;
        }
        boolean bStartPath = true;
        double startX = Double.NaN;
        double startY = Double.NaN;
        double startZ = Double.NaN;
        double startM = Double.NaN;
        for (int current = 0; current < length; ++current) {
            JSONArray subArray = coordinateArray.optJSONArray(current);
            if (subArray == null) {
                throw new IllegalArgumentException("");
            }
            double x = OperatorImportFromGeoJsonLocal.getDouble_(subArray, 0);
            double y = OperatorImportFromGeoJsonLocal.getDouble_(subArray, 1);
            double z = Double.NaN;
            double m = Double.NaN;
            boolean bAddPoint = true;
            if (bRing && pointCount >= 2 && current == length - 1 && (startX == x || NumberUtils.isNaN(startX) && NumberUtils.isNaN(x)) && (startY == y || NumberUtils.isNaN(startY) && NumberUtils.isNaN(y))) {
                bAddPoint = false;
            }
            if (!bAddPoint) continue;
            if (bStartPath) {
                bStartPath = false;
                startX = x;
                startY = y;
                startZ = z;
                startM = m;
            }
            ++pointCount;
            OperatorImportFromGeoJsonLocal.addToStreams_(zs, ms, position2, x, y, z, m);
        }
        if (pointCount == 1) {
            ++pointCount;
            OperatorImportFromGeoJsonLocal.addToStreams_(zs, ms, position2, startX, startY, startZ, startM);
        }
        paths.add(position2.size() / 2);
        path_flags.add((byte)0);
        return pointCount;
    }

    private static int pointText_(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, JSONArray coordinateArray) throws JSONException {
        int length = coordinateArray.length();
        if (length == 0) {
            return 0;
        }
        double x = OperatorImportFromGeoJsonLocal.getDouble_(coordinateArray, 0);
        double y = OperatorImportFromGeoJsonLocal.getDouble_(coordinateArray, 1);
        double z = Double.NaN;
        double m = Double.NaN;
        OperatorImportFromGeoJsonLocal.addToStreams_(zs, ms, position2, x, y, z, m);
        return 1;
    }

    private static void addToStreams_(AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position2, double x, double y, double z, double m) {
        position2.add(x);
        position2.add(y);
        if (zs != null) {
            zs.add(z);
        }
        if (ms != null) {
            ms.add(m);
        }
    }

    private static double getDouble_(JSONArray coordinateArray, int index2) throws JSONException {
        if (index2 < 0 || index2 >= coordinateArray.length()) {
            throw new IllegalArgumentException("");
        }
        if (coordinateArray.isNull(index2)) {
            return Double.NaN;
        }
        if (coordinateArray.optDouble(index2, Double.NaN) != Double.NaN) {
            return coordinateArray.getDouble(index2);
        }
        throw new IllegalArgumentException("");
    }
}

