/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;

final class MathUtils {
    MathUtils() {
    }

    static double copySign(double x, double y) {
        return y >= 0.0 ? Math.abs(x) : -Math.abs(x);
    }

    static int sign(double value2) {
        return value2 < 0.0 ? -1 : (value2 > 0.0 ? 1 : 0);
    }

    static double FMod(double x, double y) {
        return x - Math.floor(x / y) * y;
    }

    static double round(double v) {
        return Math.floor(v + 0.5);
    }

    static double sqr(double v) {
        return v * v;
    }

    static double lerp(double start_, double end_, double t) {
        double v = t <= 0.5 ? start_ + (end_ - start_) * t : end_ - (end_ - start_) * (1.0 - t);
        assert (t < 0.0 || t > 1.0 || v >= start_ && v <= end_ || v <= start_ && v >= end_ || NumberUtils.isNaN(start_) || NumberUtils.isNaN(end_));
        return v;
    }

    static void lerp(Point2D start_, Point2D end_, double t, Point2D result2) {
        if (t <= 0.5) {
            result2.x = start_.x + (end_.x - start_.x) * t;
            result2.y = start_.y + (end_.y - start_.y) * t;
        } else {
            result2.x = end_.x - (end_.x - start_.x) * (1.0 - t);
            result2.y = end_.y - (end_.y - start_.y) * (1.0 - t);
        }
        assert (t < 0.0 || t > 1.0 || result2.x >= start_.x && result2.x <= end_.x || result2.x <= start_.x && result2.x >= end_.x);
        assert (t < 0.0 || t > 1.0 || result2.y >= start_.y && result2.y <= end_.y || result2.y <= start_.y && result2.y >= end_.y);
    }

    static void lerp(double start_x, double start_y, double end_x, double end_y, double t, Point2D result2) {
        if (t <= 0.5) {
            result2.x = start_x + (end_x - start_x) * t;
            result2.y = start_y + (end_y - start_y) * t;
        } else {
            result2.x = end_x - (end_x - start_x) * (1.0 - t);
            result2.y = end_y - (end_y - start_y) * (1.0 - t);
        }
        assert (t < 0.0 || t > 1.0 || result2.x >= start_x && result2.x <= end_x || result2.x <= start_x && result2.x >= end_x);
        assert (t < 0.0 || t > 1.0 || result2.y >= start_y && result2.y <= end_y || result2.y <= start_y && result2.y >= end_y);
    }

    static final class KahanSummator {
        private double sum;
        private double compensation;
        private double startValue;

        KahanSummator(double startValue_) {
            this.startValue = startValue_;
            this.reset();
        }

        void reset() {
            this.sum = 0.0;
            this.compensation = 0.0;
        }

        void add(double v) {
            double y = v - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        void sub(double v) {
            this.add(-v);
        }

        void add(KahanSummator v) {
            double y = v.getResult() + v.compensation - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        void sub(KahanSummator v) {
            double y = -(v.getResult() - v.compensation) - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        double getResult() {
            return this.startValue + this.sum;
        }

        KahanSummator plusEquals(double v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(double v) {
            this.add(-v);
            return this;
        }

        KahanSummator plusEquals(KahanSummator v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(KahanSummator v) {
            this.sub(v);
            return this;
        }
    }
}

