/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.JsonWriter;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.StringUtils;

final class JsonStringWriter
extends JsonWriter {
    private StringBuilder m_jsonString = new StringBuilder();
    private AttributeStreamOfInt32 m_functionStack = new AttributeStreamOfInt32(0);

    @Override
    Object getJson() {
        this.next_(0);
        return this.m_jsonString.toString();
    }

    @Override
    void startObject() {
        this.next_(1);
        this.m_jsonString.append('{');
        this.m_functionStack.add(2);
    }

    @Override
    void startArray() {
        this.next_(1);
        this.m_jsonString.append('[');
        this.m_functionStack.add(3);
    }

    @Override
    void endObject() {
        this.next_(4);
        this.m_jsonString.append('}');
    }

    @Override
    void endArray() {
        this.next_(8);
        this.m_jsonString.append(']');
    }

    @Override
    void addPairObject(String fieldName) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueObject_();
    }

    @Override
    void addPairArray(String fieldName) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueArray_();
    }

    @Override
    void addPairString(String fieldName, String v) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueString_(v);
    }

    @Override
    void addPairDouble(String fieldName, double v) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueDouble_(v);
    }

    @Override
    void addPairDoubleF(String fieldName, double v, int decimals) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueDoubleF_(v, decimals);
    }

    @Override
    void addPairInt(String fieldName, int v) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueInt_(v);
    }

    @Override
    void addPairBoolean(String fieldName, boolean v) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueBoolean_(v);
    }

    @Override
    void addPairNull(String fieldName) {
        this.next_(16);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueNull_();
    }

    @Override
    void addValueObject() {
        this.next_(1);
        this.addValueObject_();
    }

    @Override
    void addValueArray() {
        this.next_(1);
        this.addValueArray_();
    }

    @Override
    void addValueString(String v) {
        this.next_(32);
        this.addValueString_(v);
    }

    @Override
    void addValueDouble(double v) {
        this.next_(32);
        this.addValueDouble_(v);
    }

    @Override
    void addValueDoubleF(double v, int decimals) {
        this.next_(32);
        this.addValueDoubleF_(v, decimals);
    }

    @Override
    void addValueInt(int v) {
        this.next_(32);
        this.addValueInt_(v);
    }

    @Override
    void addValueBoolean(boolean v) {
        this.next_(32);
        this.addValueBoolean_(v);
    }

    @Override
    void addValueNull() {
        this.next_(32);
        this.addValueNull_();
    }

    JsonStringWriter() {
        this.m_functionStack.add(0);
        this.m_functionStack.add(1);
    }

    private void addValueObject_() {
        this.m_jsonString.append('{');
        this.m_functionStack.add(2);
    }

    private void addValueArray_() {
        this.m_jsonString.append('[');
        this.m_functionStack.add(3);
    }

    private void addValueString_(String v) {
        this.appendQuote_(v);
    }

    private void addValueDouble_(double v) {
        if (NumberUtils.isNaN(v)) {
            this.addValueNull_();
            return;
        }
        StringUtils.appendDouble(v, 17, this.m_jsonString);
    }

    private void addValueDoubleF_(double v, int decimals) {
        if (NumberUtils.isNaN(v)) {
            this.addValueNull_();
            return;
        }
        StringUtils.appendDoubleF(v, decimals, this.m_jsonString);
    }

    private void addValueInt_(int v) {
        this.m_jsonString.append(v);
    }

    private void addValueBoolean_(boolean v) {
        if (v) {
            this.m_jsonString.append("true");
        } else {
            this.m_jsonString.append("false");
        }
    }

    private void addValueNull_() {
        this.m_jsonString.append("null");
    }

    private void next_(int action2) {
        switch (this.m_functionStack.getLast()) {
            case 0: {
                this.accept_(action2);
                break;
            }
            case 1: {
                this.start_(action2);
                break;
            }
            case 2: {
                this.objectStart_(action2);
                break;
            }
            case 3: {
                this.arrayStart_(action2);
                break;
            }
            case 4: {
                this.pairEnd_(action2);
                break;
            }
            case 6: {
                this.elementEnd_(action2);
                break;
            }
            default: {
                throw new GeometryException("internal error");
            }
        }
    }

    private void accept_(int action2) {
        if (action2 != 0) {
            throw new GeometryException("invalid call");
        }
    }

    private void start_(int action2) {
        if (action2 != 1) {
            throw new GeometryException("invalid call");
        }
        this.m_functionStack.removeLast();
    }

    private void objectStart_(int action2) {
        this.m_functionStack.removeLast();
        if (action2 == 16) {
            this.m_functionStack.add(4);
        } else if (action2 != 4) {
            throw new GeometryException("invalid call");
        }
    }

    private void pairEnd_(int action2) {
        if (action2 == 16) {
            this.m_jsonString.append(',');
        } else if (action2 == 4) {
            this.m_functionStack.removeLast();
        } else {
            throw new GeometryException("invalid call");
        }
    }

    private void arrayStart_(int action2) {
        this.m_functionStack.removeLast();
        if ((action2 & 0x21) != 0) {
            this.m_functionStack.add(6);
        } else if (action2 != 8) {
            throw new GeometryException("invalid call");
        }
    }

    private void elementEnd_(int action2) {
        if ((action2 & 0x21) != 0) {
            this.m_jsonString.append(',');
        } else if (action2 == 8) {
            this.m_functionStack.removeLast();
        } else {
            throw new GeometryException("invalid call");
        }
    }

    private void appendQuote_(String string2) {
        int count2 = 0;
        int start = 0;
        int end = string2.length();
        this.m_jsonString.append('\"');
        block10: for (int i = 0; i < end; ++i) {
            switch (string2.charAt(i)) {
                case '\"': {
                    if (count2 > 0) {
                        this.m_jsonString.append(string2, start, start + count2);
                        count2 = 0;
                    }
                    this.m_jsonString.append("\\\"");
                    start = i + 1;
                    continue block10;
                }
                case '\\': {
                    if (count2 > 0) {
                        this.m_jsonString.append(string2, start, start + count2);
                        count2 = 0;
                    }
                    this.m_jsonString.append("\\\\");
                    start = i + 1;
                    continue block10;
                }
                case '/': {
                    if (i > 0 && string2.charAt(i - 1) == '<') {
                        if (count2 > 0) {
                            this.m_jsonString.append(string2, start, start + count2);
                            count2 = 0;
                        }
                        this.m_jsonString.append("\\/");
                        start = i + 1;
                        continue block10;
                    }
                    ++count2;
                    continue block10;
                }
                case '\b': {
                    if (count2 > 0) {
                        this.m_jsonString.append(string2, start, start + count2);
                        count2 = 0;
                    }
                    this.m_jsonString.append("\\b");
                    start = i + 1;
                    continue block10;
                }
                case '\f': {
                    if (count2 > 0) {
                        this.m_jsonString.append(string2, start, start + count2);
                        count2 = 0;
                    }
                    this.m_jsonString.append("\\f");
                    start = i + 1;
                    continue block10;
                }
                case '\n': {
                    if (count2 > 0) {
                        this.m_jsonString.append(string2, start, start + count2);
                        count2 = 0;
                    }
                    this.m_jsonString.append("\\n");
                    start = i + 1;
                    continue block10;
                }
                case '\r': {
                    if (count2 > 0) {
                        this.m_jsonString.append(string2, start, start + count2);
                        count2 = 0;
                    }
                    this.m_jsonString.append("\\r");
                    start = i + 1;
                    continue block10;
                }
                case '\t': {
                    if (count2 > 0) {
                        this.m_jsonString.append(string2, start, start + count2);
                        count2 = 0;
                    }
                    this.m_jsonString.append("\\t");
                    start = i + 1;
                    continue block10;
                }
                default: {
                    ++count2;
                }
            }
        }
        if (count2 > 0) {
            this.m_jsonString.append(string2, start, start + count2);
        }
        this.m_jsonString.append('\"');
    }
}

