/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.NumberUtils;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonToken;

final class JSONUtils {
    JSONUtils() {
    }

    static boolean isObjectStart(JsonReader parser2) throws Exception {
        return parser2.currentToken() == null ? parser2.nextToken() == JsonToken.START_OBJECT : parser2.currentToken() == JsonToken.START_OBJECT;
    }

    static double readDouble(JsonReader parser2) throws JsonParseException, IOException, Exception {
        if (parser2.currentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            return parser2.currentDoubleValue();
        }
        if (parser2.currentToken() == JsonToken.VALUE_NUMBER_INT) {
            return parser2.currentIntValue();
        }
        if (parser2.currentToken() == JsonToken.VALUE_NULL) {
            return NumberUtils.NaN();
        }
        if (parser2.currentToken() == JsonToken.VALUE_STRING && parser2.currentString().equals("NaN")) {
            return NumberUtils.NaN();
        }
        throw new GeometryException("invalid parameter");
    }
}

