/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.StridedIndexTypeCollection;

class IndexMultiDCList {
    StridedIndexTypeCollection m_list_nodes = new StridedIndexTypeCollection(3);
    StridedIndexTypeCollection m_lists = new StridedIndexTypeCollection(6);
    int m_list_of_lists = IndexMultiDCList.nullNode();
    boolean m_b_store_list_index_with_node = false;

    void freeNode_(int node) {
        this.m_list_nodes.deleteElement(node);
    }

    int newNode_() {
        int node = this.m_list_nodes.newElement();
        return node;
    }

    void freeList_(int list2) {
        this.m_lists.deleteElement(list2);
    }

    int newList_() {
        int list2 = this.m_lists.newElement();
        return list2;
    }

    void setPrev_(int node, int prev) {
        this.m_list_nodes.setField(node, 1, prev);
    }

    void setNext_(int node, int next2) {
        this.m_list_nodes.setField(node, 2, next2);
    }

    void setData_(int node, int data2) {
        this.m_list_nodes.setField(node, 0, data2);
    }

    void setList_(int node, int list2) {
        this.m_list_nodes.setField(node, 3, list2);
    }

    void setListSize_(int list2, int newsize) {
        this.m_lists.setField(list2, 4, newsize);
    }

    void setNextList_(int list2, int next2) {
        this.m_lists.setField(list2, 3, next2);
    }

    void setPrevList_(int list2, int prev) {
        this.m_lists.setField(list2, 2, prev);
    }

    IndexMultiDCList() {
    }

    IndexMultiDCList(boolean b_store_list_index_with_node) {
    }

    int createList(int listData) {
        int list2 = this.newList_();
        this.m_lists.setField(list2, 3, this.m_list_of_lists);
        this.m_lists.setField(list2, 4, 0);
        this.m_lists.setField(list2, 5, listData);
        if (this.m_list_of_lists != IndexMultiDCList.nullNode()) {
            this.setPrevList_(this.m_list_of_lists, list2);
        }
        this.m_list_of_lists = list2;
        return list2;
    }

    int deleteList(int list2) {
        this.clear(list2);
        int prevList = this.m_lists.getField(list2, 2);
        int nextList = this.m_lists.getField(list2, 3);
        if (prevList != IndexMultiDCList.nullNode()) {
            this.setNextList_(prevList, nextList);
        } else {
            this.m_list_of_lists = nextList;
        }
        if (nextList != IndexMultiDCList.nullNode()) {
            this.setPrevList_(nextList, prevList);
        }
        this.freeList_(list2);
        return nextList;
    }

    void reserveLists(int listCount) {
        this.m_lists.setCapacity(listCount);
    }

    int getListData(int list2) {
        return this.m_lists.getField(list2, 5);
    }

    int getList(int node_index) {
        assert (this.m_b_store_list_index_with_node);
        return this.m_list_nodes.getField(node_index, 3);
    }

    void setListData(int list2, int data2) {
        this.m_lists.setField(list2, 5, data2);
    }

    int addElement(int list2, int data2) {
        return this.insertElement(list2, -1, data2);
    }

    int insertElement(int list2, int beforeNode, int data2) {
        int head2;
        int node = this.newNode_();
        int prev = -1;
        if (beforeNode != IndexMultiDCList.nullNode()) {
            prev = this.getPrev(beforeNode);
            this.setPrev_(beforeNode, node);
        }
        this.setNext_(node, beforeNode);
        if (prev != IndexMultiDCList.nullNode()) {
            this.setNext_(prev, node);
        }
        if (beforeNode == (head2 = this.m_lists.getField(list2, 0))) {
            this.m_lists.setField(list2, 0, node);
        }
        if (beforeNode == IndexMultiDCList.nullNode()) {
            int tail = this.m_lists.getField(list2, 1);
            this.setPrev_(node, tail);
            if (tail != -1) {
                this.setNext_(tail, node);
            }
            this.m_lists.setField(list2, 1, node);
        }
        this.setData(node, data2);
        this.setListSize_(list2, this.getListSize(list2) + 1);
        if (this.m_b_store_list_index_with_node) {
            this.setList_(node, list2);
        }
        return node;
    }

    int deleteElement(int list2, int node) {
        int prev = this.getPrev(node);
        int next2 = this.getNext(node);
        if (prev != IndexMultiDCList.nullNode()) {
            this.setNext_(prev, next2);
        } else {
            this.m_lists.setField(list2, 0, next2);
        }
        if (next2 != IndexMultiDCList.nullNode()) {
            this.setPrev_(next2, prev);
        } else {
            this.m_lists.setField(list2, 1, prev);
        }
        this.freeNode_(node);
        this.setListSize_(list2, this.getListSize(list2) - 1);
        return next2;
    }

    void reserveNodes(int nodeCount) {
        this.m_list_nodes.setCapacity(nodeCount);
    }

    int getData(int node_index) {
        return this.m_list_nodes.getField(node_index, 0);
    }

    void setData(int node_index, int element) {
        this.m_list_nodes.setField(node_index, 0, element);
    }

    int getNext(int node_index) {
        return this.m_list_nodes.getField(node_index, 2);
    }

    int getPrev(int node_index) {
        return this.m_list_nodes.getField(node_index, 1);
    }

    int getFirst(int list2) {
        return this.m_lists.getField(list2, 0);
    }

    int getLast(int list2) {
        return this.m_lists.getField(list2, 1);
    }

    static int nullNode() {
        return -1;
    }

    void clear() {
        int list2 = this.getFirstList();
        while (list2 != -1) {
            list2 = this.deleteList(list2);
        }
    }

    void clear(int list2) {
        int last2 = this.getLast(list2);
        while (last2 != IndexMultiDCList.nullNode()) {
            int n = last2;
            last2 = this.getPrev(n);
            this.freeNode_(n);
        }
        this.m_lists.setField(list2, 0, -1);
        this.m_lists.setField(list2, 1, -1);
        this.setListSize_(list2, 0);
    }

    boolean isEmpty(int list2) {
        return this.m_lists.getField(list2, 0) == -1;
    }

    boolean isEmpty() {
        return this.m_list_nodes.size() == 0;
    }

    int getNodeCount() {
        return this.m_list_nodes.size();
    }

    int getListCount() {
        return this.m_lists.size();
    }

    int getListSize(int list2) {
        return this.m_lists.getField(list2, 4);
    }

    int getFirstList() {
        return this.m_list_of_lists;
    }

    int getNextList(int list2) {
        return this.m_lists.getField(list2, 3);
    }
}

