/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.ConvexHull;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorGeneralize;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.TopologicalOperations;
import com.esri.core.geometry.Transformation2D;
import java.util.ArrayList;

class Bufferer {
    private Geometry m_geometry;
    private ArrayList<BufferCommand> m_buffer_commands = new ArrayList(0);
    private int m_original_geom_type;
    private ProgressTracker m_progress_tracker;
    private int m_max_vertex_in_complete_circle;
    private SpatialReference m_spatialReference;
    private double m_tolerance;
    private double m_small_tolerance;
    private double m_filter_tolerance;
    private double m_densify_dist;
    private double m_distance;
    private double m_abs_distance;
    private double m_abs_distance_reversed;
    private double m_dA;
    private boolean m_b_output_loops;
    private boolean m_bfilter;
    private ArrayList<Point2D> m_circle_template;
    private ArrayList<Point2D> m_left_stack;
    private ArrayList<Point2D> m_middle_stack;
    private Line m_helper_line_1;
    private Line m_helper_line_2;
    private Point2D[] m_helper_array;
    private int m_progress_counter;

    static Geometry buffer(Geometry geometry, double distance, SpatialReference sr, double densify_dist, int max_vertex_in_complete_circle, ProgressTracker progress_tracker) {
        double max_dd;
        if (geometry == null) {
            throw new IllegalArgumentException();
        }
        if (densify_dist < 0.0) {
            throw new IllegalArgumentException();
        }
        if (geometry.isEmpty()) {
            return new Polygon(geometry.getDescription());
        }
        Envelope2D env2D = new Envelope2D();
        geometry.queryLooseEnvelope2D(env2D);
        if (distance > 0.0) {
            env2D.inflate(distance, distance);
        }
        Bufferer bufferer = new Bufferer(progress_tracker);
        bufferer.m_spatialReference = sr;
        bufferer.m_geometry = geometry;
        bufferer.m_tolerance = InternalUtils.calculateToleranceFromGeometry(sr, env2D, true);
        bufferer.m_small_tolerance = InternalUtils.calculateToleranceFromGeometry(null, env2D, true);
        bufferer.m_distance = distance;
        bufferer.m_original_geom_type = geometry.getType().value();
        if (max_vertex_in_complete_circle <= 0) {
            max_vertex_in_complete_circle = 96;
        }
        bufferer.m_abs_distance = Math.abs(bufferer.m_distance);
        double d = bufferer.m_abs_distance_reversed = bufferer.m_abs_distance != 0.0 ? 1.0 / bufferer.m_abs_distance : 0.0;
        if (NumberUtils.isNaN(densify_dist) || densify_dist == 0.0) {
            densify_dist = bufferer.m_abs_distance * 1.0E-5;
        } else if (densify_dist > bufferer.m_abs_distance * 0.5) {
            densify_dist = bufferer.m_abs_distance * 0.5;
        }
        if (max_vertex_in_complete_circle < 12) {
            max_vertex_in_complete_circle = 12;
        }
        if ((max_dd = Math.abs(distance) * (1.0 - Math.cos(Math.PI / (double)max_vertex_in_complete_circle))) > densify_dist) {
            densify_dist = max_dd;
        } else {
            double vertex_count = Math.PI / Math.acos(1.0 - densify_dist / Math.abs(distance));
            if (vertex_count < (double)max_vertex_in_complete_circle - 1.0 && (max_vertex_in_complete_circle = (int)vertex_count) < 12) {
                max_vertex_in_complete_circle = 12;
                densify_dist = Math.abs(distance) * (1.0 - Math.cos(Math.PI / (double)max_vertex_in_complete_circle));
            }
        }
        bufferer.m_densify_dist = densify_dist;
        bufferer.m_max_vertex_in_complete_circle = max_vertex_in_complete_circle;
        bufferer.m_filter_tolerance = Math.min(bufferer.m_small_tolerance, densify_dist * 0.25);
        return bufferer.buffer_();
    }

    private void generateCircleTemplate_() {
        double dA;
        if (this.m_circle_template == null) {
            this.m_circle_template = new ArrayList(0);
        } else if (!this.m_circle_template.isEmpty()) {
            return;
        }
        int N = this.calcN_(4);
        assert (N >= 4);
        int real_size = (N + 3) / 4;
        this.m_dA = dA = 1.5707963267948966 / (double)real_size;
        for (int i = 0; i < real_size * 4; ++i) {
            this.m_circle_template.add(null);
        }
        double dcos = Math.cos(dA);
        double dsin = Math.sin(dA);
        Point2D pt = new Point2D(0.0, 1.0);
        for (int i = 0; i < real_size; ++i) {
            this.m_circle_template.set(i + real_size * 0, new Point2D(pt.y, -pt.x));
            this.m_circle_template.set(i + real_size * 1, new Point2D(-pt.x, -pt.y));
            this.m_circle_template.set(i + real_size * 2, new Point2D(-pt.y, pt.x));
            this.m_circle_template.set(i + real_size * 3, pt);
            pt = new Point2D(pt.x, pt.y);
            pt.rotateReverse(dcos, dsin);
        }
    }

    private Bufferer(ProgressTracker progress_tracker) {
        this.m_progress_tracker = progress_tracker;
        this.m_tolerance = 0.0;
        this.m_small_tolerance = 0.0;
        this.m_filter_tolerance = 0.0;
        this.m_distance = 0.0;
        this.m_original_geom_type = 0;
        this.m_abs_distance_reversed = 0.0;
        this.m_abs_distance = 0.0;
        this.m_densify_dist = -1.0;
        this.m_dA = -1.0;
        this.m_b_output_loops = true;
        this.m_bfilter = true;
    }

    private Geometry buffer_() {
        int gt = this.m_geometry.getType().value();
        if (Geometry.isSegment(gt)) {
            Polyline polyline = new Polyline(this.m_geometry.getDescription());
            polyline.addSegment((Segment)this.m_geometry, true);
            this.m_geometry = polyline;
            return this.buffer_();
        }
        if (this.m_distance <= this.m_tolerance) {
            if (Geometry.isArea(gt)) {
                if (this.m_distance <= 0.0) {
                    Envelope2D env = new Envelope2D();
                    this.m_geometry.queryEnvelope2D(env);
                    if (env.getWidth() <= -this.m_distance * 2.0 || env.getHeight() <= this.m_distance * 2.0) {
                        return new Polygon(this.m_geometry.getDescription());
                    }
                }
            } else {
                return new Polygon(this.m_geometry.getDescription());
            }
        }
        switch (this.m_geometry.getType().value()) {
            case 33: {
                return this.bufferPoint_();
            }
            case 550: {
                return this.bufferMultiPoint_();
            }
            case 1607: {
                return this.bufferPolyline_();
            }
            case 1736: {
                return this.bufferPolygon_();
            }
            case 197: {
                return this.bufferEnvelope_();
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    private Geometry bufferPolyline_() {
        if (this.isDegenerateGeometry_(this.m_geometry)) {
            Point point = new Point();
            ((MultiVertexGeometry)this.m_geometry).getPointByVal(0, point);
            Envelope2D env2D = new Envelope2D();
            this.m_geometry.queryEnvelope2D(env2D);
            point.setXY(env2D.getCenter());
            return this.bufferPoint_(point);
        }
        assert (this.m_distance > 0.0);
        this.m_geometry = this.preparePolyline_((Polyline)this.m_geometry);
        GeometryCursorForPolyline cursor = new GeometryCursorForPolyline(this, this.m_bfilter);
        GeometryCursor union_cursor = ((OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union)).execute(cursor, this.m_spatialReference, this.m_progress_tracker);
        Geometry result2 = union_cursor.next();
        return result2;
    }

    private Geometry bufferPolygon_() {
        if (this.m_distance == 0.0) {
            return this.m_geometry;
        }
        OperatorSimplify simplify = (OperatorSimplify)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Simplify);
        this.generateCircleTemplate_();
        this.m_geometry = simplify.execute(this.m_geometry, null, false, this.m_progress_tracker);
        if (this.m_distance < 0.0) {
            Polygon poly = (Polygon)this.m_geometry;
            Polygon buffered_result = this.bufferPolygonImpl_(poly, 0, poly.getPathCount());
            return simplify.execute(buffered_result, this.m_spatialReference, false, this.m_progress_tracker);
        }
        if (this.isDegenerateGeometry_(this.m_geometry)) {
            Point point = new Point();
            ((MultiVertexGeometry)this.m_geometry).getPointByVal(0, point);
            Envelope2D env2D = new Envelope2D();
            this.m_geometry.queryEnvelope2D(env2D);
            point.setXY(env2D.getCenter());
            return this.bufferPoint_(point);
        }
        GeometryCursorForPolygon cursor = new GeometryCursorForPolygon(this);
        GeometryCursor union_cursor = ((OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union)).execute(cursor, this.m_spatialReference, this.m_progress_tracker);
        Geometry result2 = union_cursor.next();
        return result2;
    }

    private Polygon bufferPolygonImpl_(Polygon input_geom, int ipath_begin, int ipath_end) {
        Polygon input_mp = input_geom;
        MultiPathImpl mp_impl = (MultiPathImpl)input_mp._getImpl();
        Polygon intermediate_polygon = new Polygon(input_geom.getDescription());
        for (int ipath = ipath_begin; ipath < ipath_end; ++ipath) {
            int i;
            MultiPathImpl result_mp;
            Polyline result_polyline;
            if (mp_impl.getPathSize(ipath) < 1) continue;
            double path_area = mp_impl.calculateRingArea2D(ipath);
            Envelope2D env2D = new Envelope2D();
            mp_impl.queryPathEnvelope2D(ipath, env2D);
            if (this.m_distance > 0.0) {
                if (path_area > 0.0) {
                    Polygon buffered_path;
                    if (this.isDegeneratePath_(mp_impl, ipath)) {
                        Point point = new Point();
                        mp_impl.getPointByVal(mp_impl.getPathStart(ipath), point);
                        point.setXY(env2D.getCenter());
                        this.addCircle_((MultiPathImpl)intermediate_polygon._getImpl(), point);
                        continue;
                    }
                    result_polyline = new Polyline(input_geom.getDescription());
                    result_mp = (MultiPathImpl)result_polyline._getImpl();
                    boolean bConvex = ConvexHull.isPathConvex((Polygon)this.m_geometry, ipath, this.m_progress_tracker);
                    if (bConvex || this.bufferClosedPath_(this.m_geometry, ipath, result_mp, true, 1) == 2) {
                        buffered_path = this.bufferConvexPath_(input_mp, ipath);
                        intermediate_polygon.add(buffered_path, false);
                        continue;
                    }
                    buffered_path = this.bufferCleanup_(result_polyline, false);
                    intermediate_polygon.add(buffered_path, false);
                    continue;
                }
                if (env2D.getWidth() + this.m_tolerance <= 2.0 * this.m_abs_distance || env2D.getHeight() + this.m_tolerance <= 2.0 * this.m_abs_distance) continue;
                result_polyline = new Polyline(input_geom.getDescription());
                result_mp = (MultiPathImpl)result_polyline._getImpl();
                this.bufferClosedPath_(this.m_geometry, ipath, result_mp, true, 1);
                if (result_polyline.isEmpty()) continue;
                Envelope2D env = new Envelope2D();
                env.setCoords(env2D);
                env.inflate(this.m_abs_distance, this.m_abs_distance);
                result_mp.addEnvelope(env, false);
                Polygon buffered_path = this.bufferCleanup_(result_polyline, false);
                int n = buffered_path.getPathCount();
                for (i = 1; i < n; ++i) {
                    intermediate_polygon.addPath(buffered_path, i, true);
                }
                continue;
            }
            if (path_area > 0.0) {
                if (env2D.getWidth() + this.m_tolerance <= 2.0 * this.m_abs_distance || env2D.getHeight() + this.m_tolerance <= 2.0 * this.m_abs_distance) continue;
                result_polyline = new Polyline(input_geom.getDescription());
                result_mp = (MultiPathImpl)result_polyline._getImpl();
                this.bufferClosedPath_(this.m_geometry, ipath, result_mp, true, -1);
                if (result_polyline.isEmpty()) continue;
                Envelope2D env = new Envelope2D();
                result_mp.queryLooseEnvelope2D(env);
                env.inflate(this.m_abs_distance, this.m_abs_distance);
                result_mp.addEnvelope(env, false);
                Polygon buffered_path = this.bufferCleanup_(result_polyline, false);
                int npaths = buffered_path.getPathCount();
                for (i = 1; i < npaths; ++i) {
                    intermediate_polygon.addPath(buffered_path, i, true);
                }
                continue;
            }
            result_polyline = new Polyline(input_geom.getDescription());
            result_mp = (MultiPathImpl)result_polyline._getImpl();
            this.bufferClosedPath_(this.m_geometry, ipath, result_mp, true, -1);
            Polygon buffered_path = this.bufferCleanup_(result_polyline, false);
            int npaths = buffered_path.getPathCount();
            for (int i2 = 0; i2 < npaths; ++i2) {
                intermediate_polygon.addPath(buffered_path, i2, true);
            }
        }
        if (this.m_distance > 0.0) {
            if (intermediate_polygon.getPathCount() > 1) {
                Polygon cleaned_polygon = this.bufferCleanup_(intermediate_polygon, false);
                return cleaned_polygon;
            }
            return Bufferer.setWeakSimple_(intermediate_polygon);
        }
        Envelope2D polyenv = new Envelope2D();
        intermediate_polygon.queryLooseEnvelope2D(polyenv);
        if (!intermediate_polygon.isEmpty()) {
            polyenv.inflate(this.m_abs_distance, this.m_abs_distance);
            intermediate_polygon.addEnvelope(polyenv, false);
            Polygon cleaned_polygon = this.bufferCleanup_(intermediate_polygon, false);
            Polygon result_polygon = new Polygon(cleaned_polygon.getDescription());
            int n = cleaned_polygon.getPathCount();
            for (int i = 1; i < n; ++i) {
                result_polygon.addPath(cleaned_polygon, i, false);
            }
            return Bufferer.setWeakSimple_(result_polygon);
        }
        return Bufferer.setWeakSimple_(intermediate_polygon);
    }

    private Geometry bufferPoint_() {
        return this.bufferPoint_((Point)this.m_geometry);
    }

    private Geometry bufferPoint_(Point point) {
        assert (this.m_distance > 0.0);
        Polygon resultPolygon = new Polygon(this.m_geometry.getDescription());
        this.addCircle_((MultiPathImpl)resultPolygon._getImpl(), point);
        return this.setStrongSimple_(resultPolygon);
    }

    private Geometry bufferMultiPoint_() {
        assert (this.m_distance > 0.0);
        GeometryCursorForMultiPoint mpCursor = new GeometryCursorForMultiPoint((MultiPoint)this.m_geometry, this.m_distance, this.m_spatialReference, this.m_densify_dist, this.m_max_vertex_in_complete_circle, this.m_progress_tracker);
        GeometryCursor c = ((OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union)).execute(mpCursor, this.m_spatialReference, this.m_progress_tracker);
        return c.next();
    }

    private Geometry bufferEnvelope_() {
        Polygon polygon = new Polygon(this.m_geometry.getDescription());
        if (this.m_distance <= 0.0) {
            if (this.m_distance == 0.0) {
                polygon.addEnvelope((Envelope)this.m_geometry, false);
            } else {
                Envelope env = new Envelope();
                this.m_geometry.queryEnvelope(env);
                env.inflate(this.m_distance, this.m_distance);
                polygon.addEnvelope(env, false);
            }
            return polygon;
        }
        polygon.addEnvelope((Envelope)this.m_geometry, false);
        this.m_geometry = polygon;
        return this.bufferConvexPath_(polygon, 0);
    }

    private Polygon bufferConvexPath_(MultiPath src, int ipath) {
        this.generateCircleTemplate_();
        Polygon resultPolygon = new Polygon(src.getDescription());
        MultiPathImpl result_mp = (MultiPathImpl)resultPolygon._getImpl();
        Point2D pt_1_tmp = new Point2D();
        Point2D pt_1 = new Point2D();
        Point2D pt_2_tmp = new Point2D();
        Point2D pt_2 = new Point2D();
        Point2D pt_3_tmp = new Point2D();
        Point2D pt_3 = new Point2D();
        Point2D v_1 = new Point2D();
        Point2D v_2 = new Point2D();
        MultiPathImpl src_mp = (MultiPathImpl)src._getImpl();
        int path_size = src.getPathSize(ipath);
        int path_start = src.getPathStart(ipath);
        int n = src.getPathSize(ipath);
        for (int i = 0; i < n; ++i) {
            src_mp.getXY(path_start + i, pt_1);
            src_mp.getXY(path_start + (i + 1) % path_size, pt_2);
            src_mp.getXY(path_start + (i + 2) % path_size, pt_3);
            v_1.sub(pt_2, pt_1);
            if (v_1.length() == 0.0) {
                throw GeometryException.GeometryInternalError();
            }
            v_1.leftPerpendicular();
            v_1.normalize();
            v_1.scale(this.m_abs_distance);
            pt_1_tmp.add(v_1, pt_1);
            pt_2_tmp.add(v_1, pt_2);
            if (i == 0) {
                result_mp.startPath(pt_1_tmp);
            } else {
                result_mp.lineTo(pt_1_tmp);
            }
            result_mp.lineTo(pt_2_tmp);
            v_2.sub(pt_3, pt_2);
            if (v_2.length() == 0.0) {
                throw GeometryException.GeometryInternalError();
            }
            v_2.leftPerpendicular();
            v_2.normalize();
            v_2.scale(this.m_abs_distance);
            pt_3_tmp.add(v_2, pt_2);
            this.addJoin_(result_mp, pt_2, pt_2_tmp, pt_3_tmp, false, false);
        }
        return Bufferer.setWeakSimple_(resultPolygon);
    }

    private Polygon bufferPolylinePath_(Polyline polyline, int ipath, boolean bfilter) {
        assert (this.m_distance != 0.0);
        this.generateCircleTemplate_();
        Polyline input_multi_path = polyline;
        MultiPathImpl mp_impl = (MultiPathImpl)input_multi_path._getImpl();
        if (mp_impl.getPathSize(ipath) < 1) {
            return null;
        }
        if (this.isDegeneratePath_(mp_impl, ipath) && this.m_distance > 0.0) {
            Point point = new Point();
            mp_impl.getPointByVal(mp_impl.getPathStart(ipath), point);
            Envelope2D env2D = new Envelope2D();
            mp_impl.queryPathEnvelope2D(ipath, env2D);
            point.setXY(env2D.getCenter());
            return (Polygon)this.bufferPoint_(point);
        }
        Polyline result_polyline = new Polyline(polyline.getDescription());
        MultiPathImpl result_mp = (MultiPathImpl)result_polyline._getImpl();
        boolean b_closed = mp_impl.isClosedPathInXYPlane(ipath);
        if (b_closed) {
            this.bufferClosedPath_(input_multi_path, ipath, result_mp, bfilter, 1);
            this.bufferClosedPath_(input_multi_path, ipath, result_mp, bfilter, -1);
        } else {
            Polyline tmpPoly = new Polyline(input_multi_path.getDescription());
            tmpPoly.addPath(input_multi_path, ipath, false);
            ((MultiPathImpl)tmpPoly._getImpl()).addSegmentsFromPath((MultiPathImpl)input_multi_path._getImpl(), ipath, 0, input_multi_path.getSegmentCount(ipath), false);
            this.bufferClosedPath_(tmpPoly, 0, result_mp, bfilter, 1);
        }
        return this.bufferCleanup_(result_polyline, false);
    }

    private void progress_() {
        ++this.m_progress_counter;
        if (this.m_progress_counter % 1024 == 0 && this.m_progress_tracker != null && !this.m_progress_tracker.progress(-1, -1)) {
            throw new RuntimeException("user_canceled");
        }
    }

    private Polygon bufferCleanup_(MultiPath multi_path, boolean simplify_result) {
        double tol = simplify_result ? this.m_tolerance : this.m_small_tolerance;
        Polygon resultPolygon = (Polygon)TopologicalOperations.planarSimplify(multi_path, tol, true, !simplify_result, this.m_progress_tracker);
        assert (InternalUtils.isWeakSimple(resultPolygon, 0.0));
        return resultPolygon;
    }

    private int calcN_(int minN) {
        if (this.m_densify_dist == 0.0) {
            return this.m_max_vertex_in_complete_circle;
        }
        double r = this.m_densify_dist * Math.abs(this.m_abs_distance_reversed);
        double cos_a = 1.0 - r;
        double N = cos_a < -1.0 ? (double)minN : Math.PI * 2 / Math.acos(cos_a) + 0.5;
        if (N < (double)minN) {
            N = minN;
        } else if (N > (double)this.m_max_vertex_in_complete_circle) {
            N = this.m_max_vertex_in_complete_circle;
        }
        return (int)N;
    }

    private void addJoin_(MultiPathImpl dst, Point2D center, Point2D fromPt, Point2D toPt, boolean bStartPath, boolean bFinishAtToPt) {
        this.generateCircleTemplate_();
        Point2D v_1 = new Point2D();
        v_1.sub(fromPt, center);
        v_1.scale(this.m_abs_distance_reversed);
        Point2D v_2 = new Point2D();
        v_2.sub(toPt, center);
        v_2.scale(this.m_abs_distance_reversed);
        double angle_from = Math.atan2(v_1.y, v_1.x);
        double dindex_from = angle_from / this.m_dA;
        if (dindex_from < 0.0) {
            dindex_from = (double)this.m_circle_template.size() + dindex_from;
        }
        dindex_from = (double)this.m_circle_template.size() - dindex_from;
        double angle_to = Math.atan2(v_2.y, v_2.x);
        double dindex_to = angle_to / this.m_dA;
        if (dindex_to < 0.0) {
            dindex_to = (double)this.m_circle_template.size() + dindex_to;
        }
        if ((dindex_to = (double)this.m_circle_template.size() - dindex_to) < dindex_from) {
            dindex_to += (double)this.m_circle_template.size();
        }
        assert (dindex_to >= dindex_from);
        int index_to = (int)dindex_to;
        int index_from = (int)Math.ceil(dindex_from);
        if (bStartPath) {
            dst.startPath(fromPt);
            bStartPath = false;
        }
        Point2D p = new Point2D();
        p.setCoords(this.m_circle_template.get(index_from % this.m_circle_template.size()));
        p.scaleAdd(this.m_abs_distance, center);
        double ddd = this.m_tolerance * 10.0;
        p.sub(fromPt);
        if (p.length() < ddd) {
            ++index_from;
        }
        p.setCoords(this.m_circle_template.get(index_to % this.m_circle_template.size()));
        p.scaleAdd(this.m_abs_distance, center);
        p.sub(toPt);
        if (p.length() < ddd) {
            --index_to;
        }
        int count2 = index_to - index_from;
        ++count2;
        int j = index_from % this.m_circle_template.size();
        for (int i = 0; i < count2; ++i) {
            p.setCoords(this.m_circle_template.get(j));
            p.scaleAdd(this.m_abs_distance, center);
            dst.lineTo(p);
            this.progress_();
            j = (j + 1) % this.m_circle_template.size();
        }
        if (bFinishAtToPt) {
            dst.lineTo(toPt);
        }
    }

    private int bufferClosedPath_(Geometry input_geom, int ipath, MultiPathImpl result_mp, boolean bfilter, int dir) {
        EditShape edit_shape = new EditShape();
        int geom = edit_shape.addPathFromMultiPath((MultiPath)input_geom, ipath, true);
        edit_shape.filterClosePoints(this.m_filter_tolerance, false, false);
        if (edit_shape.getPointCount(geom) < 2) {
            if (dir < 0) {
                return 1;
            }
            MultiPath mpIn = (MultiPath)input_geom;
            Point pt = new Point();
            mpIn.getPointByVal(mpIn.getPathStart(ipath), pt);
            this.addCircle_(result_mp, pt);
            return 1;
        }
        assert (edit_shape.getFirstPath(geom) != -1);
        assert (edit_shape.getFirstVertex(edit_shape.getFirstPath(geom)) != -1);
        Point2D origin2 = edit_shape.getXY(edit_shape.getFirstVertex(edit_shape.getFirstPath(geom)));
        Transformation2D tr = new Transformation2D();
        tr.setShift(-origin2.x, -origin2.y);
        edit_shape.applyTransformation(tr);
        if (bfilter) {
            int res_filter = this.filterPath_(edit_shape, geom, dir, true);
            assert (res_filter == 1);
            if (edit_shape.getPointCount(geom) < 2) {
                if (dir < 0) {
                    return 1;
                }
                MultiPath mpIn = (MultiPath)input_geom;
                Point pt = new Point();
                mpIn.getPointByVal(mpIn.getPathStart(ipath), pt);
                this.addCircle_(result_mp, pt);
                return 1;
            }
        }
        this.m_buffer_commands.clear();
        int path = edit_shape.getFirstPath(geom);
        int ivert = edit_shape.getFirstVertex(path);
        int iprev = dir == 1 ? edit_shape.getPrevVertex(ivert) : edit_shape.getNextVertex(ivert);
        int inext = dir == 1 ? edit_shape.getNextVertex(ivert) : edit_shape.getPrevVertex(ivert);
        boolean b_first = true;
        Point2D pt_current = new Point2D();
        Point2D pt_after = new Point2D();
        Point2D pt_before = new Point2D();
        Point2D pt_left_prev = new Point2D();
        Point2D pt = new Point2D();
        Point2D pt1 = new Point2D();
        Point2D v_after = new Point2D();
        Point2D v_before = new Point2D();
        Point2D v_left = new Point2D();
        Point2D v_left_prev = new Point2D();
        double abs_d = this.m_abs_distance;
        int ncount = edit_shape.getPathSize(path);
        for (int index2 = 0; index2 < ncount; ++index2) {
            boolean bDoJoin;
            edit_shape.getXY(inext, pt_after);
            if (b_first) {
                edit_shape.getXY(ivert, pt_current);
                edit_shape.getXY(iprev, pt_before);
                v_before.sub(pt_current, pt_before);
                v_before.normalize();
                v_left_prev.leftPerpendicular(v_before);
                v_left_prev.scale(abs_d);
                pt_left_prev.add(v_left_prev, pt_current);
            }
            v_after.sub(pt_after, pt_current);
            v_after.normalize();
            v_left.leftPerpendicular(v_after);
            v_left.scale(abs_d);
            pt.add(pt_current, v_left);
            double cross = v_before.crossProduct(v_after);
            double dot = v_before.dotProduct(v_after);
            boolean bl = bDoJoin = cross < 0.0 || dot < 0.0 && cross == 0.0;
            if (bDoJoin) {
                this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt, pt_current, 2, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
            } else if (!pt_left_prev.isEqual(pt)) {
                this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt_current, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1, "dummy"));
                this.m_buffer_commands.add(new BufferCommand(pt_current, pt, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1, "dummy"));
            }
            pt1.add(pt_after, v_left);
            this.m_buffer_commands.add(new BufferCommand(pt, pt1, pt_current, 1, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
            pt_left_prev.setCoords(pt1);
            v_left_prev.setCoords(v_left);
            pt_before.setCoords(pt_current);
            pt_current.setCoords(pt_after);
            v_before.setCoords(v_after);
            iprev = ivert;
            ivert = inext;
            b_first = false;
            inext = dir == 1 ? edit_shape.getNextVertex(ivert) : edit_shape.getPrevVertex(ivert);
        }
        this.m_buffer_commands.get(this.m_buffer_commands.size() - 1).m_next = 0;
        this.m_buffer_commands.get(0).m_prev = this.m_buffer_commands.size() - 1;
        this.processBufferCommands_(result_mp);
        tr.setShift(origin2.x, origin2.y);
        result_mp.applyTransformation(tr, result_mp.getPathCount() - 1);
        return 1;
    }

    private void processBufferCommands_(MultiPathImpl result_mp) {
        int ifirst_seg = this.cleanupBufferCommands_();
        boolean first = true;
        int iseg_next = ifirst_seg + 1;
        int iseg = ifirst_seg;
        while (iseg_next != ifirst_seg) {
            BufferCommand command2 = this.m_buffer_commands.get(iseg);
            int n = iseg_next = command2.m_next != -1 ? command2.m_next : (iseg + 1) % this.m_buffer_commands.size();
            if (command2.m_type != 0) {
                if (first) {
                    result_mp.startPath(command2.m_from);
                    first = false;
                }
                if (command2.m_type == 2) {
                    this.addJoin_(result_mp, command2.m_center, command2.m_from, command2.m_to, false, true);
                } else {
                    result_mp.lineTo(command2.m_to);
                }
                first = false;
            }
            iseg = iseg_next;
        }
    }

    private int cleanupBufferCommands_() {
        BufferCommand command2;
        if (this.m_helper_array == null) {
            this.m_helper_array = new Point2D[9];
        }
        int istart = 0;
        int iseg = 0;
        int nseg = this.m_buffer_commands.size();
        while (iseg < nseg) {
            command2 = this.m_buffer_commands.get(iseg);
            if ((command2.m_type & 3) != 0) {
                istart = iseg;
                break;
            }
            iseg = command2.m_next;
        }
        int iseg_next = istart + 1;
        int iseg2 = istart;
        while (iseg_next != istart) {
            command2 = this.m_buffer_commands.get(iseg2);
            iseg_next = command2.m_next;
            int count2 = 1;
            BufferCommand command_next = null;
            while (iseg_next != iseg2 && ((command_next = this.m_buffer_commands.get(iseg_next)).m_type & 3) == 0) {
                iseg_next = command_next.m_next;
                ++count2;
            }
            if (count2 == 1) {
                assert (command2.m_to.isEqual(command_next.m_from));
            } else if ((command2.m_type & command_next.m_type) == 1) {
                if (this.m_helper_line_1 == null) {
                    this.m_helper_line_1 = new Line();
                    this.m_helper_line_2 = new Line();
                }
                this.m_helper_line_1.setStartXY(command2.m_from);
                this.m_helper_line_1.setEndXY(command2.m_to);
                this.m_helper_line_2.setStartXY(command_next.m_from);
                this.m_helper_line_2.setEndXY(command_next.m_to);
                int count_ = this.m_helper_line_1.intersect(this.m_helper_line_2, this.m_helper_array, null, null, this.m_small_tolerance);
                if (count_ == 1) {
                    command2.m_to.setCoords(this.m_helper_array[0]);
                    command_next.m_from.setCoords(this.m_helper_array[0]);
                    command2.m_next = iseg_next;
                    command_next.m_prev = iseg2;
                } else if (count_ == 2) {
                    // empty if block
                }
            }
            iseg2 = iseg_next;
        }
        return istart;
    }

    private boolean isGap_(Point2D pt_before, Point2D pt_current, Point2D pt_after) {
        Point2D v_gap = new Point2D();
        v_gap.sub(pt_after, pt_before);
        double gap_length = v_gap.length();
        double sqr_delta = this.m_abs_distance * this.m_abs_distance - gap_length * gap_length * 0.25;
        if (sqr_delta > 0.0) {
            double delta = Math.sqrt(sqr_delta);
            v_gap.normalize();
            v_gap.rightPerpendicular();
            Point2D p = new Point2D();
            p.sub(pt_current, pt_before);
            double d = p.dotProduct(v_gap);
            if (d + delta >= this.m_abs_distance) {
                return true;
            }
        }
        return false;
    }

    private int filterPath_(EditShape edit_shape, int geom, int dir, boolean closed) {
        boolean bConvex = true;
        for (int pass = 0; pass < 1; ++pass) {
            boolean b_filtered = false;
            int ipath = edit_shape.getFirstPath(geom);
            int isize = edit_shape.getPathSize(ipath);
            if (isize == 0) {
                return 0;
            }
            int ncount = isize;
            if (isize < 3) {
                return 1;
            }
            if (closed && !edit_shape.isClosedPath(ipath)) {
                ncount = isize - 1;
            }
            assert (dir == 1 || dir == -1);
            int ivert = edit_shape.getFirstVertex(ipath);
            if (!closed) {
                edit_shape.getNextVertex(ivert);
            }
            int iprev = dir > 0 ? edit_shape.getPrevVertex(ivert) : edit_shape.getNextVertex(ivert);
            int inext = dir > 0 ? edit_shape.getNextVertex(ivert) : edit_shape.getPrevVertex(ivert);
            int ibefore = iprev;
            boolean reload2 = true;
            Point2D pt_current = new Point2D();
            Point2D pt_after = new Point2D();
            Point2D pt_before = new Point2D();
            Point2D pt_before_before = new Point2D();
            Point2D pt_middle = new Point2D();
            Point2D pt_gap_last = new Point2D(0.0, 0.0);
            Point2D v_after = new Point2D();
            Point2D v_before = new Point2D();
            Point2D v_gap = new Point2D();
            Point2D temp = new Point2D();
            double abs_d = this.m_abs_distance;
            int iter_count = closed ? ncount : isize - 2;
            int gap_counter = 0;
            int iter2 = 0;
            while (iter2 < iter_count) {
                edit_shape.getXY(inext, pt_after);
                if (reload2) {
                    edit_shape.getXY(ivert, pt_current);
                    edit_shape.getXY(iprev, pt_before);
                    ibefore = iprev;
                }
                v_before.sub(pt_current, pt_before);
                v_before.normalize();
                v_after.sub(pt_after, pt_current);
                v_after.normalize();
                if (ibefore == inext) break;
                double cross = v_before.crossProduct(v_after);
                double dot = v_before.dotProduct(v_after);
                boolean bDoJoin = cross < 0.0 || dot < 0.0 && cross == 0.0;
                boolean b_write = true;
                if (!bDoJoin) {
                    if (this.isGap_(pt_before, pt_current, pt_after)) {
                        pt_gap_last.setCoords(pt_after);
                        b_write = false;
                        ++gap_counter;
                        b_filtered = true;
                    }
                    bConvex = false;
                }
                if (b_write) {
                    block21: {
                        if (gap_counter > 0) {
                            int ibefore_before;
                            while (true) {
                                int n = ibefore_before = dir > 0 ? edit_shape.getPrevVertex(ibefore) : edit_shape.getNextVertex(ibefore);
                                if (ibefore_before == ivert) break block21;
                                edit_shape.getXY(ibefore_before, pt_before_before);
                                if (!this.isGap_(pt_before_before, pt_before, pt_gap_last)) break;
                                pt_before.setCoords(pt_before_before);
                                ibefore = ibefore_before;
                                b_write = false;
                                ++gap_counter;
                            }
                            if (ibefore_before != inext && this.isGap_(pt_before_before, pt_before, pt_after) && this.isGap_(pt_before_before, pt_current, pt_after)) {
                                pt_before.setCoords(pt_before_before);
                                ibefore = ibefore_before;
                                b_write = false;
                                ++gap_counter;
                            }
                        }
                    }
                    if (!b_write) continue;
                    if (gap_counter > 0) {
                        int p = dir > 0 ? edit_shape.getPrevVertex(iprev) : edit_shape.getNextVertex(iprev);
                        for (int i = 1; i < gap_counter; ++i) {
                            int pp2 = dir > 0 ? edit_shape.getPrevVertex(p) : edit_shape.getNextVertex(p);
                            edit_shape.removeVertex(p, true);
                            p = pp2;
                        }
                        v_gap.sub(pt_current, pt_before);
                        double gap_length = v_gap.length();
                        double sqr_delta = abs_d * abs_d - gap_length * gap_length * 0.25;
                        double delta = Math.sqrt(sqr_delta);
                        if (abs_d - delta > this.m_densify_dist * 0.5) {
                            pt_middle.add(pt_before, pt_current);
                            pt_middle.scale(0.5);
                            v_gap.normalize();
                            v_gap.rightPerpendicular();
                            temp.setCoords(v_gap);
                            temp.scale(abs_d - delta);
                            pt_middle.add(temp);
                            edit_shape.setXY(iprev, pt_middle);
                        } else {
                            edit_shape.removeVertex(iprev, true);
                        }
                        gap_counter = 0;
                    }
                    pt_before.setCoords(pt_current);
                    ibefore = ivert;
                }
                pt_current.setCoords(pt_after);
                iprev = ivert;
                ivert = inext;
                inext = dir > 0 ? edit_shape.getNextVertex(ivert) : edit_shape.getPrevVertex(ivert);
                ++iter2;
                reload2 = false;
            }
            if (gap_counter > 0) {
                int p = dir > 0 ? edit_shape.getPrevVertex(iprev) : edit_shape.getNextVertex(iprev);
                for (int i = 1; i < gap_counter; ++i) {
                    int pp3 = dir > 0 ? edit_shape.getPrevVertex(p) : edit_shape.getNextVertex(p);
                    edit_shape.removeVertex(p, true);
                    p = pp3;
                }
                pt_middle.add(pt_before, pt_current);
                pt_middle.scale(0.5);
                v_gap.sub(pt_current, pt_before);
                double gap_length = v_gap.length();
                double sqr_delta = abs_d * abs_d - gap_length * gap_length * 0.25;
                assert (sqr_delta > 0.0);
                double delta = Math.sqrt(sqr_delta);
                v_gap.normalize();
                v_gap.rightPerpendicular();
                temp.setCoords(v_gap);
                temp.scale(abs_d - delta);
                pt_middle.add(temp);
                edit_shape.setXY(iprev, pt_middle);
            }
            edit_shape.filterClosePoints(this.m_filter_tolerance, false, false);
            if (!b_filtered) break;
        }
        return 1;
    }

    private boolean isDegeneratePath_(MultiPathImpl mp_impl, int ipath) {
        if (mp_impl.getPathSize(ipath) == 1) {
            return true;
        }
        Envelope2D env = new Envelope2D();
        mp_impl.queryPathEnvelope2D(ipath, env);
        return Math.max(env.getWidth(), env.getHeight()) < this.m_densify_dist * 0.5;
    }

    private boolean isDegenerateGeometry_(Geometry geom) {
        Envelope2D env = new Envelope2D();
        geom.queryEnvelope2D(env);
        return Math.max(env.getWidth(), env.getHeight()) < this.m_densify_dist * 0.5;
    }

    private Polyline preparePolyline_(Polyline input_geom) {
        Polyline generalized_polyline = (Polyline)((OperatorGeneralize)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Generalize)).execute(input_geom, this.m_densify_dist * 0.25, false, this.m_progress_tracker);
        int path_point_count = 0;
        int npath = generalized_polyline.getPathCount();
        for (int i = 0; i < npath; ++i) {
            path_point_count = Math.max(generalized_polyline.getPathSize(i), path_point_count);
        }
        if (path_point_count < 32) {
            this.m_bfilter = false;
            return generalized_polyline;
        }
        this.m_bfilter = true;
        Polyline simple_polyline = (Polyline)TopologicalOperations.planarSimplify(generalized_polyline, this.m_small_tolerance, false, true, this.m_progress_tracker);
        return simple_polyline;
    }

    private void addCircle_(MultiPathImpl result_mp, Point point) {
        Point2D center = point.getXY();
        if (this.m_circle_template != null && !this.m_circle_template.isEmpty()) {
            Point2D p = new Point2D();
            p.setCoords(this.m_circle_template.get(0));
            p.scaleAdd(this.m_abs_distance, center);
            result_mp.startPath(p);
            int n = this.m_circle_template.size();
            for (int i = 1; i < n; ++i) {
                p.setCoords(this.m_circle_template.get(i));
                p.scaleAdd(this.m_abs_distance, center);
                result_mp.lineTo(p);
            }
            return;
        }
        int N = this.calcN_(4);
        int real_size = (N + 3) / 4;
        double dA = 1.5707963267948966 / (double)real_size;
        double dcos = Math.cos(dA);
        double dsin = Math.sin(dA);
        Point2D pt = new Point2D();
        for (int quadrant = 3; quadrant >= 0; --quadrant) {
            pt.setCoords(0.0, this.m_abs_distance);
            switch (quadrant) {
                case 0: {
                    int i;
                    for (i = 0; i < real_size; ++i) {
                        result_mp.lineTo(pt.x + center.x, pt.y + center.y);
                        pt.rotateReverse(dcos, dsin);
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < real_size; ++i) {
                        result_mp.lineTo(-pt.y + center.x, pt.x + center.y);
                        pt.rotateReverse(dcos, dsin);
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < real_size; ++i) {
                        result_mp.lineTo(-pt.x + center.x, -pt.y + center.y);
                        pt.rotateReverse(dcos, dsin);
                    }
                    break;
                }
                default: {
                    int i;
                    result_mp.startPath(pt.y + center.x, -pt.x + center.y);
                    for (i = 1; i < real_size; ++i) {
                        pt.rotateReverse(dcos, dsin);
                        result_mp.lineTo(pt.y + center.x, -pt.x + center.y);
                    }
                }
            }
            this.progress_();
        }
    }

    private static Polygon setWeakSimple_(Polygon poly) {
        ((MultiPathImpl)poly._getImpl()).setIsSimple(1, 0.0, false);
        return poly;
    }

    private Polygon setStrongSimple_(Polygon poly) {
        ((MultiPathImpl)poly._getImpl()).setIsSimple(2, this.m_tolerance, false);
        ((MultiPathImpl)poly._getImpl())._updateOGCFlags();
        return poly;
    }

    private static final class GeometryCursorForPolygon
    extends GeometryCursor {
        private Bufferer m_bufferer;
        private int m_index;

        GeometryCursorForPolygon(Bufferer bufferer) {
            this.m_bufferer = bufferer;
            this.m_index = 0;
        }

        @Override
        public Geometry next() {
            Polygon input_polygon = (Polygon)this.m_bufferer.m_geometry;
            if (this.m_index < input_polygon.getPathCount()) {
                double hole_area;
                int ind = this.m_index;
                double area = input_polygon.calculateRingArea2D(this.m_index);
                assert (area > 0.0);
                ++this.m_index;
                while (this.m_index < input_polygon.getPathCount() && !((hole_area = input_polygon.calculateRingArea2D(this.m_index)) > 0.0)) {
                    ++this.m_index;
                }
                if (ind == 0 && this.m_index == input_polygon.getPathCount()) {
                    return this.m_bufferer.bufferPolygonImpl_(input_polygon, 0, input_polygon.getPathCount());
                }
                return this.m_bufferer.bufferPolygonImpl_(input_polygon, ind, this.m_index);
            }
            return null;
        }

        @Override
        public int getGeometryID() {
            return 0;
        }
    }

    private static final class GeometryCursorForPolyline
    extends GeometryCursor {
        private Bufferer m_bufferer;
        private int m_index;
        private boolean m_bfilter;

        GeometryCursorForPolyline(Bufferer bufferer, boolean bfilter) {
            this.m_bufferer = bufferer;
            this.m_index = 0;
            this.m_bfilter = bfilter;
        }

        @Override
        public Geometry next() {
            MultiPathImpl mp = (MultiPathImpl)this.m_bufferer.m_geometry._getImpl();
            if (this.m_index < mp.getPathCount()) {
                int ind;
                if (!mp.isClosedPathInXYPlane(ind = this.m_index++)) {
                    Point2D prev_end = mp.getXY(mp.getPathEnd(ind) - 1);
                    while (this.m_index < mp.getPathCount()) {
                        Point2D start = mp.getXY(mp.getPathStart(this.m_index));
                        if (mp.isClosedPathInXYPlane(this.m_index) || start != prev_end) break;
                        prev_end = mp.getXY(mp.getPathEnd(this.m_index) - 1);
                        ++this.m_index;
                    }
                }
                if (this.m_index - ind == 1) {
                    return this.m_bufferer.bufferPolylinePath_((Polyline)this.m_bufferer.m_geometry, ind, this.m_bfilter);
                }
                Polyline tmp_polyline = new Polyline(this.m_bufferer.m_geometry.getDescription());
                tmp_polyline.addPath((Polyline)this.m_bufferer.m_geometry, ind, true);
                for (int i = ind + 1; i < this.m_index; ++i) {
                    ((MultiPathImpl)tmp_polyline._getImpl()).addSegmentsFromPath((MultiPathImpl)this.m_bufferer.m_geometry._getImpl(), i, 0, mp.getSegmentCount(i), false);
                }
                Polygon res = this.m_bufferer.bufferPolylinePath_(tmp_polyline, 0, this.m_bfilter);
                return res;
            }
            return null;
        }

        @Override
        public int getGeometryID() {
            return 0;
        }
    }

    private static final class GeometryCursorForMultiPoint
    extends GeometryCursor {
        private int m_index = 0;
        private Geometry m_buffered_polygon;
        private MultiPoint m_mp;
        private SpatialReference m_spatialReference;
        private double m_distance;
        private double m_densify_dist;
        private double m_x;
        private double m_y;
        private int m_max_vertex_in_complete_circle;
        private ProgressTracker m_progress_tracker;

        GeometryCursorForMultiPoint(MultiPoint mp, double distance, SpatialReference sr, double densify_dist, int max_vertex_in_complete_circle, ProgressTracker progress_tracker) {
            this.m_mp = mp;
            this.m_x = 0.0;
            this.m_y = 0.0;
            this.m_distance = distance;
            this.m_spatialReference = sr;
            this.m_densify_dist = densify_dist;
            this.m_max_vertex_in_complete_circle = max_vertex_in_complete_circle;
            this.m_progress_tracker = progress_tracker;
        }

        @Override
        public Geometry next() {
            Geometry res;
            Point point = new Point();
            do {
                if (this.m_index == this.m_mp.getPointCount()) {
                    return null;
                }
                this.m_mp.getPointByVal(this.m_index, point);
                ++this.m_index;
            } while (point.isEmpty());
            boolean b_first = false;
            if (this.m_buffered_polygon == null) {
                this.m_x = point.getX();
                this.m_y = point.getY();
                this.m_buffered_polygon = Bufferer.buffer(point, this.m_distance, this.m_spatialReference, this.m_densify_dist, this.m_max_vertex_in_complete_circle, this.m_progress_tracker);
                b_first = true;
            }
            if (this.m_index < this.m_mp.getPointCount()) {
                res = new Polygon();
                this.m_buffered_polygon.copyTo(res);
            } else {
                res = this.m_buffered_polygon;
            }
            if (!b_first) {
                Transformation2D transform2 = new Transformation2D();
                double dx = point.getX() - this.m_x;
                double dy = point.getY() - this.m_y;
                transform2.setShift(dx, dy);
                res.applyTransformation(transform2);
            }
            return res;
        }

        @Override
        public int getGeometryID() {
            return 0;
        }
    }

    private static final class BufferCommand {
        private Point2D m_from = new Point2D();
        private Point2D m_to = new Point2D();
        private Point2D m_center = new Point2D();
        private int m_next;
        private int m_prev;
        private int m_type;

        private BufferCommand(Point2D from2, Point2D to2, Point2D center, int type, int next2, int prev) {
            this.m_from.setCoords(from2);
            this.m_to.setCoords(to2);
            this.m_center.setCoords(center);
            this.m_type = type;
            this.m_next = next2;
            this.m_prev = prev;
        }

        private BufferCommand(Point2D from2, Point2D to2, int next2, int prev, String dummy) {
            this.m_from.setCoords(from2);
            this.m_to.setCoords(to2);
            this.m_center.setNaN();
            this.m_type = 4;
            this.m_next = next2;
            this.m_prev = prev;
        }

        private static interface Flags {
            public static final int enum_line = 1;
            public static final int enum_arc = 2;
            public static final int enum_dummy = 4;
            public static final int enum_concave_dip = 8;
            public static final int enum_connection = 3;
        }
    }
}

