/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;

final class AttributeStreamOfInt8
extends AttributeStreamBase {
    byte[] m_buffer = null;
    int m_size;

    public int size() {
        return this.m_size;
    }

    public void reserve(int reserve) {
        if (reserve <= 0) {
            return;
        }
        if (this.m_buffer == null) {
            this.m_buffer = new byte[reserve];
        } else {
            if (reserve <= this.m_buffer.length) {
                return;
            }
            byte[] buf = new byte[reserve];
            System.arraycopy(this.m_buffer, 0, buf, 0, this.m_size);
            this.m_buffer = buf;
        }
    }

    public AttributeStreamOfInt8(int size2) {
        int sz = size2;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new byte[sz];
        this.m_size = size2;
    }

    public AttributeStreamOfInt8(int size2, byte defaultValue2) {
        int sz = size2;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new byte[sz];
        this.m_size = size2;
        for (int i = 0; i < size2; ++i) {
            this.m_buffer[i] = defaultValue2;
        }
    }

    public AttributeStreamOfInt8(AttributeStreamOfInt8 other) {
        this.m_buffer = (byte[])other.m_buffer.clone();
        this.m_size = other.m_size;
    }

    public AttributeStreamOfInt8(AttributeStreamOfInt8 other, int maxSize) {
        int sz;
        this.m_size = other.size();
        if (this.m_size > maxSize) {
            this.m_size = maxSize;
        }
        if ((sz = this.m_size) < 2) {
            sz = 2;
        }
        this.m_buffer = new byte[sz];
        System.arraycopy(other.m_buffer, 0, this.m_buffer, 0, this.m_size);
    }

    public byte read(int offset) {
        return this.m_buffer[offset];
    }

    public void write(int offset, byte value2) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value2;
    }

    public void set(int offset, byte value2) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value2;
    }

    public void add(byte v) {
        this.resize(this.m_size + 1);
        this.m_buffer[this.m_size - 1] = v;
    }

    @Override
    public AttributeStreamBase restrictedClone(int maxsize) {
        int len = this.m_size;
        int newSize = maxsize < len ? maxsize : len;
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
        this.m_buffer = newBuffer;
        this.m_size = newSize;
        return this;
    }

    @Override
    public int virtualSize() {
        return this.size();
    }

    @Override
    public int getPersistence() {
        return 4;
    }

    @Override
    public double readAsDbl(int offset) {
        return this.read(offset);
    }

    int get(int offset) {
        return this.m_buffer[offset];
    }

    @Override
    public int readAsInt(int offset) {
        return this.read(offset);
    }

    @Override
    public long readAsInt64(int offset) {
        return this.read(offset);
    }

    @Override
    public void resize(int newSize) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                byte[] newBuffer = new byte[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                byte[] newBuffer = new byte[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        }
    }

    @Override
    public void resizePreserveCapacity(int newSize) {
        if (this.m_buffer == null || newSize > this.m_buffer.length) {
            this.resize(newSize);
        }
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        this.m_size = newSize;
    }

    @Override
    public void resize(int newSize, double defaultValue2) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                byte[] newBuffer = new byte[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                byte[] newBuffer = new byte[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            for (int i = this.m_size; i < newSize; ++i) {
                this.m_buffer[i] = (byte)defaultValue2;
            }
            this.m_size = newSize;
        }
    }

    @Override
    public void writeAsDbl(int offset, double d) {
        this.write(offset, (byte)d);
    }

    @Override
    public void writeAsInt64(int offset, long d) {
        this.write(offset, (byte)d);
    }

    @Override
    public void writeAsInt(int offset, int d) {
        this.write(offset, (byte)d);
    }

    public void setBits(int offset, byte mask) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid call. Attribute Stream is read only.");
        }
        this.m_buffer[offset] = (byte)(this.m_buffer[offset] | mask);
    }

    void clearBits(int offset, byte mask) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid call. Attribute Stream is read only.");
        }
        this.m_buffer[offset] = (byte)(this.m_buffer[offset] & ~mask);
    }

    @Override
    public int calculateHashImpl(int hashCode, int start, int end) {
        int n = this.size();
        for (int i = start; i < n && i < end; ++i) {
            hashCode = NumberUtils.hash(hashCode, this.read(i));
        }
        return hashCode;
    }

    @Override
    public boolean equals(AttributeStreamBase other, int start, int end) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeStreamOfInt8)) {
            return false;
        }
        AttributeStreamOfInt8 _other = (AttributeStreamOfInt8)other;
        int size2 = this.size();
        int sizeOther = _other.size();
        if (end > size2 || end > sizeOther && size2 != sizeOther) {
            return false;
        }
        if (end > size2) {
            end = size2;
        }
        for (int i = start; i < end; ++i) {
            if (this.read(i) == _other.read(i)) continue;
            return false;
        }
        return true;
    }

    public byte getLast() {
        return this.m_buffer[this.m_size - 1];
    }

    public void removeLast() {
        this.resize(this.m_size - 1);
    }

    @Override
    public void addRange(AttributeStreamBase src, int start, int count2, boolean bForward, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count2 % stride == 0)) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.m_size;
        int newSize = oldSize + count2;
        this.resize(newSize);
        if (bForward) {
            System.arraycopy(((AttributeStreamOfDbl)src).m_buffer, start, this.m_buffer, oldSize, count2);
        } else {
            int n = count2;
            for (int i = 0; i < count2; i += stride) {
                n -= stride;
                for (int s2 = 0; s2 < stride; ++s2) {
                    this.m_buffer[oldSize + i + s2] = ((AttributeStreamOfInt8)src).m_buffer[start + n + s2];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, AttributeStreamBase src, int srcStart, int count2, boolean bForward, int stride, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count2 % stride == 0)) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count2, validSize - start);
        if (this.m_buffer == ((AttributeStreamOfInt8)src).m_buffer && start < srcStart) {
            srcStart += count2;
        }
        if (bForward) {
            System.arraycopy(((AttributeStreamOfInt8)src).m_buffer, srcStart, this.m_buffer, start, count2);
        } else {
            int n = count2;
            for (int i = 0; i < count2; i += stride) {
                n -= stride;
                for (int s2 = 0; s2 < stride; ++s2) {
                    this.m_buffer[start + i + s2] = ((AttributeStreamOfInt8)src).m_buffer[srcStart + n + s2];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, double value2, int count2, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count2, validSize - start);
        byte v = (byte)value2;
        for (int i = 0; i < count2; ++i) {
            this.m_buffer[start + i] = v;
        }
    }

    @Override
    public void insertAttributes(int start, Point pt, int semantics, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        int comp = VertexDescription.getComponentCount(semantics);
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + comp, validSize - start);
        for (int c = 0; c < comp; ++c) {
            this.m_buffer[start + c] = (byte)pt.getAttributeAsDbl(semantics, c);
        }
    }

    @Override
    public void eraseRange(int index2, int count2, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (index2 + count2 > this.m_size) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, index2 + count2, this.m_buffer, index2, validSize - (index2 + count2));
        this.m_size -= count2;
    }

    @Override
    public void readRange(int srcStart, int count2, ByteBuffer dst, int dstOffset, boolean bForward) {
        if (srcStart < 0 || count2 < 0 || dstOffset < 0 || this.size() < count2 + srcStart) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (dst.capacity() < dstOffset + elmSize * count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        int j = srcStart;
        if (!bForward) {
            j += count2 - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = dstOffset;
        int i = 0;
        while (i < count2) {
            dst.put(offset, this.m_buffer[j]);
            j += dj;
            ++i;
            offset += elmSize;
        }
    }

    @Override
    public void reverseRange(int index2, int count2, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (stride < 1 || count2 % stride != 0) {
            throw new GeometryException("invalid_call");
        }
        int cIterations = count2 >> 1;
        int n = count2;
        for (int i = 0; i < cIterations; i += stride) {
            n -= stride;
            for (int s2 = 0; s2 < stride; ++s2) {
                byte temp = this.m_buffer[index2 + i + s2];
                this.m_buffer[index2 + i + s2] = this.m_buffer[index2 + n + s2];
                this.m_buffer[index2 + n + s2] = temp;
            }
        }
    }

    @Override
    public void setRange(double value2, int start, int count2) {
        if (start < 0 || count2 < 0 || start < 0 || count2 + start > this.size()) {
            throw new IllegalArgumentException();
        }
        byte v = (byte)value2;
        int n = start + count2;
        for (int i = start; i < n; ++i) {
            this.write(i, v);
        }
    }

    @Override
    public void writeRange(int startElement2, int count2, AttributeStreamBase _src, int srcStart, boolean bForward, int stride) {
        if (startElement2 < 0 || count2 < 0 || srcStart < 0) {
            throw new IllegalArgumentException();
        }
        if (!(bForward || stride > 0 && count2 % stride == 0)) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfInt8 src = (AttributeStreamOfInt8)_src;
        if (src.size() < srcStart + count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        if (this.size() < count2 + startElement2) {
            this.resize(count2 + startElement2);
        }
        if (_src == this) {
            this._selfWriteRangeImpl(startElement2, count2, srcStart, bForward, stride);
            return;
        }
        if (bForward) {
            int j = startElement2;
            int offset = srcStart;
            for (int i = 0; i < count2; ++i) {
                this.m_buffer[j] = src.m_buffer[offset];
                ++j;
                ++offset;
            }
        } else {
            int j = startElement2;
            int offset = srcStart + count2 - stride;
            if (stride == 1) {
                for (int i = 0; i < count2; ++i) {
                    this.m_buffer[j] = src.m_buffer[offset];
                    ++j;
                    --offset;
                }
            } else {
                int n = count2 / stride;
                for (int i = 0; i < n; ++i) {
                    for (int k = 0; k < stride; ++k) {
                        this.m_buffer[j + k] = src.m_buffer[offset + k];
                    }
                    j += stride;
                    offset -= stride;
                }
            }
        }
    }

    private void _selfWriteRangeImpl(int toElement, int count2, int fromElement, boolean bForward, int stride) {
        int dj;
        int k;
        int i;
        int n;
        int j;
        int offset;
        if (bForward && toElement == fromElement) {
            return;
        }
        if (fromElement < toElement) {
            offset = fromElement + count2 - stride;
            j = toElement + count2 - stride;
            n = count2 / 2;
            for (i = 0; i < n; ++i) {
                for (k = 0; k < stride; ++k) {
                    this.m_buffer[j + k] = this.m_buffer[offset + k];
                }
                j -= stride;
                offset -= stride;
            }
        } else {
            offset = fromElement;
            j = toElement;
            dj = 1;
            for (i = 0; i < count2; ++i) {
                this.m_buffer[j] = this.m_buffer[offset];
                ++j;
                ++offset;
            }
        }
        if (!bForward) {
            j = toElement;
            offset = toElement + count2 - stride;
            dj = stride;
            n = count2 / 2;
            for (i = 0; i < n; ++i) {
                for (k = 0; k < stride; ++k) {
                    byte v = this.m_buffer[j + k];
                    this.m_buffer[j + k] = this.m_buffer[offset + k];
                    this.m_buffer[offset + k] = v;
                }
                j += stride;
                offset -= stride;
            }
        }
    }

    @Override
    public void writeRange(int startElement2, int count2, ByteBuffer src, int offsetBytes, boolean bForward) {
        if (startElement2 < 0 || count2 < 0 || offsetBytes < 0) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (src.capacity() < offsetBytes + elmSize * count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        if (this.size() < count2 + startElement2) {
            this.resize(count2 + startElement2);
        }
        int j = startElement2;
        if (!bForward) {
            j += count2 - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = offsetBytes;
        int i = 0;
        while (i < count2) {
            this.m_buffer[j] = src.get(offset);
            j += dj;
            ++i;
            offset += elmSize;
        }
    }
}

