/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class AttributeStreamOfDbl
extends AttributeStreamBase {
    double[] m_buffer = null;
    int m_size;

    public int size() {
        return this.m_size;
    }

    public void reserve(int reserve) {
        if (reserve <= 0) {
            return;
        }
        if (this.m_buffer == null) {
            this.m_buffer = new double[reserve];
        } else {
            if (reserve <= this.m_buffer.length) {
                return;
            }
            double[] buf = new double[reserve];
            System.arraycopy(this.m_buffer, 0, buf, 0, this.m_size);
            this.m_buffer = buf;
        }
    }

    public AttributeStreamOfDbl(int size2) {
        int sz = size2;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new double[sz];
        this.m_size = size2;
    }

    public AttributeStreamOfDbl(int size2, double defaultValue2) {
        int sz = size2;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new double[sz];
        this.m_size = size2;
        Arrays.fill(this.m_buffer, 0, size2, defaultValue2);
    }

    public AttributeStreamOfDbl(AttributeStreamOfDbl other) {
        this.m_buffer = (double[])other.m_buffer.clone();
        this.m_size = other.m_size;
    }

    public AttributeStreamOfDbl(AttributeStreamOfDbl other, int maxSize) {
        int sz;
        this.m_size = other.size();
        if (this.m_size > maxSize) {
            this.m_size = maxSize;
        }
        if ((sz = this.m_size) < 2) {
            sz = 2;
        }
        this.m_buffer = new double[sz];
        System.arraycopy(other.m_buffer, 0, this.m_buffer, 0, this.m_size);
    }

    public double read(int offset) {
        return this.m_buffer[offset];
    }

    public double get(int offset) {
        return this.m_buffer[offset];
    }

    public void write(int offset, double value2) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value2;
    }

    public void set(int offset, double value2) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value2;
    }

    public void read(int offset, Point2D outPoint) {
        outPoint.x = this.m_buffer[offset];
        outPoint.y = this.m_buffer[offset + 1];
    }

    void write(int offset, Point2D point) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = point.x;
        this.m_buffer[offset + 1] = point.y;
    }

    public void add(double v) {
        this.resize(this.m_size + 1);
        this.m_buffer[this.m_size - 1] = v;
    }

    @Override
    public AttributeStreamBase restrictedClone(int maxsize) {
        AttributeStreamOfDbl clone2 = new AttributeStreamOfDbl(this, maxsize);
        return clone2;
    }

    @Override
    public int virtualSize() {
        return this.size();
    }

    @Override
    public int getPersistence() {
        return 1;
    }

    @Override
    public double readAsDbl(int offset) {
        return this.read(offset);
    }

    @Override
    public int readAsInt(int offset) {
        return (int)this.read(offset);
    }

    @Override
    public long readAsInt64(int offset) {
        return (long)this.read(offset);
    }

    @Override
    public void resize(int newSize) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                double[] newBuffer = new double[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                double[] newBuffer = new double[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        }
    }

    @Override
    public void resizePreserveCapacity(int newSize) {
        if (this.m_buffer == null || newSize > this.m_buffer.length) {
            this.resize(newSize);
        }
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        this.m_size = newSize;
    }

    @Override
    public void resize(int newSize, double defaultValue2) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                double[] newBuffer = new double[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                double[] newBuffer = new double[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            Arrays.fill(this.m_buffer, this.m_size, newSize, defaultValue2);
            this.m_size = newSize;
        }
    }

    @Override
    public void writeAsDbl(int offset, double d) {
        this.write(offset, d);
    }

    @Override
    public void writeAsInt64(int offset, long d) {
        this.write(offset, d);
    }

    @Override
    public void writeAsInt(int offset, int d) {
        this.write(offset, d);
    }

    public void setEnvelopeFromPoints(int pointCount, Envelope2D inOutEnv) {
        if (pointCount == 0) {
            inOutEnv.setEmpty();
            return;
        }
        if (pointCount < 0) {
            pointCount = this.size() / 2;
        } else if (pointCount * 2 > this.size()) {
            throw new IllegalArgumentException();
        }
        inOutEnv.setCoords(this.read(0), this.read(1));
        for (int i = 1; i < pointCount; ++i) {
            inOutEnv.mergeNE(this.read(i * 2), this.read(i * 2 + 1));
        }
    }

    @Override
    public int calculateHashImpl(int hashCodeIn, int start, int end) {
        int hashCode = hashCodeIn;
        int n = this.size();
        for (int i = start; i < n && i < end; ++i) {
            hashCode = NumberUtils.hash(hashCode, this.read(i));
        }
        return hashCode;
    }

    @Override
    public boolean equals(AttributeStreamBase other, int start, int end) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeStreamOfDbl)) {
            return false;
        }
        AttributeStreamOfDbl _other = (AttributeStreamOfDbl)other;
        int size2 = this.size();
        int sizeOther = _other.size();
        if (end > size2 || end > sizeOther && size2 != sizeOther) {
            return false;
        }
        if (end > size2) {
            end = size2;
        }
        for (int i = start; i < end; ++i) {
            if (this.read(i) == _other.read(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addRange(AttributeStreamBase src, int start, int count2, boolean bForward, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count2 % stride == 0)) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.m_size;
        int newSize = oldSize + count2;
        this.resize(newSize);
        if (bForward) {
            System.arraycopy(((AttributeStreamOfDbl)src).m_buffer, start, this.m_buffer, oldSize, count2);
        } else {
            int n = count2;
            for (int i = 0; i < count2; i += stride) {
                n -= stride;
                for (int s2 = 0; s2 < stride; ++s2) {
                    this.m_buffer[oldSize + i + s2] = ((AttributeStreamOfDbl)src).m_buffer[start + n + s2];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, AttributeStreamBase src, int srcStart, int count2, boolean bForward, int stride, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count2 % stride == 0)) {
            throw new IllegalArgumentException();
        }
        int excess_space = this.m_size - validSize;
        if (excess_space < count2) {
            int original_size = this.m_size;
            this.resize(original_size + count2 - excess_space);
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count2, validSize - start);
        if (this.m_buffer == ((AttributeStreamOfDbl)src).m_buffer && start < srcStart) {
            srcStart += count2;
        }
        if (bForward) {
            System.arraycopy(((AttributeStreamOfDbl)src).m_buffer, srcStart, this.m_buffer, start, count2);
        } else {
            int n = count2;
            for (int i = 0; i < count2; i += stride) {
                n -= stride;
                for (int s2 = 0; s2 < stride; ++s2) {
                    this.m_buffer[start + i + s2] = ((AttributeStreamOfDbl)src).m_buffer[srcStart + n + s2];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, double value2, int count2, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count2, validSize - start);
        for (int i = 0; i < count2; ++i) {
            this.m_buffer[start + i] = value2;
        }
    }

    @Override
    public void insertAttributes(int start, Point pt, int semantics, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        int comp = VertexDescription.getComponentCount(semantics);
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + comp, validSize - start);
        for (int c = 0; c < comp; ++c) {
            this.m_buffer[start + c] = pt.getAttributeAsDbl(semantics, c);
        }
    }

    public void insert(int index2, Point2D point, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, index2, this.m_buffer, index2 + 2, validSize - index2);
        this.m_buffer[index2] = point.x;
        this.m_buffer[index2 + 1] = point.y;
    }

    public void writeRange(int streamOffset, int count2, double[][] src, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || count2 < 0 || arrayOffset < 0 || count2 > NumberUtils.intMax()) {
            throw new IllegalArgumentException();
        }
        if (src.length * 2 < (arrayOffset << 1) + count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        if (this.size() < count2 + streamOffset) {
            this.resize(count2 + streamOffset);
        }
        int j = streamOffset;
        if (!bForward) {
            j += count2 - 1;
        }
        int dj = bForward ? 2 : -2;
        int end = arrayOffset + (count2 >> 1);
        for (int i = arrayOffset; i < end; ++i) {
            this.m_buffer[j] = src[i][0];
            this.m_buffer[j + 1] = src[i][1];
            j += dj;
        }
    }

    public void writeRange(int streamOffset, int count2, double[] src, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || count2 < 0 || arrayOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (src.length < arrayOffset + count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        if (this.size() < count2 + streamOffset) {
            this.resize(count2 + streamOffset);
        }
        if (bForward) {
            System.arraycopy(src, arrayOffset, this.m_buffer, streamOffset, count2);
        } else {
            int j = streamOffset;
            if (!bForward) {
                j += count2 - 1;
            }
            int end = arrayOffset + count2;
            for (int i = arrayOffset; i < end; ++i) {
                this.m_buffer[j] = src[i];
                --j;
            }
        }
    }

    public void readRange(int streamOffset, int count2, double[][] dst, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || count2 < 0 || arrayOffset < 0 || count2 > NumberUtils.intMax() || this.size() < count2 + streamOffset) {
            throw new IllegalArgumentException();
        }
        if (dst.length * 2 < (arrayOffset << 1) + count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        int j = streamOffset;
        if (!bForward) {
            j += count2 - 1;
        }
        int dj = bForward ? 2 : -2;
        int end = arrayOffset + (count2 >> 1);
        for (int i = arrayOffset; i < end; ++i) {
            dst[i][0] = this.m_buffer[j];
            dst[i][1] = this.m_buffer[j + 1];
            j += dj;
        }
    }

    @Override
    public void eraseRange(int index2, int count2, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (index2 + count2 > this.m_size) {
            throw new GeometryException("invalid_call");
        }
        if (validSize - (index2 + count2) > 0) {
            System.arraycopy(this.m_buffer, index2 + count2, this.m_buffer, index2, validSize - (index2 + count2));
        }
        this.m_size -= count2;
    }

    @Override
    public void readRange(int srcStart, int count2, ByteBuffer dst, int dstOffset, boolean bForward) {
        if (srcStart < 0 || count2 < 0 || dstOffset < 0 || this.size() < count2 + srcStart) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (dst.capacity() < dstOffset + elmSize * count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        int j = srcStart;
        if (!bForward) {
            j += count2 - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = dstOffset;
        int i = 0;
        while (i < count2) {
            dst.putDouble(offset, this.m_buffer[j]);
            j += dj;
            ++i;
            offset += elmSize;
        }
    }

    @Override
    public void reverseRange(int index2, int count2, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (stride < 1 || count2 % stride != 0) {
            throw new GeometryException("invalid_call");
        }
        int cIterations = count2 >> 1;
        int n = count2;
        for (int i = 0; i < cIterations; i += stride) {
            n -= stride;
            for (int s2 = 0; s2 < stride; ++s2) {
                double temp = this.m_buffer[index2 + i + s2];
                this.m_buffer[index2 + i + s2] = this.m_buffer[index2 + n + s2];
                this.m_buffer[index2 + n + s2] = temp;
            }
        }
    }

    @Override
    public void setRange(double value2, int start, int count2) {
        if (start < 0 || count2 < 0 || start < 0 || count2 + start > this.size()) {
            throw new IllegalArgumentException();
        }
        double v = value2;
        Arrays.fill(this.m_buffer, start, start + count2, v);
    }

    @Override
    public void writeRange(int startElement2, int count2, AttributeStreamBase _src, int srcStart, boolean bForward, int stride) {
        if (startElement2 < 0 || count2 < 0 || srcStart < 0) {
            throw new IllegalArgumentException();
        }
        if (!(bForward || stride > 0 && count2 % stride == 0)) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl src = (AttributeStreamOfDbl)_src;
        if (src.size() < srcStart + count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        if (this.size() < count2 + startElement2) {
            this.resize(count2 + startElement2);
        }
        if (_src == this) {
            this._selfWriteRangeImpl(startElement2, count2, srcStart, bForward, stride);
            return;
        }
        if (bForward) {
            int j = startElement2;
            int offset = srcStart;
            for (int i = 0; i < count2; ++i) {
                this.m_buffer[j] = src.m_buffer[offset];
                ++j;
                ++offset;
            }
        } else {
            int j = startElement2;
            int offset = srcStart + count2 - stride;
            if (stride == 1) {
                for (int i = 0; i < count2; ++i) {
                    this.m_buffer[j] = src.m_buffer[offset];
                    ++j;
                    --offset;
                }
            } else {
                int n = count2 / stride;
                for (int i = 0; i < n; ++i) {
                    for (int k = 0; k < stride; ++k) {
                        this.m_buffer[j + k] = src.m_buffer[offset + k];
                    }
                    j += stride;
                    offset -= stride;
                }
            }
        }
    }

    private void _selfWriteRangeImpl(int toElement, int count2, int fromElement, boolean bForward, int stride) {
        if (bForward && toElement == fromElement) {
            return;
        }
        System.arraycopy(this.m_buffer, fromElement, this.m_buffer, toElement, count2);
        if (bForward) {
            return;
        }
        int j = toElement;
        int offset = toElement + count2 - stride;
        int dj = stride;
        int n = count2 / 2;
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < stride; ++k) {
                double v = this.m_buffer[j + k];
                this.m_buffer[j + k] = this.m_buffer[offset + k];
                this.m_buffer[offset + k] = v;
            }
            j += stride;
            offset -= stride;
        }
    }

    @Override
    public void writeRange(int startElement2, int count2, ByteBuffer src, int offsetBytes, boolean bForward) {
        if (startElement2 < 0 || count2 < 0 || offsetBytes < 0) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (src.capacity() < offsetBytes + elmSize * count2) {
            throw new IllegalArgumentException();
        }
        if (count2 == 0) {
            return;
        }
        if (this.size() < count2 + startElement2) {
            this.resize(count2 + startElement2);
        }
        int j = startElement2;
        if (!bForward) {
            j += count2 - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = offsetBytes;
        int i = 0;
        while (i < count2) {
            this.m_buffer[j] = src.getDouble(offset);
            j += dj;
            ++i;
            offset += elmSize;
        }
    }

    public void writeRange(int streamOffset, int pointCount, Point2D[] src, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || pointCount < 0 || arrayOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (pointCount == 0) {
            return;
        }
        if (this.size() < (pointCount << 1) + streamOffset) {
            this.resize((pointCount << 1) + streamOffset);
        }
        int j = streamOffset;
        if (!bForward) {
            j += pointCount - 1 << 1;
        }
        int dj = bForward ? 2 : -2;
        int i0 = arrayOffset;
        pointCount += i0;
        for (int i = i0; i < pointCount; ++i) {
            this.m_buffer[j] = src[i].x;
            this.m_buffer[j + 1] = src[i].y;
            j += dj;
        }
    }

    public void readRange(int srcStart, int count2, double[] dst, int dstOffset, boolean bForward) {
        if (srcStart < 0 || count2 < 0 || dstOffset < 0 || this.size() < count2 + srcStart) {
            throw new IllegalArgumentException();
        }
        if (bForward) {
            System.arraycopy(this.m_buffer, srcStart, dst, dstOffset, count2);
        } else {
            int j = dstOffset + count2 - 1;
            for (int i = srcStart; i < count2; ++i) {
                dst[j] = this.m_buffer[i];
                --j;
            }
        }
    }

    public void sort(int start, int end) {
        Arrays.sort(this.m_buffer, start, end);
    }
}

