/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfFloat;
import com.esri.core.geometry.AttributeStreamOfInt16;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt64;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;

abstract class AttributeStreamBase {
    protected boolean m_bLockedInSize = false;
    protected boolean m_bReadonly = false;

    public abstract int virtualSize();

    public abstract int getPersistence();

    public abstract double readAsDbl(int var1);

    public abstract void writeAsDbl(int var1, double var2);

    public abstract int readAsInt(int var1);

    public abstract void writeAsInt(int var1, int var2);

    public abstract long readAsInt64(int var1);

    public abstract void writeAsInt64(int var1, long var2);

    public abstract void resize(int var1, double var2);

    public abstract void resize(int var1);

    public abstract void resizePreserveCapacity(int var1);

    void clear(boolean bFreeMemory) {
        if (bFreeMemory) {
            this.resize(0);
        } else {
            this.resizePreserveCapacity(0);
        }
    }

    public abstract void addRange(AttributeStreamBase var1, int var2, int var3, boolean var4, int var5);

    public abstract void insertRange(int var1, AttributeStreamBase var2, int var3, int var4, boolean var5, int var6, int var7);

    public abstract void insertRange(int var1, double var2, int var4, int var5);

    public abstract void insertAttributes(int var1, Point var2, int var3, int var4);

    public abstract void setRange(double var1, int var3, int var4);

    public abstract void writeRange(int var1, int var2, AttributeStreamBase var3, int var4, boolean var5, int var6);

    public abstract void writeRange(int var1, int var2, ByteBuffer var3, int var4, boolean var5);

    public abstract void readRange(int var1, int var2, ByteBuffer var3, int var4, boolean var5);

    public abstract void eraseRange(int var1, int var2, int var3);

    public abstract void reverseRange(int var1, int var2, int var3);

    public static AttributeStreamBase createByteStream(int size2) {
        AttributeStreamOfInt8 newStream = new AttributeStreamOfInt8(size2);
        return newStream;
    }

    public static AttributeStreamBase createByteStream(int size2, byte defaultValue2) {
        AttributeStreamOfInt8 newStream = new AttributeStreamOfInt8(size2, defaultValue2);
        return newStream;
    }

    public static AttributeStreamBase createDoubleStream(int size2) {
        AttributeStreamOfDbl newStream = new AttributeStreamOfDbl(size2);
        return newStream;
    }

    public static AttributeStreamBase createDoubleStream(int size2, double defaultValue2) {
        AttributeStreamOfDbl newStream = new AttributeStreamOfDbl(size2, defaultValue2);
        return newStream;
    }

    public abstract AttributeStreamBase restrictedClone(int var1);

    public void setReadonly() {
        this.m_bReadonly = true;
        this.m_bLockedInSize = true;
    }

    public boolean isReadonly() {
        return this.m_bReadonly;
    }

    public void lockSize() {
        this.m_bLockedInSize = true;
    }

    public boolean isLockedSize() {
        return this.m_bLockedInSize;
    }

    public static AttributeStreamBase createAttributeStreamWithPersistence(int persistence, int size2) {
        AttributeStreamBase newStream;
        switch (persistence) {
            case 0: {
                newStream = new AttributeStreamOfFloat(size2);
                break;
            }
            case 1: {
                newStream = new AttributeStreamOfDbl(size2);
                break;
            }
            case 2: {
                newStream = new AttributeStreamOfInt32(size2);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size2);
                break;
            }
            case 4: {
                newStream = new AttributeStreamOfInt8(size2);
                break;
            }
            case 5: {
                newStream = new AttributeStreamOfInt16(size2);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public static AttributeStreamBase createAttributeStreamWithPersistence(int persistence, int size2, double defaultValue2) {
        AttributeStreamBase newStream;
        switch (persistence) {
            case 0: {
                newStream = new AttributeStreamOfFloat(size2, (float)defaultValue2);
                break;
            }
            case 1: {
                newStream = new AttributeStreamOfDbl(size2, defaultValue2);
                break;
            }
            case 2: {
                newStream = new AttributeStreamOfInt32(size2, (int)defaultValue2);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size2, (long)defaultValue2);
                break;
            }
            case 4: {
                newStream = new AttributeStreamOfInt8(size2, (byte)defaultValue2);
                break;
            }
            case 5: {
                newStream = new AttributeStreamOfInt16(size2, (short)defaultValue2);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public static AttributeStreamBase createAttributeStreamWithSemantics(int semantics, int vertexCount) {
        int ncomps = VertexDescription.getComponentCount(semantics);
        int persistence = VertexDescription.getPersistence(semantics);
        return AttributeStreamBase.createAttributeStreamWithPersistence(persistence, vertexCount * ncomps, VertexDescription.getDefaultValue(semantics));
    }

    public static AttributeStreamBase createIndexStream(int size2) {
        AttributeStreamBase newStream;
        int persistence = 2;
        switch (persistence) {
            case 2: {
                newStream = new AttributeStreamOfInt32(size2);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size2);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public static AttributeStreamBase createIndexStream(int size2, int defaultValue2) {
        AttributeStreamBase newStream;
        int persistence = 2;
        switch (persistence) {
            case 2: {
                newStream = new AttributeStreamOfInt32(size2, defaultValue2);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size2, (long)defaultValue2);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public abstract int calculateHashImpl(int var1, int var2, int var3);

    public abstract boolean equals(AttributeStreamBase var1, int var2, int var3);
}

