/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.util.collection;

import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableSet;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NullAllowingImmutableMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final NullAllowingImmutableMap EMPTY = new NullAllowingImmutableMap(NullAllowingImmutableSet.of());
    private final NullAllowingImmutableSet<Map.Entry<K, V>> entries;

    public static <K, V> NullAllowingImmutableMap<K, V> of() {
        return EMPTY;
    }

    public static <K, V> NullAllowingImmutableMap<K, V> of(K key1, V value1) {
        return new NullAllowingImmutableMap<K, V>(NullAllowingImmutableSet.of(new AbstractMap.SimpleImmutableEntry<K, V>(key1, value1)));
    }

    public static <K, V> NullAllowingImmutableMap<K, V> of(K key1, V value1, K key2, V value2) {
        return Objects.equals(key1, key2) ? NullAllowingImmutableMap.of(key1, value1) : new NullAllowingImmutableMap<K, V>(NullAllowingImmutableSet.of(new AbstractMap.SimpleImmutableEntry<K, V>(key1, value1), new AbstractMap.SimpleImmutableEntry<K, V>(key2, value2)));
    }

    public static <K, V> NullAllowingImmutableMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        boolean equal12 = Objects.equals(key1, key2);
        boolean equal13 = Objects.equals(key1, key3);
        boolean equal23 = Objects.equals(key2, key3);
        if (equal12) {
            return equal13 ? NullAllowingImmutableMap.of(key1, value1) : NullAllowingImmutableMap.of(key1, value1, key3, value3);
        }
        if (equal13) {
            return NullAllowingImmutableMap.of(key1, value1, key2, value2);
        }
        if (equal23) {
            return NullAllowingImmutableMap.of(key1, value1, key2, value2);
        }
        return new NullAllowingImmutableMap<K, V>(NullAllowingImmutableSet.of(new AbstractMap.SimpleImmutableEntry<K, V>(key1, value1), new AbstractMap.SimpleImmutableEntry<K, V>(key2, value2), new AbstractMap.SimpleImmutableEntry<K, V>(key3, value3)));
    }

    public static <K, V> NullAllowingImmutableMap<K, V> copyOf(Map<K, V> map2) {
        if (map2 instanceof NullAllowingImmutableMap) {
            return (NullAllowingImmutableMap)map2;
        }
        NullAllowingImmutableSet.Builder<AbstractMap.SimpleImmutableEntry> entriesBuilder = NullAllowingImmutableSet.builder();
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            entriesBuilder.add(entry2 instanceof AbstractMap.SimpleImmutableEntry ? (AbstractMap.SimpleImmutableEntry)entry2 : new AbstractMap.SimpleImmutableEntry<K, V>(entry2.getKey(), entry2.getValue()));
        }
        return new NullAllowingImmutableMap<K, V>(entriesBuilder.build());
    }

    public static <K, V> Builder<K, V> builder() {
        return NullAllowingImmutableMap.builder(16);
    }

    public static <K, V> Builder<K, V> builder(int expectedSize) {
        return new Builder(expectedSize);
    }

    private NullAllowingImmutableMap(NullAllowingImmutableSet<Map.Entry<K, V>> entries) {
        this.entries = entries;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries;
    }

    @Override
    public boolean containsValue(Object value2) {
        for (Object element : this.entries.elements) {
            Map.Entry entry2 = (Map.Entry)element;
            if (!Objects.equals(entry2.getValue(), value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Object element : this.entries.elements) {
            Map.Entry entry2 = (Map.Entry)element;
            if (!Objects.equals(entry2.getKey(), key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (Object element : this.entries.elements) {
            Map.Entry entry2 = (Map.Entry)element;
            if (!Objects.equals(entry2.getKey(), key)) continue;
            return entry2.getValue();
        }
        return null;
    }

    public static class Builder<K, V> {
        private Object[] entries;
        private int size;

        public Builder(int expectedSize) {
            this.entries = new Object[expectedSize];
        }

        public Builder<K, V> put(K key, V value2) {
            this.maybeResize(1);
            this.entries[this.size++] = new AbstractMap.SimpleImmutableEntry<K, V>(key, value2);
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> newEntries) {
            this.maybeResize(newEntries.size());
            for (Map.Entry<K, V> entry2 : newEntries.entrySet()) {
                AbstractMap.SimpleImmutableEntry immutableEntry = entry2 instanceof AbstractMap.SimpleImmutableEntry ? (AbstractMap.SimpleImmutableEntry)entry2 : new AbstractMap.SimpleImmutableEntry<K, V>(entry2.getKey(), entry2.getValue());
                this.entries[this.size++] = immutableEntry;
            }
            return this;
        }

        public Map<K, V> build() {
            this.failIfDuplicateKeys();
            return new NullAllowingImmutableMap(new NullAllowingImmutableSet(this.size == this.entries.length ? this.entries : Arrays.copyOfRange(this.entries, 0, this.size)));
        }

        private void maybeResize(int toAdd) {
            int neededSize = this.size + toAdd;
            if (neededSize < 0) {
                throw new OutOfMemoryError();
            }
            if (neededSize > this.entries.length) {
                int newLength = this.entries.length * 2;
                if (newLength < 0) {
                    newLength = neededSize;
                }
                this.entries = Arrays.copyOf(this.entries, newLength);
            }
        }

        private void failIfDuplicateKeys() {
            for (int i = 0; i < this.size; ++i) {
                Map.Entry entry1 = (Map.Entry)this.entries[i];
                for (int j = i + 1; j < this.size; ++j) {
                    Map.Entry entry2 = (Map.Entry)this.entries[j];
                    if (!Objects.equals(entry1.getKey(), entry2.getKey())) continue;
                    throw new IllegalArgumentException("Duplicate key " + entry1.getKey());
                }
            }
        }
    }
}

