/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.util.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class NullAllowingImmutableList<E>
extends AbstractList<E>
implements Serializable {
    private static final NullAllowingImmutableList EMPTY = new NullAllowingImmutableList(new Object[0]);
    private final Object[] elements;

    @SafeVarargs
    public static <E> NullAllowingImmutableList<E> of(E ... elements) {
        return new NullAllowingImmutableList<E>(Arrays.copyOf(elements, elements.length));
    }

    public static <E> NullAllowingImmutableList<E> of() {
        return EMPTY;
    }

    public static <E> NullAllowingImmutableList<E> of(E element) {
        return new NullAllowingImmutableList<E>(new Object[]{element});
    }

    public static <E> NullAllowingImmutableList<E> of(E element1, E element2) {
        return new NullAllowingImmutableList<E>(new Object[]{element1, element2});
    }

    public static <E> NullAllowingImmutableList<E> of(E element1, E element2, E element3) {
        return new NullAllowingImmutableList<E>(new Object[]{element1, element2, element3});
    }

    public static <E> NullAllowingImmutableList<E> copyOf(Iterable<E> iterable) {
        return iterable instanceof NullAllowingImmutableList ? (NullAllowingImmutableList<E>)iterable : new NullAllowingImmutableList<E>(NullAllowingImmutableList.toArray(iterable));
    }

    public static <E> Builder<E> builder() {
        return NullAllowingImmutableList.builder(16);
    }

    public static <E> Builder<E> builder(int expectedSize) {
        return new Builder(expectedSize);
    }

    private NullAllowingImmutableList(Object[] elements) {
        this.elements = elements;
    }

    @Override
    public E get(int index2) {
        return (E)this.elements[index2];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    private static Object[] toArray(Iterable<?> iterable) {
        ArrayList collection2;
        if (iterable instanceof Collection) {
            collection2 = (ArrayList)iterable;
        } else {
            collection2 = new ArrayList();
            for (Object o : iterable) {
                collection2.add(o);
            }
        }
        return collection2.toArray();
    }

    public static class Builder<E> {
        private Object[] elements;
        private int size;

        public Builder(int expectedSize) {
            this.elements = new Object[expectedSize];
        }

        public Builder<E> add(E newElement) {
            this.maybeResize(1);
            this.elements[this.size++] = newElement;
            return this;
        }

        public Builder<E> addAll(Iterable<? extends E> newElements) {
            ArrayList<Object> collection2;
            if (newElements instanceof Collection) {
                collection2 = (ArrayList<Object>)newElements;
            } else {
                collection2 = new ArrayList<Object>();
                for (Object newElement : newElements) {
                    collection2.add(newElement);
                }
            }
            this.maybeResize(collection2.size());
            for (Object newElement : collection2) {
                this.elements[this.size++] = newElement;
            }
            return this;
        }

        public NullAllowingImmutableList<E> build() {
            return new NullAllowingImmutableList(this.size == this.elements.length ? this.elements : Arrays.copyOfRange(this.elements, 0, this.size));
        }

        private void maybeResize(int toAdd) {
            int neededSize = this.size + toAdd;
            if (neededSize < 0) {
                throw new OutOfMemoryError();
            }
            if (neededSize > this.elements.length) {
                int newLength = this.elements.length * 2;
                if (newLength < 0) {
                    newLength = neededSize;
                }
                this.elements = Arrays.copyOf(this.elements, newLength);
            }
        }
    }
}

