/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IntMap<V> {
    private final Object[] values;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    private IntMap(Set<Map.Entry<Integer, V>> entries) {
        int maxKey = -1;
        for (Map.Entry<Integer, V> entry2 : entries) {
            maxKey = Math.max(maxKey, entry2.getKey());
        }
        this.values = new Object[maxKey + 1];
        for (Map.Entry<Integer, V> entry2 : entries) {
            this.values[entry2.getKey().intValue()] = entry2.getValue();
        }
    }

    public V get(int key) {
        if (key < 0) {
            throw new IllegalArgumentException("key must be positive");
        }
        if (key >= this.values.length) {
            return null;
        }
        Object value2 = this.values[key];
        return (V)value2;
    }

    public static class Builder<V> {
        private Map<Integer, V> map = new HashMap<Integer, V>();

        public Builder<V> put(int key, V value2) {
            if (key < 0) {
                throw new IllegalArgumentException("key must be positive: " + key);
            }
            if (this.map.containsKey(key)) {
                throw new IllegalArgumentException("key already exists: " + key);
            }
            this.map.put(key, value2);
            return this;
        }

        public IntMap<V> build() {
            return new IntMap(this.map.entrySet());
        }
    }
}

