/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Bytes {
    private static final byte[] charToByte = new byte[256];
    private static final char[] byteToChar = new char[16];

    private Bytes() {
    }

    public static String toHexString(ByteBuffer bytes2) {
        if (bytes2 == null) {
            return null;
        }
        if (bytes2.remaining() == 0) {
            return "0x";
        }
        char[] array2 = new char[2 * (bytes2.remaining() + 1)];
        array2[0] = 48;
        array2[1] = 120;
        return Bytes.toRawHexString(bytes2, array2, 2);
    }

    private static String toRawHexString(ByteBuffer bytes2, char[] array2, int offset) {
        int size2 = bytes2.remaining();
        int bytesOffset = bytes2.position();
        assert (array2.length >= offset + 2 * size2);
        for (int i = 0; i < size2; ++i) {
            byte bint = bytes2.get(i + bytesOffset);
            array2[offset + i * 2] = byteToChar[(bint & 0xF0) >> 4];
            array2[offset + 1 + i * 2] = byteToChar[bint & 0xF];
        }
        return new String(array2);
    }

    public static String toHexString(byte[] byteArray) {
        return Bytes.toHexString(ByteBuffer.wrap(byteArray));
    }

    public static ByteBuffer fromHexString(String str) {
        if ((str.length() & 1) == 1) {
            throw new IllegalArgumentException("A CQL blob string must have an even length (since one byte is always 2 hexadecimal character)");
        }
        if (str.charAt(0) != '0' || str.charAt(1) != 'x') {
            throw new IllegalArgumentException("A CQL blob string must start with \"0x\"");
        }
        return ByteBuffer.wrap(Bytes.fromRawHexString(str, 2));
    }

    private static byte[] fromRawHexString(String str, int strOffset) {
        byte[] bytes2 = new byte[(str.length() - strOffset) / 2];
        for (int i = 0; i < bytes2.length; ++i) {
            byte halfByte1 = charToByte[str.charAt(strOffset + i * 2)];
            byte halfByte2 = charToByte[str.charAt(strOffset + i * 2 + 1)];
            if (halfByte1 == -1 || halfByte2 == -1) {
                throw new IllegalArgumentException("Non-hex characters in " + str);
            }
            bytes2[i] = (byte)(halfByte1 << 4 | halfByte2);
        }
        return bytes2;
    }

    public static byte[] getArray(ByteBuffer bytes2) {
        int length = bytes2.remaining();
        if (bytes2.hasArray()) {
            int boff = bytes2.arrayOffset() + bytes2.position();
            if (boff == 0 && length == bytes2.array().length) {
                return bytes2.array();
            }
            return Arrays.copyOfRange(bytes2.array(), boff, boff + length);
        }
        byte[] array2 = new byte[length];
        bytes2.duplicate().get(array2);
        return array2;
    }

    public static void erase(ByteBuffer bytes2) {
        if (!bytes2.isReadOnly()) {
            while (bytes2.hasRemaining()) {
                bytes2.put((byte)0);
            }
        }
    }

    static {
        for (int c = 0; c < charToByte.length; c = (int)((char)(c + 1))) {
            Bytes.charToByte[c] = c >= 48 && c <= 57 ? (int)(c - 48) : (c >= 65 && c <= 70 ? (int)(c - 65 + 10) : (c >= 97 && c <= 102 ? (int)(c - 97 + 10) : -1));
        }
        for (int i = 0; i < 16; ++i) {
            Bytes.byteToChar[i] = Integer.toHexString(i).charAt(0);
        }
    }
}

