/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Result;

public class SetKeyspace
extends Result {
    public final String keyspace;

    public SetKeyspace(String keyspace) {
        super(3);
        this.keyspace = keyspace;
    }

    public String toString() {
        return "SET_KEYSPACE(" + this.keyspace + ')';
    }

    public static class SubCodec
    extends Result.SubCodec {
        public SubCodec(int protocolVersion) {
            super(3, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            SetKeyspace setKeyspace = (SetKeyspace)message;
            encoder2.writeString(setKeyspace.keyspace, dest);
        }

        @Override
        public int encodedSize(Message message) {
            SetKeyspace setKeyspace = (SetKeyspace)message;
            return PrimitiveSizes.sizeOfString(setKeyspace.keyspace);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String keyspace = decoder2.readString(source);
            return new SetKeyspace(keyspace);
        }
    }
}

