/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.response.Result;
import java.util.List;

public class SchemaChange
extends Result {
    public final String changeType;
    public final String target;
    public final String keyspace;
    public final String object;
    public final List<String> arguments;

    public SchemaChange(String changeType, String target, String keyspace, String object, List<String> arguments) {
        super(5);
        this.changeType = changeType;
        this.target = target;
        this.keyspace = keyspace;
        this.object = object;
        this.arguments = arguments;
    }

    public String toString() {
        return String.format("SCHEMA_CHANGE(%s %s %s%s%s)", this.changeType, this.target, this.keyspace, this.object == null ? "" : "." + this.object, this.arguments == null || this.arguments.isEmpty() ? "" : this.arguments);
    }

    public static class SubCodec
    extends Result.SubCodec {
        public SubCodec(int protocolVersion) {
            super(5, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            SchemaChange schemaChange = (SchemaChange)message;
            encoder2.writeString(schemaChange.changeType, dest);
            encoder2.writeString(schemaChange.target, dest);
            encoder2.writeString(schemaChange.keyspace, dest);
            switch (schemaChange.target) {
                case "KEYSPACE": {
                    break;
                }
                case "TABLE": 
                case "TYPE": {
                    encoder2.writeString(schemaChange.object, dest);
                    break;
                }
                case "AGGREGATE": 
                case "FUNCTION": {
                    encoder2.writeString(schemaChange.object, dest);
                    encoder2.writeStringList(schemaChange.arguments, dest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown schema change target: " + schemaChange.target);
                }
            }
        }

        @Override
        public int encodedSize(Message message) {
            SchemaChange schemaChange = (SchemaChange)message;
            ProtocolErrors.check(this.protocolVersion >= 4 || !"AGGREGATE".equals(schemaChange.target) && !"FUNCTION".equals(schemaChange.target), "%s schema change events are not supported in protocol version %d", schemaChange.target, this.protocolVersion);
            int size2 = PrimitiveSizes.sizeOfString(schemaChange.changeType);
            size2 += PrimitiveSizes.sizeOfString(schemaChange.target);
            size2 += PrimitiveSizes.sizeOfString(schemaChange.keyspace);
            switch (schemaChange.target) {
                case "KEYSPACE": {
                    break;
                }
                case "TABLE": 
                case "TYPE": {
                    size2 += PrimitiveSizes.sizeOfString(schemaChange.object);
                    break;
                }
                case "AGGREGATE": 
                case "FUNCTION": {
                    size2 += PrimitiveSizes.sizeOfString(schemaChange.object);
                    size2 += PrimitiveSizes.sizeOfStringList(schemaChange.arguments);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown schema change target: " + schemaChange.target);
                }
            }
            return size2;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            List<String> arguments;
            String object;
            String changeType = decoder2.readString(source);
            String target = decoder2.readString(source);
            ProtocolErrors.check(this.protocolVersion >= 4 || !"AGGREGATE".equals(target) && !"FUNCTION".equals(target), "%s schema change events are not supported in protocol version %d", target, this.protocolVersion);
            String keyspace = decoder2.readString(source);
            switch (target) {
                case "KEYSPACE": {
                    object = null;
                    arguments = null;
                    break;
                }
                case "TABLE": 
                case "TYPE": {
                    object = decoder2.readString(source);
                    arguments = null;
                    break;
                }
                case "AGGREGATE": 
                case "FUNCTION": {
                    object = decoder2.readString(source);
                    arguments = decoder2.readStringList(source);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown schema change target: " + target);
                }
            }
            return new SchemaChange(changeType, target, keyspace, object, arguments);
        }
    }
}

