/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.util.Flags;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RowsMetadata {
    public final List<ColumnSpec> columnSpecs;
    public final int columnCount;
    public final ByteBuffer pagingState;
    public final int[] pkIndices;
    public final byte[] newResultMetadataId;
    public final int flags;

    public RowsMetadata(List<ColumnSpec> columnSpecs, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId) {
        this(RowsMetadata.computeFlags(false, columnSpecs, pagingState, newResultMetadataId), columnSpecs, columnSpecs.size(), pagingState, pkIndices, newResultMetadataId);
    }

    public RowsMetadata(int columnCount, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId) {
        this(RowsMetadata.computeFlags(true, Collections.emptyList(), pagingState, newResultMetadataId), Collections.emptyList(), columnCount, pagingState, pkIndices, newResultMetadataId);
    }

    public RowsMetadata(int flags2, List<ColumnSpec> columnSpecs, int columnCount, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId) {
        this.columnSpecs = columnSpecs;
        this.columnCount = columnCount;
        this.pagingState = pagingState;
        this.pkIndices = pkIndices;
        this.newResultMetadataId = newResultMetadataId;
        this.flags = flags2;
    }

    protected static int computeFlags(boolean noMetadata, List<ColumnSpec> columnSpecs, ByteBuffer pagingState, byte[] newResultMetadataId) {
        int flags2 = 0;
        if (noMetadata) {
            flags2 = Flags.add(flags2, 4);
        } else if (RowsMetadata.haveSameTable(columnSpecs)) {
            flags2 = Flags.add(flags2, 1);
        }
        if (pagingState != null) {
            flags2 = Flags.add(flags2, 2);
        }
        if (newResultMetadataId != null) {
            flags2 = Flags.add(flags2, 8);
        }
        return flags2;
    }

    public <B> void encode(B dest, PrimitiveCodec<B> encoder2, boolean withPkIndices, int protocolVersion) {
        encoder2.writeInt(this.flags, dest);
        encoder2.writeInt(this.columnCount, dest);
        if (withPkIndices) {
            if (this.pkIndices == null) {
                encoder2.writeInt(0, dest);
            } else {
                encoder2.writeInt(this.pkIndices.length, dest);
                for (int pkIndex : this.pkIndices) {
                    encoder2.writeUnsignedShort(pkIndex, dest);
                }
            }
        }
        if (Flags.contains(this.flags, 2)) {
            encoder2.writeBytes(this.pagingState, dest);
        }
        if (Flags.contains(this.flags, 8)) {
            encoder2.writeShortBytes(this.newResultMetadataId, dest);
        }
        if (!Flags.contains(this.flags, 4) && !this.columnSpecs.isEmpty()) {
            boolean globalTable = Flags.contains(this.flags, 1);
            if (globalTable) {
                ColumnSpec firstSpec = this.columnSpecs.get(0);
                encoder2.writeString(firstSpec.ksName, dest);
                encoder2.writeString(firstSpec.tableName, dest);
            }
            for (ColumnSpec spec : this.columnSpecs) {
                if (!globalTable) {
                    encoder2.writeString(spec.ksName, dest);
                    encoder2.writeString(spec.tableName, dest);
                }
                encoder2.writeString(spec.name, dest);
                spec.type.encode(dest, encoder2, protocolVersion);
            }
        }
    }

    public int encodedSize(boolean withPkIndices, int protocolVersion) {
        int size2 = 4;
        size2 += 4;
        if (Flags.contains(this.flags, 8)) {
            size2 += PrimitiveSizes.sizeOfShortBytes(this.newResultMetadataId);
        }
        if (withPkIndices) {
            size2 += 4;
            if (this.pkIndices != null) {
                size2 += this.pkIndices.length * 2;
            }
        }
        if (Flags.contains(this.flags, 2)) {
            size2 += PrimitiveSizes.sizeOfBytes(this.pagingState);
        }
        if (!Flags.contains(this.flags, 4) && !this.columnSpecs.isEmpty()) {
            boolean globalTable = Flags.contains(this.flags, 1);
            if (globalTable) {
                ColumnSpec firstSpec = this.columnSpecs.get(0);
                size2 += PrimitiveSizes.sizeOfString(firstSpec.ksName);
                size2 += PrimitiveSizes.sizeOfString(firstSpec.tableName);
            }
            for (ColumnSpec spec : this.columnSpecs) {
                if (!globalTable) {
                    size2 += PrimitiveSizes.sizeOfString(spec.ksName);
                    size2 += PrimitiveSizes.sizeOfString(spec.tableName);
                }
                size2 += PrimitiveSizes.sizeOfString(spec.name);
                size2 += spec.type.encodedSize(protocolVersion);
            }
        }
        return size2;
    }

    public static <B> RowsMetadata decode(B source, PrimitiveCodec<B> decoder2, boolean withPkIndices, int protocolVersion) {
        List<ColumnSpec> columnSpecs;
        byte[] newResultMetadataId;
        int pkCount;
        int flags2 = decoder2.readInt(source);
        int columnCount = decoder2.readInt(source);
        int[] pkIndices = null;
        if (withPkIndices && (pkCount = decoder2.readInt(source)) > 0) {
            pkIndices = new int[pkCount];
            for (int i = 0; i < pkCount; ++i) {
                pkIndices[i] = decoder2.readUnsignedShort(source);
            }
        }
        ByteBuffer state = Flags.contains(flags2, 2) ? decoder2.readBytes(source) : null;
        byte[] byArray = newResultMetadataId = Flags.contains(flags2, 8) ? decoder2.readShortBytes(source) : null;
        if (Flags.contains(flags2, 4)) {
            columnSpecs = Collections.emptyList();
        } else {
            boolean globalTablesSpec = Flags.contains(flags2, 1);
            String globalKsName = null;
            String globalCfName = null;
            if (globalTablesSpec) {
                globalKsName = decoder2.readString(source);
                globalCfName = decoder2.readString(source);
            }
            NullAllowingImmutableList.Builder<ColumnSpec> builder = NullAllowingImmutableList.builder(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String ksName = globalTablesSpec ? globalKsName : decoder2.readString(source);
                String cfName = globalTablesSpec ? globalCfName : decoder2.readString(source);
                String name2 = decoder2.readString(source);
                RawType type = RawType.decode(source, decoder2, protocolVersion);
                builder.add(new ColumnSpec(ksName, cfName, name2, i, type));
            }
            columnSpecs = builder.build();
        }
        return new RowsMetadata(flags2, columnSpecs, columnCount, state, pkIndices, newResultMetadataId);
    }

    private static boolean haveSameTable(List<ColumnSpec> specs2) {
        if (specs2.isEmpty()) {
            return false;
        }
        boolean first = true;
        String ksName = null;
        String tableName = null;
        for (ColumnSpec spec : specs2) {
            if (first) {
                first = false;
                ksName = spec.ksName;
                tableName = spec.tableName;
                continue;
            }
            if (Objects.equals(spec.ksName, ksName) && Objects.equals(spec.tableName, tableName)) continue;
            return false;
        }
        return true;
    }
}

