/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.util.List;
import java.util.Map;

public abstract class RawType {
    public final int id;
    public static final Map<Integer, RawType> PRIMITIVES;

    public static <B> RawType decode(B source, PrimitiveCodec<B> decoder2, int protocolVersion) {
        int id = decoder2.readUnsignedShort(source);
        switch (id) {
            case 0: {
                String className2 = decoder2.readString(source);
                return new RawCustom(className2);
            }
            case 32: {
                return new RawList(RawType.decode(source, decoder2, protocolVersion));
            }
            case 34: {
                return new RawSet(RawType.decode(source, decoder2, protocolVersion));
            }
            case 33: {
                RawType key = RawType.decode(source, decoder2, protocolVersion);
                RawType value2 = RawType.decode(source, decoder2, protocolVersion);
                return new RawMap(key, value2);
            }
            case 48: {
                String keyspace = decoder2.readString(source);
                String typeName = decoder2.readString(source);
                int fieldCount = decoder2.readUnsignedShort(source);
                NullAllowingImmutableMap.Builder<String, RawType> fields = NullAllowingImmutableMap.builder(fieldCount);
                for (int i = 0; i < fieldCount; ++i) {
                    String fieldName = decoder2.readString(source);
                    RawType fieldType = RawType.decode(source, decoder2, protocolVersion);
                    fields.put(fieldName, fieldType);
                }
                return new RawUdt(keyspace, typeName, fields.build());
            }
            case 49: {
                int fieldCount = decoder2.readUnsignedShort(source);
                NullAllowingImmutableList.Builder<RawType> fieldTypes = NullAllowingImmutableList.builder(fieldCount);
                for (int i = 0; i < fieldCount; ++i) {
                    fieldTypes.add(RawType.decode(source, decoder2, protocolVersion));
                }
                return new RawTuple(fieldTypes.build());
            }
        }
        RawType type = PRIMITIVES.get(id);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type id: " + id);
        }
        return type;
    }

    protected RawType(int id) {
        this.id = id;
    }

    public abstract <B> void encode(B var1, PrimitiveCodec<B> var2, int var3);

    public abstract int encodedSize(int var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawType rawType = (RawType)o;
        return this.id == rawType.id;
    }

    public int hashCode() {
        return this.id;
    }

    static {
        int[] primitiveIds = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 16, 9, 11, 12, 13, 14, 15, 19, 20, 21, 17, 18};
        NullAllowingImmutableMap.Builder<Integer, RawPrimitive> builder = NullAllowingImmutableMap.builder(primitiveIds.length);
        for (int id : primitiveIds) {
            builder.put(id, new RawPrimitive(id));
        }
        PRIMITIVES = builder.build();
    }

    public static class RawTuple
    extends RawType {
        public final List<RawType> fieldTypes;

        public RawTuple(List<RawType> fieldTypes) {
            super(49);
            this.fieldTypes = fieldTypes;
        }

        @Override
        public <B> void encode(B dest, PrimitiveCodec<B> encoder2, int protocolVersion) {
            encoder2.writeUnsignedShort(this.id, dest);
            encoder2.writeUnsignedShort(this.fieldTypes.size(), dest);
            for (RawType fieldType : this.fieldTypes) {
                fieldType.encode(dest, encoder2, protocolVersion);
            }
        }

        @Override
        public int encodedSize(int protocolVersion) {
            int size2 = 4;
            for (RawType fieldType : this.fieldTypes) {
                size2 += fieldType.encodedSize(protocolVersion);
            }
            return size2;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RawTuple rawTuple = (RawTuple)o;
            return this.fieldTypes.equals(rawTuple.fieldTypes);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.fieldTypes.hashCode();
            return result2;
        }
    }

    public static class RawUdt
    extends RawType {
        public final String keyspace;
        public final String typeName;
        public final Map<String, RawType> fields;

        public RawUdt(String keyspace, String typeName, Map<String, RawType> fields) {
            super(48);
            this.keyspace = keyspace;
            this.typeName = typeName;
            this.fields = fields;
        }

        @Override
        public <B> void encode(B dest, PrimitiveCodec<B> encoder2, int protocolVersion) {
            encoder2.writeUnsignedShort(this.id, dest);
            encoder2.writeString(this.keyspace, dest);
            encoder2.writeString(this.typeName, dest);
            encoder2.writeUnsignedShort(this.fields.size(), dest);
            for (Map.Entry<String, RawType> entry2 : this.fields.entrySet()) {
                encoder2.writeString(entry2.getKey(), dest);
                entry2.getValue().encode(dest, encoder2, protocolVersion);
            }
        }

        @Override
        public int encodedSize(int protocolVersion) {
            int size2 = 2 + PrimitiveSizes.sizeOfString(this.keyspace) + PrimitiveSizes.sizeOfString(this.typeName) + 2;
            for (Map.Entry<String, RawType> entry2 : this.fields.entrySet()) {
                size2 += PrimitiveSizes.sizeOfString(entry2.getKey());
                size2 += entry2.getValue().encodedSize(protocolVersion);
            }
            return size2;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RawUdt rawUdt = (RawUdt)o;
            return this.keyspace.equals(rawUdt.keyspace) && this.typeName.equals(rawUdt.typeName) && this.fields.equals(rawUdt.fields);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.keyspace.hashCode();
            result2 = 31 * result2 + this.typeName.hashCode();
            result2 = 31 * result2 + this.fields.hashCode();
            return result2;
        }
    }

    public static class RawMap
    extends RawType {
        public final RawType keyType;
        public final RawType valueType;

        public RawMap(RawType keyType, RawType valueType) {
            super(33);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public <B> void encode(B dest, PrimitiveCodec<B> encoder2, int protocolVersion) {
            encoder2.writeUnsignedShort(this.id, dest);
            this.keyType.encode(dest, encoder2, protocolVersion);
            this.valueType.encode(dest, encoder2, protocolVersion);
        }

        @Override
        public int encodedSize(int protocolVersion) {
            return 2 + this.keyType.encodedSize(protocolVersion) + this.valueType.encodedSize(protocolVersion);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RawMap rawMap = (RawMap)o;
            return this.keyType.equals(rawMap.keyType) && this.valueType.equals(rawMap.valueType);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.keyType.hashCode();
            result2 = 31 * result2 + this.valueType.hashCode();
            return result2;
        }
    }

    public static class RawSet
    extends RawType {
        public final RawType elementType;

        public RawSet(RawType elementType2) {
            super(34);
            this.elementType = elementType2;
        }

        @Override
        public <B> void encode(B dest, PrimitiveCodec<B> encoder2, int protocolVersion) {
            encoder2.writeUnsignedShort(this.id, dest);
            this.elementType.encode(dest, encoder2, protocolVersion);
        }

        @Override
        public int encodedSize(int protocolVersion) {
            return 2 + this.elementType.encodedSize(protocolVersion);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RawSet rawSet = (RawSet)o;
            return this.elementType.equals(rawSet.elementType);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.elementType.hashCode();
            return result2;
        }
    }

    public static class RawList
    extends RawType {
        public final RawType elementType;

        public RawList(RawType elementType2) {
            super(32);
            this.elementType = elementType2;
        }

        @Override
        public <B> void encode(B dest, PrimitiveCodec<B> encoder2, int protocolVersion) {
            encoder2.writeUnsignedShort(this.id, dest);
            this.elementType.encode(dest, encoder2, protocolVersion);
        }

        @Override
        public int encodedSize(int protocolVersion) {
            return 2 + this.elementType.encodedSize(protocolVersion);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RawList rawList = (RawList)o;
            return this.elementType.equals(rawList.elementType);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.elementType.hashCode();
            return result2;
        }
    }

    public static class RawCustom
    extends RawType {
        public final String className;

        public RawCustom(String className2) {
            super(0);
            this.className = className2;
        }

        @Override
        public <B> void encode(B dest, PrimitiveCodec<B> encoder2, int protocolVersion) {
            encoder2.writeUnsignedShort(this.id, dest);
            encoder2.writeString(this.className, dest);
        }

        @Override
        public int encodedSize(int protocolVersion) {
            return 2 + PrimitiveSizes.sizeOfString(this.className);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RawCustom rawCustom = (RawCustom)o;
            return this.className.equals(rawCustom.className);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.className.hashCode();
            return result2;
        }
    }

    public static class RawPrimitive
    extends RawType {
        private RawPrimitive(int id) {
            super(id);
        }

        @Override
        public <B> void encode(B dest, PrimitiveCodec<B> encoder2, int protocolVersion) {
            encoder2.writeUnsignedShort(this.id, dest);
        }

        @Override
        public int encodedSize(int protocolVersion) {
            return 2;
        }
    }
}

