/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public class DefaultRows
extends Rows {
    private final RowsMetadata metadata;
    private final Queue<List<ByteBuffer>> data;

    public DefaultRows(RowsMetadata metadata, Queue<List<ByteBuffer>> data2) {
        this.metadata = metadata;
        this.data = data2;
    }

    @Override
    public RowsMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Queue<List<ByteBuffer>> getData() {
        return this.data;
    }

    public String toString() {
        return "ROWS(" + this.data.size() + " x " + this.metadata.columnCount + " columns)";
    }

    public static class SubCodec
    extends Result.SubCodec {
        public SubCodec(int protocolVersion) {
            super(2, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            DefaultRows rows = (DefaultRows)message;
            rows.metadata.encode(dest, encoder2, false, this.protocolVersion);
            encoder2.writeInt(rows.data.size(), dest);
            for (List row : rows.data) {
                for (ByteBuffer column : row) {
                    encoder2.writeBytes(column, dest);
                }
            }
        }

        @Override
        public int encodedSize(Message message) {
            DefaultRows rows = (DefaultRows)message;
            int size2 = rows.metadata.encodedSize(false, this.protocolVersion) + 4;
            for (List row : rows.data) {
                for (ByteBuffer column : row) {
                    size2 += PrimitiveSizes.sizeOfBytes(column);
                }
            }
            return size2;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            RowsMetadata metadata = RowsMetadata.decode(source, decoder2, false, this.protocolVersion);
            int rowCount = decoder2.readInt(source);
            ArrayDeque<List<ByteBuffer>> data2 = new ArrayDeque<List<ByteBuffer>>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                NullAllowingImmutableList.Builder<ByteBuffer> row = NullAllowingImmutableList.builder(metadata.columnCount);
                for (int j = 0; j < metadata.columnCount; ++j) {
                    row.add(decoder2.readBytes(source));
                }
                data2.add(row.build());
            }
            return new DefaultRows(metadata, data2);
        }
    }
}

