/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.event;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Event;
import java.net.InetSocketAddress;

public class TopologyChangeEvent
extends Event {
    public final String changeType;
    public final InetSocketAddress address;

    public TopologyChangeEvent(String changeType, InetSocketAddress address) {
        super("TOPOLOGY_CHANGE");
        this.changeType = changeType;
        this.address = address;
    }

    public String toString() {
        return String.format("EVENT TOPOLOGY_CHANGE(%s %s)", this.changeType, this.address);
    }

    public static class SubCodec
    extends Event.SubCodec {
        public SubCodec(int protocolVersion) {
            super("TOPOLOGY_CHANGE", protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            TopologyChangeEvent event = (TopologyChangeEvent)message;
            encoder2.writeString(event.changeType, dest);
            encoder2.writeInet(event.address, dest);
        }

        @Override
        public int encodedSize(Message message) {
            TopologyChangeEvent event = (TopologyChangeEvent)message;
            return PrimitiveSizes.sizeOfString(event.changeType) + PrimitiveSizes.sizeOfInet(event.address);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String changeType = decoder2.readString(source);
            InetSocketAddress address = decoder2.readInet(source);
            return new TopologyChangeEvent(changeType, address);
        }
    }
}

