/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.event;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Event;
import java.net.InetSocketAddress;

public class StatusChangeEvent
extends Event {
    public final String changeType;
    public final InetSocketAddress address;

    public StatusChangeEvent(String changeType, InetSocketAddress address) {
        super("STATUS_CHANGE");
        this.changeType = changeType;
        this.address = address;
    }

    public String toString() {
        return String.format("EVENT STATUS_CHANGE(%s %s)", this.changeType, this.address);
    }

    public static class SubCodec
    extends Event.SubCodec {
        public SubCodec(int protocolVersion) {
            super("STATUS_CHANGE", protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            StatusChangeEvent event = (StatusChangeEvent)message;
            encoder2.writeString(event.changeType, dest);
            encoder2.writeInet(event.address, dest);
        }

        @Override
        public int encodedSize(Message message) {
            StatusChangeEvent event = (StatusChangeEvent)message;
            return PrimitiveSizes.sizeOfString(event.changeType) + PrimitiveSizes.sizeOfInet(event.address);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String changeType = decoder2.readString(source);
            InetSocketAddress address = decoder2.readInet(source);
            return new StatusChangeEvent(changeType, address);
        }
    }
}

