/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.error.ReadFailure;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;

public class WriteFailure
extends Error {
    public final int consistencyLevel;
    public final int received;
    public final int blockFor;
    public final int numFailures;
    public final Map<InetAddress, Integer> reasonMap;
    public final String writeType;

    public WriteFailure(String message, int consistencyLevel, int received, int blockFor, int numFailures, Map<InetAddress, Integer> reasonMap, String writeType) {
        super(5376, message);
        this.consistencyLevel = consistencyLevel;
        this.received = received;
        this.blockFor = blockFor;
        this.numFailures = numFailures;
        this.reasonMap = reasonMap;
        this.writeType = writeType;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(5376, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            WriteFailure writeFailure = (WriteFailure)message;
            encoder2.writeString(writeFailure.message, dest);
            encoder2.writeUnsignedShort(writeFailure.consistencyLevel, dest);
            encoder2.writeInt(writeFailure.received, dest);
            encoder2.writeInt(writeFailure.blockFor, dest);
            if (this.protocolVersion >= 5) {
                ReadFailure.SubCodec.writeReasonMap(writeFailure.reasonMap, dest, encoder2);
            } else {
                encoder2.writeInt(writeFailure.numFailures, dest);
            }
            encoder2.writeString(writeFailure.writeType, dest);
        }

        @Override
        public int encodedSize(Message message) {
            WriteFailure writeFailure = (WriteFailure)message;
            int size2 = PrimitiveSizes.sizeOfString(writeFailure.message) + 2 + 4 + 4 + PrimitiveSizes.sizeOfString(writeFailure.writeType);
            size2 = this.protocolVersion >= 5 ? (size2 += ReadFailure.SubCodec.sizeOfReasonMap(writeFailure.reasonMap)) : (size2 += 4);
            return size2;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            int numFailures;
            Map<Object, Object> reasonMap;
            String message = decoder2.readString(source);
            int consistencyLevel = decoder2.readUnsignedShort(source);
            int received = decoder2.readInt(source);
            int blockFor = decoder2.readInt(source);
            if (this.protocolVersion >= 5) {
                reasonMap = ReadFailure.SubCodec.readReasonMap(source, decoder2);
                numFailures = reasonMap.size();
            } else {
                reasonMap = Collections.emptyMap();
                numFailures = decoder2.readInt(source);
            }
            String writeType = decoder2.readString(source);
            return new WriteFailure(message, consistencyLevel, received, blockFor, numFailures, reasonMap, writeType);
        }
    }
}

