/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;

public class Unavailable
extends Error {
    public final int consistencyLevel;
    public final int required;
    public final int alive;

    public Unavailable(String message, int consistencyLevel, int required, int alive) {
        super(4096, message);
        this.consistencyLevel = consistencyLevel;
        this.required = required;
        this.alive = alive;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(4096, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            Unavailable unavailable = (Unavailable)message;
            encoder2.writeString(unavailable.message, dest);
            encoder2.writeUnsignedShort(unavailable.consistencyLevel, dest);
            encoder2.writeInt(unavailable.required, dest);
            encoder2.writeInt(unavailable.alive, dest);
        }

        @Override
        public int encodedSize(Message message) {
            Unavailable unavailable = (Unavailable)message;
            return PrimitiveSizes.sizeOfString(unavailable.message) + 2 + 4 + 4;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String message = decoder2.readString(source);
            int consistencyLevel = decoder2.readUnsignedShort(source);
            int required = decoder2.readInt(source);
            int alive = decoder2.readInt(source);
            return new Unavailable(message, consistencyLevel, required, alive);
        }
    }
}

