/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;

public class ReadFailure
extends Error {
    public final int consistencyLevel;
    public final int received;
    public final int blockFor;
    public final int numFailures;
    public final Map<InetAddress, Integer> reasonMap;
    public final boolean dataPresent;

    public ReadFailure(String message, int consistencyLevel, int received, int blockFor, int numFailures, Map<InetAddress, Integer> reasonMap, boolean dataPresent) {
        super(4864, message);
        this.consistencyLevel = consistencyLevel;
        this.received = received;
        this.blockFor = blockFor;
        this.numFailures = numFailures;
        this.reasonMap = reasonMap;
        this.dataPresent = dataPresent;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(4864, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            ReadFailure readFailure = (ReadFailure)message;
            encoder2.writeString(readFailure.message, dest);
            encoder2.writeUnsignedShort(readFailure.consistencyLevel, dest);
            encoder2.writeInt(readFailure.received, dest);
            encoder2.writeInt(readFailure.blockFor, dest);
            if (this.protocolVersion >= 5) {
                SubCodec.writeReasonMap(readFailure.reasonMap, dest, encoder2);
            } else {
                encoder2.writeInt(readFailure.numFailures, dest);
            }
            encoder2.writeByte((byte)(readFailure.dataPresent ? 1 : 0), dest);
        }

        @Override
        public int encodedSize(Message message) {
            ReadFailure readFailure = (ReadFailure)message;
            int size2 = PrimitiveSizes.sizeOfString(readFailure.message) + 2 + 4 + 4 + 1;
            size2 = this.protocolVersion >= 5 ? (size2 += SubCodec.sizeOfReasonMap(readFailure.reasonMap)) : (size2 += 4);
            return size2;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            int numFailures;
            Map<Object, Object> reasonMap;
            String message = decoder2.readString(source);
            int consistencyLevel = decoder2.readUnsignedShort(source);
            int received = decoder2.readInt(source);
            int blockFor = decoder2.readInt(source);
            if (this.protocolVersion >= 5) {
                reasonMap = SubCodec.readReasonMap(source, decoder2);
                numFailures = reasonMap.size();
            } else {
                reasonMap = Collections.emptyMap();
                numFailures = decoder2.readInt(source);
            }
            boolean dataPresent = decoder2.readByte(source) != 0;
            return new ReadFailure(message, consistencyLevel, received, blockFor, numFailures, reasonMap, dataPresent);
        }

        static <B> void writeReasonMap(Map<InetAddress, Integer> m, B dest, PrimitiveCodec<B> encoder2) {
            encoder2.writeInt(m.size(), dest);
            for (Map.Entry<InetAddress, Integer> entry2 : m.entrySet()) {
                encoder2.writeInetAddr(entry2.getKey(), dest);
                encoder2.writeUnsignedShort(entry2.getValue(), dest);
            }
        }

        static int sizeOfReasonMap(Map<InetAddress, Integer> m) {
            int size2 = 4;
            for (Map.Entry<InetAddress, Integer> entry2 : m.entrySet()) {
                size2 += PrimitiveSizes.sizeOfInetAddr(entry2.getKey());
                size2 += 2;
            }
            return size2;
        }

        static <B> Map<InetAddress, Integer> readReasonMap(B source, PrimitiveCodec<B> decoder2) {
            int size2 = decoder2.readInt(source);
            if (size2 == 0) {
                return Collections.emptyMap();
            }
            NullAllowingImmutableMap.Builder<InetAddress, Integer> builder = NullAllowingImmutableMap.builder(size2);
            for (int i = 0; i < size2; ++i) {
                InetAddress key = decoder2.readInetAddr(source);
                int value2 = decoder2.readUnsignedShort(source);
                builder.put(key, value2);
            }
            return builder.build();
        }
    }
}

