/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;
import java.util.List;

public class FunctionFailure
extends Error {
    public final String keyspace;
    public final String function;
    public final List<String> argTypes;

    public FunctionFailure(String message, String keyspace, String function, List<String> argTypes) {
        super(5120, message);
        this.keyspace = keyspace;
        this.function = function;
        this.argTypes = argTypes;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(5120, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            FunctionFailure functionFailure = (FunctionFailure)message;
            encoder2.writeString(functionFailure.message, dest);
            encoder2.writeString(functionFailure.keyspace, dest);
            encoder2.writeString(functionFailure.function, dest);
            encoder2.writeStringList(functionFailure.argTypes, dest);
        }

        @Override
        public int encodedSize(Message message) {
            FunctionFailure functionFailure = (FunctionFailure)message;
            return PrimitiveSizes.sizeOfString(functionFailure.message) + PrimitiveSizes.sizeOfString(functionFailure.keyspace) + PrimitiveSizes.sizeOfString(functionFailure.function) + PrimitiveSizes.sizeOfStringList(functionFailure.argTypes);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String message = decoder2.readString(source);
            String keyspace = decoder2.readString(source);
            String function = decoder2.readString(source);
            List<String> argTypes = decoder2.readStringList(source);
            return new FunctionFailure(message, keyspace, function, argTypes);
        }
    }
}

