/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;

public class AlreadyExists
extends Error {
    public final String keyspace;
    public final String table;

    public AlreadyExists(String message, String keyspace, String table2) {
        super(9216, message);
        this.keyspace = keyspace;
        this.table = table2;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(9216, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            AlreadyExists alreadyExists = (AlreadyExists)message;
            encoder2.writeString(alreadyExists.message, dest);
            encoder2.writeString(alreadyExists.keyspace, dest);
            encoder2.writeString(alreadyExists.table, dest);
        }

        @Override
        public int encodedSize(Message message) {
            AlreadyExists alreadyExists = (AlreadyExists)message;
            return PrimitiveSizes.sizeOfString(alreadyExists.message) + PrimitiveSizes.sizeOfString(alreadyExists.keyspace) + PrimitiveSizes.sizeOfString(alreadyExists.table);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String message = decoder2.readString(source);
            String keyspace = decoder2.readString(source);
            String table2 = decoder2.readString(source);
            return new AlreadyExists(message, keyspace, table2);
        }
    }
}

