/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.response.event.SchemaChangeEvent;
import com.datastax.oss.protocol.internal.response.event.StatusChangeEvent;
import com.datastax.oss.protocol.internal.response.event.TopologyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class Event
extends Message {
    public final String type;

    protected Event(String type) {
        super(true, 12);
        this.type = type;
    }

    public static abstract class SubCodec {
        public final String type;
        public final int protocolVersion;

        protected SubCodec(String type, int protocolVersion) {
            this.type = type;
            this.protocolVersion = protocolVersion;
        }

        public abstract <B> void encode(B var1, Message var2, PrimitiveCodec<B> var3);

        public abstract int encodedSize(Message var1);

        public abstract <B> Message decode(B var1, PrimitiveCodec<B> var2);
    }

    public static class Codec
    extends Message.Codec {
        private final Map<String, SubCodec> subDecoders;

        public Codec(int protocolVersion, SubCodec ... subCodecs) {
            super(12, protocolVersion);
            HashMap<String, SubCodec> tmp = new HashMap<String, SubCodec>();
            for (SubCodec subCodec : subCodecs) {
                tmp.put(subCodec.type, subCodec);
            }
            this.subDecoders = Collections.unmodifiableMap(tmp);
        }

        public Codec(int protocolVersion) {
            this(protocolVersion, new TopologyChangeEvent.SubCodec(protocolVersion), new StatusChangeEvent.SubCodec(protocolVersion), new SchemaChangeEvent.SubCodec(protocolVersion));
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            Event event = (Event)message;
            encoder2.writeString(event.type, dest);
            this.getSubCodec(event.type).encode(dest, message, encoder2);
        }

        @Override
        public int encodedSize(Message message) {
            Event event = (Event)message;
            return PrimitiveSizes.sizeOfString(event.type) + this.getSubCodec(event.type).encodedSize(message);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String type = decoder2.readString(source);
            return this.getSubCodec(type).decode(source, decoder2);
        }

        private SubCodec getSubCodec(String type) {
            SubCodec subCodec = this.subDecoders.get(type);
            ProtocolErrors.check(subCodec != null, "Unsupported event type: %s", type);
            return subCodec;
        }
    }
}

